#include "PlayerHelper.h"

#include <al/Library/Player/PlayerHolder.h>
#include <al/Library/LiveActor/ActorMovementFunction.h>

#include <game/GameData/GameDataFunction.h>

namespace PlayerHelper {
    void killPlayer(al::LiveActor *actor) {
        PlayerActorHakoniwa *mainPlayer = (PlayerActorHakoniwa *) al::getPlayerActor(actor, 0);

        GameDataFunction::killPlayer(GameDataHolderAccessor(actor));
        mainPlayer->startDemoPuppetable();
        al::setVelocityZero(mainPlayer);
        mainPlayer->mPlayerAnimator->endSubAnim();
        mainPlayer->mPlayerAnimator->startAnimDead();
    }

    void killPlayer(PlayerActorHakoniwa *mainPlayer) {
        GameDataFunction::killPlayer(GameDataHolderAccessor(mainPlayer));
        mainPlayer->startDemoPuppetable();
        al::setVelocityZero(mainPlayer);
        mainPlayer->mPlayerAnimator->endSubAnim();
        mainPlayer->mPlayerAnimator->startAnimDead();
    }

    void warpPlayer(const char *stageName, GameDataHolderAccessor holder) {
        ChangeStageInfo info(holder.mData, "", stageName, false,
                             -1,
                             ChangeStageInfo::SubScenarioType::UNK);
        GameDataFunction::tryChangeNextStage(holder, &info);
    }
}