#pragma once

#include "al/sensor/HitSensor.h"
#include "al/sensor/SensorHitGroup.h"

#include "al/LiveActor/LiveActor.h" // for SensorMsg
#include "game/Interfaces/IUsePlayerCollision.h"

#include <sead/math/seadVector.h>

namespace al {
class ComboCounter;
class ParabolicPath;
class EventFlowExecutor;
}

namespace rs
{

void setAppearItemFactorAndOffsetByMsg(al::LiveActor const*, al::SensorMsg const*,
                                       al::HitSensor const*);

bool isMsgBreakBySword(al::SensorMsg const*);
bool isMsgStatueDrop(al::SensorMsg const*);
bool isMsgHackerDamageAndCancel(al::SensorMsg const*);
bool isMsgEnableMapCheckPointWarpCollidedGround(al::SensorMsg const*, al::LiveActor const*);
bool isMsgEnableMapCheckPointWarpCollidedGround(al::SensorMsg const*, IUsePlayerCollision const*);
bool isMsgAckCheckpoint(al::SensorMsg const*);
bool isMsgAckGetShine(al::SensorMsg const*);
bool isMsgAckLifeUp(al::SensorMsg const*);
bool isMsgAckLifeMaxUp(al::SensorMsg const*);
bool isMsgAskRailCollision(al::SensorMsg const*);
bool isMsgAttachCactusNeedle(al::SensorMsg const*);
bool isMsgAirExplosion(al::SensorMsg const*);
bool isMsgBelowObjBroken(al::SensorMsg const*);
bool isMsgBindCollidedGround(al::SensorMsg const*);
bool isMsgBindKeepDemoStart(al::SensorMsg const*);
bool isMsgBindKeepDemoExecute(al::SensorMsg const*);
bool isMsgBindKeepDemoEnd(al::SensorMsg const*);
bool isMsgBindRecoveryLife(al::SensorMsg const*);
bool isMsgBirdFlyAway(al::SensorMsg const*);
bool isMsgBlowObjAttack(al::SensorMsg const*);
bool isMsgMayorItemCollide(al::SensorMsg const*);
bool isMsgMayorItemReflect(al::SensorMsg const*);
bool isMsgBlowObjAttackReflect(al::SensorMsg const*);
bool isMsgBossKnuckleCounter(al::SensorMsg const*);
bool isMsgBossKnuckleFallAttack(al::SensorMsg const*);
bool isMsgBossKnuckleHackAttack(al::SensorMsg const*);
bool isMsgBossKnuckleIceConflict(al::SensorMsg const*);
bool isMsgBossKnuckleIceFallToMummy(al::SensorMsg const*);
bool isMsgBossKnuckleKillerAttack(al::SensorMsg const*);
bool isMsgBreakPartsBreak(al::SensorMsg const*);
bool isMsgBreedaSlap(al::SensorMsg const*);
bool isMsgBreedaPush(al::SensorMsg const*);
bool isMsgBubbleAttack(al::SensorMsg const*);
bool isMsgBubbleAttackToPecho(al::SensorMsg const*);
bool isMsgBubbleLauncherStart(al::SensorMsg const*);
bool isMsgBubbleReflectH(al::SensorMsg const*);
bool isMsgBubbleReflectV(al::SensorMsg const*);
bool isMsgBubbleWallTouch(al::SensorMsg const*);
bool isMsgBubbleGroundTouchTrigger(al::SensorMsg const*);
bool isMsgBullAttack(al::SensorMsg const*);
bool isMsgBullHackAttack(al::SensorMsg const*);
bool isMsgBullEnemyAttack(al::SensorMsg const*);
bool isMsgByugoBlow(al::SensorMsg const*);
bool isMsgCameraAngleElevationResetFast(al::SensorMsg const*);
bool isMsgCancelHack(al::SensorMsg const*);
bool isMsgCancelHackArea(al::SensorMsg const*);
bool isMsgCancelHackByDokan(al::SensorMsg const*);
bool isMsgCapAttack(al::SensorMsg const*);
bool isMsgCapAttackCollide(al::SensorMsg const*);
bool isMsgCapAttackRailMove(al::SensorMsg const*);
bool isMsgCapAttackStayRolling(al::SensorMsg const*);
bool isMsgCapAttackStayRollingCollide(al::SensorMsg const*);
bool isMsgCapBeamerBeam(al::SensorMsg const*);
bool isMsgCapCancelLockOn(al::SensorMsg const*);
bool isMsgCapChangeGiant(al::SensorMsg const*);
bool isMsgCapEnableLockOn(al::SensorMsg const*);
bool isMsgCapStartLockOn(al::SensorMsg const*);
bool isMsgCapKeepLockOn(al::SensorMsg const*);
bool isMsgCapGiantAttack(al::SensorMsg const*);
bool isMsgCapHipDrop(al::SensorMsg const*);
bool isMsgCapObjHipDrop(al::SensorMsg const*);
bool isMsgCapObjHipDropReflect(al::SensorMsg const*);
bool isMsgCapIgnoreCancelLockOn(al::SensorMsg const*);
bool isMsgCapIgnoreCancelMissReaction(al::SensorMsg const*);
bool isMsgCapIgnoreCollisionCheck(al::SensorMsg const*);
bool isMsgCapItemGet(al::SensorMsg const*);
bool isMsgCapReflect(al::SensorMsg const*);
bool isMsgCapReflectCollide(al::SensorMsg const*);
bool isMsgCapRethrow(al::SensorMsg const*);
bool isMsgCapTouchWall(al::SensorMsg const*);
bool isMsgCapTrampolineAttack(al::SensorMsg const*);
bool isMsgCatchBombThrough(al::SensorMsg const*);
bool isMsgCheckCarObstacle(al::SensorMsg const*);
bool isMsgCheckIsCardboardBox(al::SensorMsg const*);
bool isMsgChorobonAttack(al::SensorMsg const*);
bool isMsgClearFire(al::SensorMsg const*);
bool isMsgCollectAnimalTouchCollide(al::SensorMsg const*);
bool isMsgCollisionImpulse(al::SensorMsg const*);
bool isMsgConductLightning(al::SensorMsg const*);
bool isMsgConfirmFrailBox(al::SensorMsg const*);
bool isMsgConfirmBrokenFrailBox(al::SensorMsg const*);
bool isMsgDamageBallAttack(al::SensorMsg const*);
bool isMsgDamageBallBodyAttack(al::SensorMsg const*);
bool isMsgDigPointSmell(al::SensorMsg const*);
bool isMsgDonsukeAttack(al::SensorMsg const*);
bool isMsgDonsukeGroundAttack(al::SensorMsg const*);
bool isMsgDonsukePush(al::SensorMsg const*);
bool isMsgDragonAttack(al::SensorMsg const*);
bool isMsgEatExplosion(al::SensorMsg const*);
bool isMsgElectricWireNoLimitDistance(al::SensorMsg const*);
bool isMsgEnableInSaucePan(al::SensorMsg const*);
bool isMsgEnableMapCheckPointWarp(al::SensorMsg const*);
bool isMsgEndInSaucePan(al::SensorMsg const*);
bool isMsgEnemyAttack2D(al::SensorMsg const*);
bool isMsgEnemyAttack3D(al::SensorMsg const*);
bool isMsgEnemyAttackDash(al::SensorMsg const*);
bool isMsgFireBrosFireBallCollide(al::SensorMsg const*);
bool isMsgFireDamageAll(al::SensorMsg const*);
bool isMsgHackAttackFire(al::SensorMsg const*);
bool isMsgFireSwitchFire(al::SensorMsg const*);
bool isMsgEnemyAttackFireCollision(al::SensorMsg const*);
bool isMsgEnemyAttackTRex(al::SensorMsg const*);
bool isMsgPoisonDamageAll(al::SensorMsg const*);
bool isMsgEnemyAttackPoison(al::SensorMsg const*);
bool isMsgHackAttackPoison(al::SensorMsg const*);
bool isMsgPaintAttackPoison(al::SensorMsg const*);
bool isMsgConfirmPaintObj(al::SensorMsg const*);
bool isMsgConfirmPaintObjForSeed(al::SensorMsg const*);
bool isMsgEnemyAttackStrong(al::SensorMsg const*);
bool isMsgEnemyKick(al::SensorMsg const*);
bool isMsgRabbitKick(al::SensorMsg const*);
bool isMsgEnemyObjBreak(al::SensorMsg const*);
bool isMsgFireBlowerAttack(al::SensorMsg const*);
bool isMsgFishingAttack(al::SensorMsg const*);
bool isMsgFishingCancel(al::SensorMsg const*);
bool isMsgFishingFishApproach(al::SensorMsg const*);
bool isMsgFishingFishFloatTouch(al::SensorMsg const*);
bool isMsgFishingItemGet(al::SensorMsg const*);
bool isMsgFishingLineTouch(al::SensorMsg const*);
bool isMsgFishingStart(al::SensorMsg const*);
bool isMsgFishingUpImmediately(al::SensorMsg const*);
bool isMsgFishingUpImmediatelyPrepare(al::SensorMsg const*);
bool isMsgFishingWait(al::SensorMsg const*);
bool isMsgFrogHackTrample(al::SensorMsg const*);
bool isMsgGamaneBullet(al::SensorMsg const*);
bool isMsgGamaneBulletThrough(al::SensorMsg const*);
bool isMsgGamaneBulletForCoinFlower(al::SensorMsg const*);
bool isMsgGemyAim(al::SensorMsg const*);
bool isMsgGhostCancel(al::SensorMsg const*);
bool isMsgGhostPlay(al::SensorMsg const*);
bool isMsgGhostRecordEnd(al::SensorMsg const*);
bool isMsgGhostRecordStart(al::SensorMsg const*);
bool isMsgGhostRecordStartOk(al::SensorMsg const*);
bool isMsgGhostReverse(al::SensorMsg const*);
bool isMsgGhostStop(al::SensorMsg const*);
bool isMsgGiantWanderBossAttack(al::SensorMsg const*);
bool isMsgGiantWanderBossBulletAttack(al::SensorMsg const*);
bool isMsgGiantWanderBossBulletPush(al::SensorMsg const*);
bool isMsgGoldHammerAttack(al::SensorMsg const*);
bool isMsgGrowFlowerSeedDisablePush(al::SensorMsg const*);
bool isMsgGrowFlowerSeedNear(al::SensorMsg const*);
bool isMsgGrowPlantPush(al::SensorMsg const*);
bool isMsgGrowerAttack(al::SensorMsg const*);
bool isMsgGrowerWallAttack(al::SensorMsg const*);
bool isMsgGunetterAttack(al::SensorMsg const*);
bool isMsgGunetterBodyTouch(al::SensorMsg const*);
bool isMsgGunetterPush(al::SensorMsg const*);
bool isMsgHackAttack(al::SensorMsg const*);
bool isMsgHackAttackKick(al::SensorMsg const*);
bool isMsgHackAttackMapObj(al::SensorMsg const*);
bool isMsgHackBrosContact(al::SensorMsg const*);
bool isMsgHackDeathAreaSelfCheck(al::SensorMsg const*);
bool isMsgHackDemoEnd(al::SensorMsg const*);
bool isMsgHackDemoStart(al::SensorMsg const*);
bool isMsgHackInvalidEscape(al::SensorMsg const*);
bool isMsgHackInvalidEscapeNoReaction(al::SensorMsg const*);
bool isMsgHackMarioCheckpointFlagWarp(al::SensorMsg const*);
bool isMsgHackMarioDead(al::SensorMsg const*);
bool isMsgHackMarioDemo(al::SensorMsg const*);
bool isMsgHackMarioInWater(al::SensorMsg const*);
bool isMsgHackMoveRockForestPush(al::SensorMsg const*);
bool isMsgHackSelfCeilingCheckMiss(al::SensorMsg const*);
bool isMsgHackSyncDamageVisibility(al::SensorMsg const*);
bool isMsgHackUpperPunch(al::SensorMsg const*);
bool isMsgHackObjUpperPunch(al::SensorMsg const*);
bool isMsgHammerAttackDown(al::SensorMsg const*);
bool isMsgHammerAttackSide(al::SensorMsg const*);
bool isMsgHammerAttackSideCollide(al::SensorMsg const*);
bool isMsgHammerBrosHammerEnemyAttack(al::SensorMsg const*);
bool isMsgHammerBrosHammerHackAttack(al::SensorMsg const*);
bool isMsgHammerBrosHammerSearch(al::SensorMsg const*);
bool isMsgHipDropTransformReverse(al::SensorMsg const*);
bool isMsgHipDropTransformTransform(al::SensorMsg const*);
bool isMsgHipDropTransformingUp(al::SensorMsg const*);
bool isMsgHipDropTransformingDown(al::SensorMsg const*);
bool isMsgHipDropTransformingFinish(al::SensorMsg const*);
bool isMsgHitGrowFlowerPot(al::SensorMsg const*);
bool isMsgHitGrowPlantPot(al::SensorMsg const*);
bool isMsgHosuiAttack(al::SensorMsg const*);
bool isMsgHosuiAttackCollide(al::SensorMsg const*);
bool isMsgHosuiAttackNoEffect(al::SensorMsg const*);
bool isMsgHosuiAttackStrong(al::SensorMsg const*);
bool isMsgHosuiTouch(al::SensorMsg const*);
bool isMsgHosuiTrample(al::SensorMsg const*);
bool isMsgHosuiTrampleReflect(al::SensorMsg const*);
bool isMsgHosuiTrampleReflectHigh(al::SensorMsg const*);
bool isMsgIgnoreTouchTarget(al::SensorMsg const*);
bool isMsgIgnorePushMotorcycle(al::SensorMsg const*);
bool isMsgIcicleAttack(al::SensorMsg const*);
bool isMsgIgnoreMirrorWarp(al::SensorMsg const*);
bool isMsgIgnoredByRunawayNpc(al::SensorMsg const*);
bool isMsgImplantGrowFlowerSeed(al::SensorMsg const*);
bool isMsgInitTouchTargetInfo(al::SensorMsg const*);
bool isMsgItemAmiiboKoopa(al::SensorMsg const*);
bool isMsgIsExistPukupuku(al::SensorMsg const*);
bool isMsgJangoAttack(al::SensorMsg const*);
bool isMsgJangoRemoveCap(al::SensorMsg const*);
bool isMsgKakkuKick(al::SensorMsg const*);
bool isMsgKoopaBindStart(al::SensorMsg const*);
bool isMsgKoopaCapPlayerFocusTarget(al::SensorMsg const*);
bool isMsgKoopaCapPunchFinishL(al::SensorMsg const*);
bool isMsgKoopaCapPunchFinishR(al::SensorMsg const*);
bool isMsgKoopaCapPunchInvincibleL(al::SensorMsg const*);
bool isMsgKoopaCapPunchInvincibleR(al::SensorMsg const*);
bool isMsgKoopaCapPunchKnockBackL(al::SensorMsg const*);
bool isMsgKoopaCapPunchKnockBackR(al::SensorMsg const*);
bool isMsgKoopaCapPunchL(al::SensorMsg const*);
bool isMsgKoopaCapPunchR(al::SensorMsg const*);
bool isMsgKoopaCapSpinAttack(al::SensorMsg const*);
bool isMsgKoopaCatchKoopaCap(al::SensorMsg const*);
bool isMsgKoopaDashPunchAttack(al::SensorMsg const*);
bool isMsgKoopaFire2D(al::SensorMsg const*);
bool isMsgKoopaFireBallAttack(al::SensorMsg const*);
bool isMsgKoopaHackDamage(al::SensorMsg const*);
bool isMsgKoopaHackPunch(al::SensorMsg const*);
bool isMsgKoopaHackPunchCollide(al::SensorMsg const*);
bool isMsgKoopaHackTrample(al::SensorMsg const*);
bool isMsgKoopaInvalidHackPunchFaceToCollision(al::SensorMsg const*);
bool isMsgKoopaRingBeamInvalidTouch(al::SensorMsg const*);
bool isMsgKoopaTailAttack(al::SensorMsg const*);
bool isMsgKoopaTouchFloor(al::SensorMsg const*);
bool isMsgKouraAttack2D(al::SensorMsg const*);
bool isMsgKouraItemGet2D(al::SensorMsg const*);
bool isMsgKuribo2DTouch(al::SensorMsg const*);
bool isMsgKuriboCollisionDamage(al::SensorMsg const*);
bool isMsgKuriboCollisionKill(al::SensorMsg const*);
bool isMsgKuriboFlick(al::SensorMsg const*);
bool isMsgKuriboGirlAttack(al::SensorMsg const*);
bool isMsgKuriboGirlLove(al::SensorMsg const*);
bool isMsgKuriboTop(al::SensorMsg const*);
bool isMsgKuriboTowerNum(al::SensorMsg const*);
bool isMsgLaunchBlow(al::SensorMsg const*);
bool isMsgLineDancerLink(al::SensorMsg const*);
bool isMsgLongPushSensorHit(al::SensorMsg const*);
bool isMsgLongPushBoxHit(al::SensorMsg const*);
bool isMsgMagnetBulletAttack(al::SensorMsg const*);
bool isMsgMeganeAttack(al::SensorMsg const*);
bool isMsgMeganeHackTrample(al::SensorMsg const*);
bool isMsgMofumofuBodyChainExplode(al::SensorMsg const*);
bool isMsgMofumofuBulletUnexplosion(al::SensorMsg const*);
bool isMsgMoonBasementAttackMeteor(al::SensorMsg const*);
bool isMsgMoonBasementBreakShockwaveMeteor(al::SensorMsg const*);
bool isMsgMoonBasementRockSyncClippingRegist(al::SensorMsg const*);
bool isMsgMoonBasementRockSyncClippingInvalidate(al::SensorMsg const*);
bool isMsgMoonBasementRockSyncClippingValidate(al::SensorMsg const*);
bool isMsgMoonBasementRockThroughCollision(al::SensorMsg const*);
bool isMsgMorningStarWarpEnd(al::SensorMsg const*);
bool isMsgMorningStarWarpStart(al::SensorMsg const*);
bool isMsgMotorcycleAttack(al::SensorMsg const*);
bool isMsgMotorcycleCollideParkingLot(al::SensorMsg const*);
bool isMsgMotorcycleDashAttack(al::SensorMsg const*);
bool isMsgMotorcycleDashCollide(al::SensorMsg const*);
bool isMsgCactusNeedleAttack(al::SensorMsg const*);
bool isMsgCactusNeedleAttackStrong(al::SensorMsg const*);
bool isMsgNoLimitTouchJump(al::SensorMsg const*);
bool isMsgNoticePlayerDamage(al::SensorMsg const*);
bool isMsgNpcScareByEnemy(al::SensorMsg const*);
bool isMsgVolleyballNpcScareByEnemy(al::SensorMsg const*);
bool isMsgObjSnapForce(al::SensorMsg const*);
bool isMsgPackunEatCancel(al::SensorMsg const*);
bool isMsgPackunEatEnd(al::SensorMsg const*);
bool isMsgPackunEatStart(al::SensorMsg const*);
bool isMsgPackunEatStartFollow(al::SensorMsg const*);
bool isMsgPaint(al::SensorMsg const*);
bool isMsgPaintTexture(al::SensorMsg const*);
bool isMsgCheckPaintClear(al::SensorMsg const*);
bool isMsgCheckPaintAlpha(al::SensorMsg const*);
bool isMsgPartyPopperSoundAttack(al::SensorMsg const*);
bool isMsgPechoSpot(al::SensorMsg const*);
bool isMsgPlayerBallToss(al::SensorMsg const*);
bool isMsgPlayerCarryCameraSubjectiveStart(al::SensorMsg const*);
bool isMsgPlayerCarryCameraSubjectiveEnd(al::SensorMsg const*);
bool isMsgPlayerCarryShineGetStart(al::SensorMsg const*);
bool isMsgPlayerCarryShineGetEnd(al::SensorMsg const*);
bool isMsgPlayerCapCatch(al::SensorMsg const*);
bool isMsgPlayerCapHipDrop(al::SensorMsg const*);
bool isMsgPlayerCapPush(al::SensorMsg const*);
bool isMsgPlayerCapRecovery(al::SensorMsg const*);
bool isMsgPlayerCapTouchJump(al::SensorMsg const*);
bool isMsgPlayerCapTrample(al::SensorMsg const*);
bool isMsgPlayerCoinDashGet(al::SensorMsg const*);
bool isMsgPlayerEyePriorityTarget(al::SensorMsg const*);
bool isMsgPlayerDisregardHomingAttack(al::SensorMsg const*);
bool isMsgPlayerDisregardTargetMarker(al::SensorMsg const*);
bool isMsgPlayerEquipKoopaCap(al::SensorMsg const*);
bool isMsgPlayerFireBallAttack2D(al::SensorMsg const*);
bool isMsgPlayerFireBallAttack3D(al::SensorMsg const*);
bool isMsgPlayerHipDropDemoTrigger(al::SensorMsg const*);
bool isMsgPlayerHipDropHipDropSwitch(al::SensorMsg const*);
bool isMsgPlayerItemGet2D(al::SensorMsg const*);
bool isMsgPlayerJumpTakeOffFloor(al::SensorMsg const*);
bool isMsgPlayerObjectWallHit(al::SensorMsg const*);
bool isMsgPlayerObjLeapFrog(al::SensorMsg const*);
bool isMsgPlayerPenguinAttack(al::SensorMsg const*);
bool isMsgPlayerPenguinAttackReflect(al::SensorMsg const*);
bool isMsgPlayerPoleClimbKeep(al::SensorMsg const*);
bool isMsgPlayerPoleClimbReaction(al::SensorMsg const*);
bool isMsgPlayerRabbitGet(al::SensorMsg const*);
bool isMsgPlayerRollingObjHit(al::SensorMsg const*);
bool isMsgPlayerRollingWallHitDown(al::SensorMsg const*);
bool isMsgPlayerRollingWallHitMove(al::SensorMsg const*);
bool isMsgPlayerStartGrabCeil(al::SensorMsg const*);
bool isMsgPlayerStartWallJump(al::SensorMsg const*);
bool isMsgPlayerEndGrabCeil(al::SensorMsg const*);
bool isMsgPlayerSwordAttack(al::SensorMsg const*);
bool isMsgPlayerTouchFloorJumpCode(al::SensorMsg const*);
bool isMsgPlayerTrample2D(al::SensorMsg const*);
bool isMsgPlayerUpperPunch2D(al::SensorMsg const*);
bool isMsgPlayerObjUpperPunch2D(al::SensorMsg const*);
bool isMsgPropellerAttack(al::SensorMsg const*);
bool isMsgPukupukuDash(al::SensorMsg const*);
bool isMsgPukupukuKiss(al::SensorMsg const*);
bool isMsgPukupukuRollingAttack(al::SensorMsg const*);
bool isMsgPunchMachinePunchHook(al::SensorMsg const*);
bool isMsgPunchMachinePunchStraight(al::SensorMsg const*);
bool isMsgPunchMachinePunchUpper(al::SensorMsg const*);
bool isMsgPush2D(al::SensorMsg const*);
bool isMsgPushToFish(al::SensorMsg const*);
bool isMsgPushToMotorcycle(al::SensorMsg const*);
bool isMsgPushToPlayer(al::SensorMsg const*);
bool isMsgRadishAttack(al::SensorMsg const*);
bool isMsgRadishReflect(al::SensorMsg const*);
bool isMsgRaceStart(al::SensorMsg const*);
bool isMsgRaceStop(al::SensorMsg const*);
bool isMsgRaceWait(al::SensorMsg const*);
bool isMsgRequestChangeFireFlower(al::SensorMsg const*);
bool isMsgRequestChangeKinokoSuper(al::SensorMsg const*);
bool isMsgRequestPlayerJumpBreakFloor(al::SensorMsg const*);
bool isMsgRequestPlayerJump(al::SensorMsg const*);
bool isMsgRequestPlayerTrampleJump(al::SensorMsg const*);
bool isMsgRequestPlayerSpinJump(al::SensorMsg const*);
bool isMsgRequestSphinxJump(al::SensorMsg const*);
bool isMsgRideOnEnd(al::SensorMsg const*);
bool isMsgRideOnRelease(al::SensorMsg const*);
bool isMsgRideOnStart(al::SensorMsg const*);
bool isMsgRocketFlowerExtension(al::SensorMsg const*);
bool isMsgSandSharkAttack(al::SensorMsg const*);
bool isMsgSeedAttack(al::SensorMsg const*);
bool isMsgSeedAttackBig(al::SensorMsg const*);
bool isMsgSeedAttackHold(al::SensorMsg const*);
bool isMsgSeedItemGet(al::SensorMsg const*);
bool isMsgSeedReflect(al::SensorMsg const*);
bool isMsgSeedTouch(al::SensorMsg const*);
bool isMsgSenobiCancelStretch(al::SensorMsg const*);
bool isMsgSenobiPunchBlockTransparent(al::SensorMsg const*);
bool isMsgSenobiPartsMove(al::SensorMsg const*);
bool isMsgSenobiTrample(al::SensorMsg const*);
bool isMsgShibakenApproach(al::SensorMsg const*);
bool isMsgShibakenKick(al::SensorMsg const*);
bool isMsgSkaterAttack(al::SensorMsg const*);
bool isMsgSpherePush(al::SensorMsg const*);
bool isMsgSphinxJumpAttack(al::SensorMsg const*);
bool isMsgSphinxQuizRouteKill(al::SensorMsg const*);
bool isMsgSphinxRideAttack(al::SensorMsg const*);
bool isMsgSphinxRideAttackReflect(al::SensorMsg const*);
bool isMsgSphinxRideAttackTouchThrough(al::SensorMsg const*);
bool isMsgSphinxRideAttackTouch(al::SensorMsg const*);
bool isMsgStampTo2D(al::SensorMsg const*);
bool isMsgStartHack(al::SensorMsg const*);
bool isMsgStartInSaucePan(al::SensorMsg const*);
bool isMsgStatueDrop(al::SensorMsg const*);
bool isMsgStatueTrampleReflect(al::SensorMsg const*);
bool isMsgStatuePush(al::SensorMsg const*);
bool isMsgStatueSnap(al::SensorMsg const*);
bool isMsgSunshineAttack(al::SensorMsg const*);
bool isMsgTankBullet(al::SensorMsg const*);
bool isMsgTankBulletNoReaction(al::SensorMsg const*);
bool isMsgTankExplosion(al::SensorMsg const*);
bool isMsgTankHackTrample(al::SensorMsg const*);
bool isMsgTankKickHack(al::SensorMsg const*);
bool isMsgTankKickEnemy(al::SensorMsg const*);
bool isMsgTankLookOn(al::SensorMsg const*);
bool isMsgTestPunch(al::SensorMsg const*);
bool isMsgTestPunchStrong(al::SensorMsg const*);
bool isMsgTimerAthleticDemoStart(al::SensorMsg const*);
bool isMsgTouchDoorDrumn(al::SensorMsg const*);
bool isMsgTouchFireDrum2D(al::SensorMsg const*);
bool isMsgTrashBoxIn(al::SensorMsg const*);
bool isMsgTRexAttack(al::SensorMsg const*);
bool isMsgTRexAttackCollideAll(al::SensorMsg const*);
bool isMsgTRexAttackCollideBody(al::SensorMsg const*);
bool isMsgTRexAttackCollideHead(al::SensorMsg const*);
bool isMsgTRexDashAttack(al::SensorMsg const*);
bool isMsgTRexScrollPartsBreakWith(al::SensorMsg const*);
bool isMsgTsukkunForceCancelCollide(al::SensorMsg const*);
bool isMsgTsukkunHoldCollide(al::SensorMsg const*);
bool isMsgTsukkunThroughCollide(al::SensorMsg const*);
bool isMsgTsukkunThrustAll(al::SensorMsg const*);
bool isMsgTsukkunThrust(al::SensorMsg const*, bool*);
bool isMsgTsukkunThrustCollide(al::SensorMsg const*, bool*);
bool isMsgTsukkunNoTrace(al::SensorMsg const*);
bool isMsgTsukkunThrustHole(al::SensorMsg const*);
bool isMsgUtsuboAttack(al::SensorMsg const*);
bool isMsgWanderBossCameraRange(al::SensorMsg const*);
bool isMsgWanwanEnemyAttack(al::SensorMsg const*);
bool isMsgWanwanBlockAttack(al::SensorMsg const*);
bool isMsgWanwanHoleIn(al::SensorMsg const*);
bool isMsgWaterRoadIn(al::SensorMsg const*);
bool isMsgWaterRoadNear(al::SensorMsg const*);
bool isMsgWanwanPush(al::SensorMsg const*);
bool isMsgWanwanReboundAttack(al::SensorMsg const*);
bool isMsgWeaponItemGet(al::SensorMsg const*);
bool isMsgWhipAttack(al::SensorMsg const*);
bool isMsgWhipBind(al::SensorMsg const*);
bool isMsgWhipHold(al::SensorMsg const*);
bool isMsgWhipThrow(al::SensorMsg const*);
bool isMsgYokinBallAttack(al::SensorMsg const*);
bool isMsgYoshiDirectEat(al::SensorMsg const*);
bool isMsgYoshiTongueAttack(al::SensorMsg const*);
bool isMsgYoshiTongueEatBind(al::SensorMsg const*);
bool isMsgYoshiTongueEatBindCancel(al::SensorMsg const*);
bool isMsgYoshiTongueEatBindFinish(al::SensorMsg const*);
bool isMsgYoshiTongueEatHomingTarget(al::SensorMsg const*);
bool isMsgYukimaruPush(al::SensorMsg const*);
bool isMsgKillerAttackNoExplode(al::SensorMsg const*);
bool isMsgKillerMagnumAttack(al::SensorMsg const*);
bool isMsgKillerMagnumHackAttack(al::SensorMsg const*);
bool isMsgGabuzouAttack(al::SensorMsg const*);
bool isMsgStackerRollingAttack(al::SensorMsg const*);
bool isMsgStackerCapBoostAttack(al::SensorMsg const*);
bool isMsgIgnoreIgnitionBomb(al::SensorMsg const*);
bool isMsgExplosionReflectBomb(al::SensorMsg const*);
bool isMsgGolemStampPress(al::SensorMsg const*);
bool isMsgTsukkunThrustSpin(al::SensorMsg const*, bool*);
bool isMsgTsukkunThrustReflect(al::SensorMsg const*, bool*);
bool isMsgTsukkunThrustHitReflectCollide(al::SensorMsg const*, bool*);
bool isMsgTsukkunThrustReflectCollide(al::SensorMsg const*, bool*);
bool isMsgSwitchOnWithSaveRequest(al::SensorMsg const*, struct SaveObjInfo**);
bool isMsgNpcCapReactionAll(al::SensorMsg const*);
bool isMsgHackNpcCapReactionAll(al::SensorMsg const*);
bool isMsgPlayerAndCapObjHipDropReflectAll(al::SensorMsg const*);
bool isMsgKoopaCapPunchAll(al::SensorMsg const*);
bool isMsgKoopaCapPunchInvincibleAll(al::SensorMsg const*);
bool isMsgKoopaCapPunchFinishAll(al::SensorMsg const*);
bool isMsgItemGet(al::SensorMsg const*);
bool isMsgItemGetByWeapon(al::SensorMsg const*);
bool isMsgItemGet2D(al::SensorMsg const*);
bool isMsgBlockUpperPunch2D(al::SensorMsg const*);
bool isMsgItemGetAll(al::SensorMsg const*);
bool isMsgShineGet(al::SensorMsg const*);
bool isMsgShineGet2D(al::SensorMsg const*);
bool isMsgShineReaction(al::SensorMsg const*);
bool isMsgKillByShineGet(al::SensorMsg const*);
bool isMsgKillByHomeDemo(al::SensorMsg const*);
bool isMsgEndHomeDemo(al::SensorMsg const*);
bool isMsgBreakBySword(al::SensorMsg const*);
bool isMsgPressDown(al::SensorMsg const*);
bool isMsgPlayerAndCapObjHipDropAll(al::SensorMsg const*);
bool isMsgAttackDirect(al::SensorMsg const*);
bool isMsgBlowDown(al::SensorMsg const*);
bool isMsgTrampleReflectAll(al::SensorMsg const*);
bool isMsgThrowObjHit(al::SensorMsg const*);
bool isMsgThrowObjHitReflect(al::SensorMsg const*);
bool isMsgPlayerAndCapHipDropAll(al::SensorMsg const*);
bool isMsgUpperPunchAll(al::SensorMsg const*);
bool isMsgBlockReaction2D(al::SensorMsg const*);
bool isMsgBlockReaction3D(al::SensorMsg const*);
bool isMsgBlockReactionAll(al::SensorMsg const*);
bool isMsgBreakFrailBox(al::SensorMsg const*);
bool isMsgDamageFrailBox(al::SensorMsg const*);
bool isMsgChorobonReaction(al::SensorMsg const*);
bool isMsgBreakSignBoard(al::SensorMsg const*);
bool isMsgBreakCollapseSandHill(al::SensorMsg const*);
bool isMsgPlayerDamage(al::SensorMsg const*);
bool isMsgPlayerDamage2D(al::SensorMsg const*);
bool isMsgPlayerDamageBlowDown(al::SensorMsg const*);
bool isMsgPlayerJumpRequestAll(al::SensorMsg const*);
bool isMsgDashPanel(al::SensorMsg const*, int*);
bool isMsgNetworkShootingShot(al::SensorMsg const*, int);
bool isMsgNetworkShootingChargeShot(al::SensorMsg const*, int);
bool isMsgRaceReturnToCourse(al::SensorMsg const*, sead::Vector3f*, sead::Vector3f*);
bool isMsgTrampolineCrackJump(float*, float*, al::SensorMsg const*);
bool isMsgGotogotonOn(al::SensorMsg const*);
bool isMsgGotogotonGoalExist(al::SensorMsg const*);
bool isMsgBossMagmaCatchPlayer(al::SensorMsg const*);
bool isMsgBossMagmaReleasePlayer(al::SensorMsg const*);
bool isMsgBossMagmaDeadDemoStart(al::SensorMsg const*);
bool isMsgBossMagmaDeadDemoEnd(al::SensorMsg const*);
bool isMsgBossMagmaQueryToBubble(al::SensorMsg const*);
bool isMsgMofumofuReflectAll(al::SensorMsg const*);
bool isMsgCheckFishingTarget(al::SensorMsg const*);
bool isMsgPlayerLookAtPosition(al::SensorMsg const*);
bool isMsgTargetMarkerPosition(al::SensorMsg const*);
bool isMsgSandGeyserRaise(al::SensorMsg const*);
bool isMsgInitCapTarget(al::SensorMsg const*);
bool isMsgTransferHack(al::SensorMsg const*);
bool isMsgRequestTransferHack(al::SensorMsg const*);
bool isMsgInitHack(al::SensorMsg const*);
bool isMsgEndHack(struct HackEndParam const**, al::SensorMsg const*);
bool isMsgHackDirectStageInit(struct IUsePlayerHack**, al::SensorMsg const*);
bool isMsgKillByBossBattleDemo(al::SensorMsg const*);
bool isMsgKillByHackFirstDemo(al::SensorMsg const*);
bool isMsgKillByMoonRockDemo(al::SensorMsg const*);
bool isMsgKillBySwitchTimer(al::SensorMsg const*);

bool setMsgYoshiTongueEatBindRadiusAndOffset(al::SensorMsg const*, float, float);
bool setMsgYoshiTongueEatBindScale(al::SensorMsg const*, float);
bool setMsgPlayerLookAtPosition(al::SensorMsg const*, sead::Vector3f const&);
bool setMsgTargetMarkerPosition(al::SensorMsg const*, sead::Vector3f const&);

bool requestHitReactionToAttacker(al::SensorMsg const*, al::HitSensor const*, al::HitSensor const*);

bool sendMsgHackerNoReaction(IUsePlayerHack const*, al::HitSensor*, al::HitSensor*);
bool sendMsgHackerNoReactionWithoutShine(IUsePlayerHack const*, al::HitSensor*, al::HitSensor*);
bool sendMsgBreakFloorToPlayer(al::LiveActor const*);
bool sendMsgAckCheckpoint(al::HitSensor*, al::HitSensor*);
bool sendMsgAckGetShine(al::HitSensor*, al::HitSensor*);
bool sendMsgAckLifeUp(al::HitSensor*, al::HitSensor*);
bool sendMsgAckLifeMaxUp(al::HitSensor*, al::HitSensor*);
bool sendMsgAskRailCollision(al::HitSensor*, al::HitSensor*);
bool sendMsgBreakPartsBreak(al::HitSensor*, al::HitSensor*);
bool sendMsgBirdFlyAway(al::HitSensor*, al::HitSensor*);
bool sendMsgCameraAngleElevationResetFast(al::HitSensor*, al::HitSensor*);
bool sendMsgChorobonAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgConductLightning(al::HitSensor*, al::HitSensor*);
bool sendMsgDamageBallAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgDamageBallBodyAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgDonsukeAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgDonsukeGroundAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgDonsukePush(al::HitSensor*, al::HitSensor*);
bool sendMsgDragonAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgEatExplosion(al::HitSensor*, al::HitSensor*);
bool sendMsgElectricWireNoLimitDistance(al::HitSensor*, al::HitSensor*);
bool sendMsgEnemyAttack2D(al::HitSensor*, al::HitSensor*);
bool sendMsgEnemyAttack3D(al::HitSensor*, al::HitSensor*);
bool sendMsgEnemyAttackDash(al::HitSensor*, al::HitSensor*);
bool sendMsgHackAttackFire(al::HitSensor*, al::HitSensor*);
bool sendMsgEnemyAttackFireCollision(al::HitSensor*, al::HitSensor*);
bool sendMsgEnemyAttackPoison(al::HitSensor*, al::HitSensor*);
bool sendMsgEnemyAttackTRex(al::HitSensor*, al::HitSensor*);
bool sendMsgHackAttackPoison(al::HitSensor*, al::HitSensor*);
bool sendMsgConfirmPaintObj(al::HitSensor*, al::HitSensor*);
bool sendMsgConfirmPaintObjForSeed(al::HitSensor*, al::HitSensor*);
bool sendMsgPaintAttackPoison(al::HitSensor*, al::HitSensor*);
bool sendMsgEnemyKick(al::HitSensor*, al::HitSensor*);
bool sendMsgRabbitKick(al::HitSensor*, al::HitSensor*);
bool sendMsgFishingAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgFishingCancel(al::HitSensor*, al::HitSensor*);
bool sendMsgFishingFishApproach(al::HitSensor*, al::HitSensor*);
bool sendMsgFishingFishFloatTouch(al::HitSensor*, al::HitSensor*);
bool sendMsgFishingItemGet(al::HitSensor*, al::HitSensor*);
bool sendMsgFishingLineTouch(al::HitSensor*, al::HitSensor*);
bool sendMsgFishingStart(al::HitSensor*, al::HitSensor*);
bool sendMsgFishingUpImmediatelyPrepare(al::HitSensor*, al::HitSensor*);
bool sendMsgFireBrosFireBallCollide(al::HitSensor*, al::HitSensor*);
bool sendMsgFireSwitchFire(al::HitSensor*, al::HitSensor*);
bool sendMsgFrogHackTrample(al::HitSensor*, al::HitSensor*);
bool sendMsgGhostRecordStart(al::HitSensor*, al::HitSensor*);
bool sendMsgGhostRecordEnd(al::HitSensor*, al::HitSensor*);
bool sendMsgGhostPlay(al::HitSensor*, al::HitSensor*);
bool sendMsgGhostStop(al::HitSensor*, al::HitSensor*);
bool sendMsgGiantWanderBossAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgGiantWanderBossBulletAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgGiantWanderBossBulletPush(al::HitSensor*, al::HitSensor*);
bool sendMsgGhostReverse(al::HitSensor*, al::HitSensor*);
bool sendMsgGhostCancel(al::HitSensor*, al::HitSensor*);
bool sendMsgGrowFlowerSeedDisablePush(al::HitSensor*, al::HitSensor*);
bool sendMsgGrowFlowerSeedNear(al::HitSensor*, al::HitSensor*);
bool sendMsgGrowPlantPush(al::HitSensor*, al::HitSensor*);
bool sendMsgGrowerAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgGrowerWallAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgGunetterAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgGunetterBodyTouch(al::HitSensor*, al::HitSensor*);
bool sendMsgHammerAttackDown(al::HitSensor*, al::HitSensor*);
bool sendMsgHammerAttackSide(al::HitSensor*, al::HitSensor*);
bool sendMsgHammerAttackSideCollide(al::HitSensor*, al::HitSensor*);
bool sendMsgItemAmiiboKoopa(al::HitSensor*, al::HitSensor*);
bool sendMsgIsExistPukupuku(al::HitSensor*, al::HitSensor*);
bool sendMsgJangoAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgJangoRemoveCap(al::HitSensor*, al::HitSensor*);
bool sendMsgKakkuKick(al::HitSensor*, al::HitSensor*);
bool sendMsgKillByBossBattleDemo(al::HitSensor*, al::HitSensor*);
bool sendMsgKillByHackFirstDemo(al::HitSensor*, al::HitSensor*);
bool sendMsgKillByHomeDemo(al::HitSensor*, al::HitSensor*);
bool sendMsgEndHomeDemo(al::HitSensor*, al::HitSensor*);
bool sendMsgKillByMoonRockDemo(al::HitSensor*, al::HitSensor*);
bool sendMsgKillByShineGet(al::HitSensor*, al::HitSensor*);
bool sendMsgKillBySwitchTimer(al::LiveActor*);
bool sendMsgKoopaBindStart(al::HitSensor*, al::HitSensor*);
bool sendMsgKoopaCapPlayerFocusTarget(al::HitSensor*, al::HitSensor*);
bool sendMsgKoopaCapPunchFinishL(al::HitSensor*, al::HitSensor*);
bool sendMsgKoopaCapPunchFinishR(al::HitSensor*, al::HitSensor*);
bool sendMsgKoopaCapPunchInvincibleL(al::HitSensor*, al::HitSensor*);
bool sendMsgKoopaCapPunchInvincibleR(al::HitSensor*, al::HitSensor*);
bool sendMsgKoopaCapPunchKnockBackL(al::HitSensor*, al::HitSensor*);
bool sendMsgKoopaCapPunchKnockBackR(al::HitSensor*, al::HitSensor*);
bool sendMsgKoopaCapPunchL(al::HitSensor*, al::HitSensor*);
bool sendMsgKoopaCapPunchR(al::HitSensor*, al::HitSensor*);
bool sendMsgKoopaCapSpinAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgKoopaCatchKoopaCap(al::HitSensor*, al::HitSensor*);
bool sendMsgKoopaDashPunchAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgKoopaFire2D(al::HitSensor*, al::HitSensor*);
bool sendMsgKoopaFireBallAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgKoopaHackDamage(al::HitSensor*, al::HitSensor*);
bool sendMsgKoopaHackPunch(al::HitSensor*, al::HitSensor*);
bool sendMsgKoopaHackPunchCollide(al::HitSensor*, al::HitSensor*);
bool sendMsgKoopaHackTrample(al::HitSensor*, al::HitSensor*);
bool sendMsgKoopaInvalidHackPunchFaceToCollision(al::HitSensor*, al::HitSensor*);
bool sendMsgKoopaRingBeamInvalidTouch(al::HitSensor*, al::HitSensor*);
bool sendMsgKoopaTailAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgKoopaTouchFloor(al::HitSensor*, al::HitSensor*);
bool sendMsgKouraAttack2D(al::HitSensor*, al::HitSensor*);
bool sendMsgKouraItemGet2D(al::HitSensor*, al::HitSensor*);
bool sendMsgLaunchBlow(al::HitSensor*, al::HitSensor*);
bool sendMsgMeganeAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgMeganeHackTrample(al::HitSensor*, al::HitSensor*);
bool sendMsgMofumofuBulletUnexplosion(al::HitSensor*, al::HitSensor*);
bool sendMsgMoonBasementAttackMeteor(al::HitSensor*, al::HitSensor*);
bool sendMsgMoonBasementBreakShockwaveMeteor(al::HitSensor*, al::HitSensor*);
bool sendMsgMoonBasementRockSyncClippingRegist(al::HitSensor*, al::HitSensor*);
bool sendMsgMoonBasementRockSyncClippingInvalidate(al::HitSensor*, al::HitSensor*);
bool sendMsgMoonBasementRockSyncClippingValidate(al::HitSensor*, al::HitSensor*);
bool sendMsgAttachCactusNeedle(al::HitSensor*, al::HitSensor*);
bool sendMsgCactusNeedleAttack(al::HitSensor*, al::HitSensor*, al::ComboCounter*);
bool sendMsgCactusNeedleAttackStrong(al::HitSensor*, al::HitSensor*, al::ComboCounter*);
bool sendMsgPlayerBallToss(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerCarryCameraSubjectiveStart(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerCarryCameraSubjectiveEnd(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerCarryShineGetStart(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerCarryShineGetEnd(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerCapCatch(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerCapHipDrop(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerCapPush(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerCapRecovery(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerCapTouchJump(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerCapTrample(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerCoinDashGet(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerEyePriorityTarget(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerDisregardHomingAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerDisregardTargetMarker(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerEquipKoopaCap(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerFireBallAttack2D(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerFireBallAttack3D(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerHipDropDemoTrigger(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerHipDropHipDropSwitch(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerItemGet2D(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerJumpTakeOffFloor(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerObjectWallHit(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerObjLeapFrog(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerPenguinAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerPenguinAttackReflect(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerPoleClimbKeep(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerPoleClimbReaction(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerRabbitGet(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerRollingObjHit(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerRollingWallHitDown(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerRollingWallHitMove(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerStartGrabCeil(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerStartWallJump(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerEndGrabCeil(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerSwordAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerTouchFloorJumpCode(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerTrample2D(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerUpperPunch2D(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerObjUpperPunch2D(al::HitSensor*, al::HitSensor*);
bool sendMsgPukupukuDash(al::HitSensor*, al::HitSensor*);
bool sendMsgPukupukuKiss(al::HitSensor*, al::HitSensor*);
bool sendMsgPukupukuRollingAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgPush2D(al::HitSensor*, al::HitSensor*);
bool sendMsgPushToFish(al::HitSensor*, al::HitSensor*);
bool sendMsgPushToMotorcycle(al::HitSensor*, al::HitSensor*);
bool sendMsgPushToPlayer(al::HitSensor*, al::HitSensor*);
bool sendMsgRadishAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgRadishReflect(al::HitSensor*, al::HitSensor*);
bool sendMsgRequestChangeKinokoSuper(al::HitSensor*, al::HitSensor*);
bool sendMsgRequestChangeFireFlower(al::HitSensor*, al::HitSensor*);
bool sendMsgRequestPlayerSandMoon(al::HitSensor*, al::HitSensor*);
bool sendMsgRequestPlayerSnow(al::HitSensor*, al::HitSensor*);
bool sendMsgRequestPlayerWet(al::HitSensor*, al::HitSensor*);
bool sendMsgStartHack(al::HitSensor*, al::HitSensor*);
bool sendMsgSunshineAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgCancelHack(al::HitSensor*, al::HitSensor*);
bool sendMsgCancelHackArea(al::HitSensor*, al::HitSensor*);
bool sendMsgCancelHackByDokan(al::HitSensor*, al::HitSensor*);
bool sendMsgPackunEatStart(al::HitSensor*, al::HitSensor*);
bool sendMsgHackAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgHackAttackKick(al::HitSensor*, al::HitSensor*);
bool sendMsgHackAttackMapObj(al::HitSensor*, al::HitSensor*);
bool sendMsgHackDeathAreaSelfCheck(al::HitSensor*, al::HitSensor*);
bool sendMsgHackDemoEnd(al::HitSensor*, al::HitSensor*);
bool sendMsgHackDemoStart(al::HitSensor*, al::HitSensor*);
bool sendMsgHackInvalidEscape(al::HitSensor*, al::HitSensor*);
bool sendMsgHackInvalidEscapeNoReaction(al::HitSensor*, al::HitSensor*);
bool sendMsgHackMarioCheckpointFlagWarp(al::HitSensor*, al::HitSensor*);
bool sendMsgHackMarioDead(al::HitSensor*, al::HitSensor*);
bool sendMsgHackMarioDemo(al::HitSensor*, al::HitSensor*);
bool sendMsgHackMarioInWater(al::HitSensor*, al::HitSensor*);
bool sendMsgHackMoveRockForestPush(al::HitSensor*, al::HitSensor*);
bool sendMsgHackSelfCeilingCheckMiss(al::HitSensor*, al::HitSensor*);
bool sendMsgHackSyncDamageVisibility(al::HitSensor*, al::HitSensor*);
bool sendMsgWeaponItemGet(al::HitSensor*, al::HitSensor*);
bool sendMsgCapAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgCapAttackCollide(al::HitSensor*, al::HitSensor*);
bool sendMsgCapAttackStayRolling(al::HitSensor*, al::HitSensor*);
bool sendMsgCapAttackStayRollingCollide(al::HitSensor*, al::HitSensor*);
bool sendMsgCapAttackRailMove(al::HitSensor*, al::HitSensor*);
bool sendMsgCapGiantAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgCapReflect(al::HitSensor*, al::HitSensor*);
bool sendMsgCapReflectCollide(al::HitSensor*, al::HitSensor*);
bool sendMsgCapStartLockOn(al::HitSensor*, al::HitSensor*);
bool sendMsgCapKeepLockOn(al::HitSensor*, al::HitSensor*);
bool sendMsgCapCancelLockOn(al::HitSensor*, al::HitSensor*);
bool sendMsgCapHipDrop(al::HitSensor*, al::HitSensor*);
bool sendMsgCapObjHipDrop(al::HitSensor*, al::HitSensor*);
bool sendMsgCapObjHipDropReflect(al::HitSensor*, al::HitSensor*);
bool sendMsgCapIgnoreCancelLockOn(al::HitSensor*, al::HitSensor*);
bool sendMsgCapIgnoreCancelMissReaction(al::HitSensor*, al::HitSensor*);
bool sendMsgCapIgnoreCollisionCheck(al::HitSensor*, al::HitSensor*);
bool sendMsgCapItemGet(al::HitSensor*, al::HitSensor*);
bool sendMsgCapTrampolineAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgCatchBombThrough(al::HitSensor*, al::HitSensor*);
bool sendMsgCheckCarObstacle(al::HitSensor*, al::HitSensor*);
bool sendMsgCheckIsCardboardBox(al::HitSensor*, al::HitSensor*);
bool sendMsgBullHackAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgBullEnemyAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgEnemyAttackStrong(al::HitSensor*, al::HitSensor*);
bool sendMsgEnemyObjBreak(al::HitSensor*, al::HitSensor*);
bool sendMsgWhipAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgNoLimitTouchJump(al::HitSensor*, al::HitSensor*);
bool sendMsgNoticePlayerDamage(al::HitSensor*, al::HitSensor*);
bool sendMsgStatueDrop(al::HitSensor*, al::HitSensor*);
bool sendMsgStatueTrampleReflect(al::HitSensor*, al::HitSensor*);
bool sendMsgStatuePush(al::HitSensor*, al::HitSensor*);
bool sendMsgStatueSnap(al::HitSensor*, al::HitSensor*);
bool sendMsgHitGrowFlowerPot(al::HitSensor*, al::HitSensor*);
bool sendMsgHitGrowPlantPot(al::HitSensor*, al::HitSensor*);
bool sendMsgImplantGrowFlowerSeed(al::HitSensor*, al::HitSensor*);
bool sendMsgIcicleAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgIgnoreMirrorWarp(al::HitSensor*, al::HitSensor*);
bool sendMsgIgnoredByRunawayNpc(al::HitSensor*, al::HitSensor*);
bool sendMsgIgnorePushMotorcycle(al::HitSensor*, al::HitSensor*);
bool sendMsgSandSharkAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgSeedAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgSeedAttackBig(al::HitSensor*, al::HitSensor*);
bool sendMsgSeedAttackHold(al::HitSensor*, al::HitSensor*);
bool sendMsgSeedItemGet(al::HitSensor*, al::HitSensor*);
bool sendMsgSeedReflect(al::HitSensor*, al::HitSensor*);
bool sendMsgSenobiTrample(al::HitSensor*, al::HitSensor*);
bool sendMsgSenobiCancelStretch(al::HitSensor*, al::HitSensor*);
bool sendMsgSenobiPunchBlockTransparent(al::HitSensor*, al::HitSensor*);
bool sendMsgShibakenApproach(al::HitSensor*, al::HitSensor*);
bool sendMsgShibakenKick(al::HitSensor*, al::HitSensor*);
bool sendMsgHackUpperPunch(al::HitSensor*, al::HitSensor*);
bool sendMsgHackObjUpperPunch(al::HitSensor*, al::HitSensor*);
bool sendMsgShineGet(al::HitSensor*, al::HitSensor*);
bool sendMsgShineGet2D(al::HitSensor*, al::HitSensor*);
bool sendMsgSpherePush(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&, float);
bool sendMsgSphinxJumpAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgSphinxQuizRouteKill(al::HitSensor*, al::HitSensor*);
bool sendMsgSphinxRideAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgSphinxRideAttackReflect(al::HitSensor*, al::HitSensor*);
bool sendMsgPechoSpot(al::HitSensor*, al::HitSensor*);
bool sendMsgBelowObjBroken(al::HitSensor*, al::HitSensor*);
bool sendMsgBindCollidedGround(al::HitSensor*, al::HitSensor*);
bool sendMsgBindKeepDemoStart(al::HitSensor*, al::HitSensor*);
bool sendMsgBindKeepDemoExecute(al::HitSensor*, al::HitSensor*);
bool sendMsgBindKeepDemoEnd(al::HitSensor*, al::HitSensor*);
bool sendMsgBindRecoveryLife(al::HitSensor*, al::HitSensor*);
bool sendMsgMayorItemReflect(al::HitSensor*, al::HitSensor*);
bool sendMsgMayorItemCollide(al::HitSensor*, al::HitSensor*);
bool sendMsgBlowObjAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgBlowObjAttackReflect(al::HitSensor*, al::HitSensor*);
bool sendMsgConfirmFrailBox(al::HitSensor*, al::HitSensor*);
bool sendMsgConfirmBrokenFrailBox(al::HitSensor*, al::HitSensor*);
bool sendMsgTankLookOn(al::HitSensor*, al::HitSensor*);
bool sendMsgTankKickHack(al::HitSensor*, al::HitSensor*);
bool sendMsgTankKickEnemy(al::HitSensor*, al::HitSensor*);
bool sendMsgTankBullet(al::HitSensor*, al::HitSensor*);
bool sendMsgTankBulletNoReaction(al::HitSensor*, al::HitSensor*);
bool sendMsgTimerAthleticDemoStart(al::LiveActor*);
bool sendMsgRideOnStart(al::HitSensor*, al::HitSensor*);
bool sendMsgRideOnEnd(al::HitSensor*, al::HitSensor*);
bool sendMsgRideOnRelease(al::HitSensor*, al::HitSensor*);
bool sendMsgHipDropTransformTransform(al::HitSensor*, al::HitSensor*);
bool sendMsgHipDropTransformReverse(al::HitSensor*, al::HitSensor*);
bool sendMsgHipDropTransformingUp(al::HitSensor*, al::HitSensor*);
bool sendMsgHipDropTransformingDown(al::HitSensor*, al::HitSensor*);
bool sendMsgHipDropTransformingFinish(al::HitSensor*, al::HitSensor*);
bool sendMsgClearFire(al::HitSensor*, al::HitSensor*);
bool sendMsgCollectAnimalTouchCollide(al::HitSensor*, al::HitSensor*);
bool sendMsgBossKnuckleCounter(al::HitSensor*, al::HitSensor*);
bool sendMsgBossKnuckleFallAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgBossKnuckleHackAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgBossKnuckleKillerAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgBossKnuckleIceConflict(al::HitSensor*, al::HitSensor*);
bool sendMsgBossKnuckleIceFallToMummy(al::HitSensor*, al::HitSensor*);
bool sendMsgSkaterAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgEnableInSaucePan(al::HitSensor*, al::HitSensor*);
bool sendMsgEnableMapCheckPointWarp(al::HitSensor*, al::HitSensor*);
bool sendMsgStartInSaucePan(al::HitSensor*, al::HitSensor*, bool);
bool sendMsgEndInSaucePan(al::HitSensor*, al::HitSensor*);
bool sendMsgLineDancerLink(al::HitSensor*, al::HitSensor*);
bool sendMsgLongPushSensorHit(al::HitSensor*, al::HitSensor*);
bool sendMsgLongPushBoxHit(al::HitSensor*, al::HitSensor*);
bool sendMsgGoldHammerAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgTrashBoxIn(al::HitSensor*, al::HitSensor*);
bool sendMsgTouchDoorDrumn(al::HitSensor*, al::HitSensor*);
bool sendMsgKuribo2DTouch(al::HitSensor*, al::HitSensor*);
bool sendMsgKuriboCollisionDamage(al::HitSensor*, al::HitSensor*);
bool sendMsgKuriboCollisionKill(al::HitSensor*, al::HitSensor*);
bool sendMsgKuriboFlick(al::HitSensor*, al::HitSensor*);
bool sendMsgKuriboTowerOn(al::HitSensor*, al::HitSensor*, uint);
bool sendMsgPartyPopperSoundAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgYokinBallAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgYoshiDirectEat(al::HitSensor*, al::HitSensor*);
bool sendMsgYoshiTongueAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgYoshiTongueEatBind(al::HitSensor*, al::HitSensor*, float*, float*, float*);
bool sendMsgYoshiTongueEatBindCancel(al::HitSensor*, al::HitSensor*);
bool sendMsgYoshiTongueEatBindFinish(al::HitSensor*, al::HitSensor*);
bool sendMsgYoshiTongueEatHomingTarget(al::HitSensor*, al::HitSensor*);
bool sendMsgYukimaruPush(al::HitSensor*, al::HitSensor*);
bool sendMsgPunchMachinePunchStraight(al::HitSensor*, al::HitSensor*);
bool sendMsgPunchMachinePunchHook(al::HitSensor*, al::HitSensor*);
bool sendMsgPunchMachinePunchUpper(al::HitSensor*, al::HitSensor*);
bool sendMsgMorningStarWarpStart(al::HitSensor*, al::HitSensor*);
bool sendMsgMorningStarWarpEnd(al::HitSensor*, al::HitSensor*);
bool sendMsgGemyAim(al::HitSensor*, al::HitSensor*);
bool sendMsgHammerBrosHammerEnemyAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgHammerBrosHammerHackAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgHammerBrosHammerSearch(al::HitSensor*, al::HitSensor*);
bool sendMsgHackBrosContact(al::HitSensor*, al::HitSensor*);
bool sendMsgMotorcycleAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgMotorcycleCollideParkingLot(al::HitSensor*, al::HitSensor*);
bool sendMsgMotorcycleDashAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgMotorcycleDashCollide(al::HitSensor*, al::HitSensor*);
bool sendMsgWanwanEnemyAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgWanwanPush(al::HitSensor*, al::HitSensor*);
bool sendMsgWanwanReboundAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgWanwanBlockAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgWanwanHoleIn(al::HitSensor*, al::HitSensor*);
bool sendMsgWaterRoadIn(al::HitSensor*, al::HitSensor*);
bool sendMsgWaterRoadNear(al::HitSensor*, al::HitSensor*);
bool sendMsgBreedaSlap(al::HitSensor*, al::HitSensor*);
bool sendMsgBreedaPush(al::HitSensor*, al::HitSensor*);
bool sendMsgGamaneBullet(al::HitSensor*, al::HitSensor*);
bool sendMsgGamaneBulletThrough(al::HitSensor*, al::HitSensor*);
bool sendMsgGamaneBulletForCoinFlower(al::HitSensor*, al::HitSensor*);
bool sendMsgVolleyballNpcScareByEnemy(al::HitSensor*, al::HitSensor*);
bool sendMsgRocketFlowerExtension(al::HitSensor*, al::HitSensor*);
bool sendMsgWanderBossCameraRange(al::HitSensor*, al::HitSensor*);
bool sendMsgKuriboGirlAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgKuriboGirlLove(al::HitSensor*, al::HitSensor*);
bool sendMsgKuriboTop(al::HitSensor*, al::HitSensor*);
bool sendMsgTRexAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgTRexAttackCollideBody(al::HitSensor*, al::HitSensor*);
bool sendMsgTRexAttackCollideHead(al::HitSensor*, al::HitSensor*);
bool sendMsgTRexDashAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgTRexScrollPartsBreakWith(al::HitSensor*, al::HitSensor*);
bool sendMsgTsukkunNoTrace(al::HitSensor*, al::HitSensor*);
bool sendMsgTouchFireDrum2D(al::HitSensor*, al::HitSensor*);
bool sendMsgPropellerAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgTankExplosion(al::HitSensor*, al::HitSensor*);
bool sendMsgTankHackTrample(al::HitSensor*, al::HitSensor*);
bool sendMsgUtsuboAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgKillerAttackNoExplode(al::HitSensor*, al::HitSensor*);
bool sendMsgKillerMagnumAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgKillerMagnumHackAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgGabuzouAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgStackerRollingAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgStackerCapBoostAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgIgnoreIgnitionBomb(al::HitSensor*, al::HitSensor*);
bool sendMsgExplosionReflectBomb(al::HitSensor*, al::HitSensor*);
bool sendMsgGolemStampPress(al::HitSensor*, al::HitSensor*);
bool sendMsgSwitchOnWithSaveRequest(al::LiveActor*, SaveObjInfo*);
bool sendMsgWanwanReboundAttackToCollided(al::LiveActor const*, al::HitSensor*);
bool sendMsgWanwanBlockAttackToCollided(al::LiveActor const*, al::HitSensor*);
bool sendMsgDigPointSmell(al::HitSensor*, al::HitSensor*, struct DigPoint*);
bool sendMsgMofumofuBodyChainExplode(al::HitSensor*, al::HitSensor*, int);
bool sendMsgMoonBasementRockThroughCollision(al::HitSensor*, al::HitSensor*, bool);
bool sendMsgFishingWait(al::HitSensor*, al::HitSensor*, al::HitSensor*);
bool sendMsgFishingUpImmediately(al::HitSensor*, al::HitSensor*, sead::Matrix34<float> const&,
                                 sead::Vector3<float> const&, char const*);
bool sendMsgGunetterPush(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&, float);
bool sendMsgTestPunch(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&, int, int);
bool sendMsgTestPunchStrong(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&, int, int);
bool sendMsgPunchGuard(al::HitSensor*, al::HitSensor*, int, int);
bool sendMsgTsukkunThrust(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&, int, bool);
bool sendMsgTsukkunThrustSpin(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&, int,
                              bool);
bool sendMsgTsukkunThrustReflect(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&, int,
                                 bool);
bool sendMsgTsukkunThrustCollide(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&, int,
                                 bool);
bool sendMsgTsukkunThrustHitReflectCollide(al::HitSensor*, al::HitSensor*,
                                           sead::Vector3<float> const&, int, bool);
bool sendMsgTsukkunThrustReflectCollide(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&,
                                        int, bool);
bool sendMsgTsukkunThrustHole(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&,
                              sead::Vector3<float> const&);
bool sendMsgTsukkunThroughCollide(al::HitSensor*, al::HitSensor*);
bool sendMsgTsukkunHoldCollide(al::HitSensor*, al::HitSensor*);
bool sendMsgTsukkunForceCancelCollide(al::HitSensor*, al::HitSensor*);
bool sendMsgNetworkShootingShot(al::HitSensor*, al::HitSensor*, int);
bool sendMsgNetworkShootingChargeShot(al::HitSensor*, al::HitSensor*, int);
bool sendMsgRequestPlayerJumpBreakFloor(al::HitSensor*, al::HitSensor*);
bool sendMsgRequestPlayerJump(al::HitSensor*, al::HitSensor*, float);
bool sendMsgRequestPlayerTrampleJump(al::HitSensor*, al::HitSensor*, float);
bool sendMsgRequestPlayerSpinJump(al::HitSensor*, al::HitSensor*, float);
bool sendMsgRequestSphinxJump(al::HitSensor*, al::HitSensor*, float);
bool sendMsgIgnoreTouchTarget(al::HitSensor*, al::HitSensor*);
bool sendMsgIgnoreTouchTarget(al::ScreenPointer*, al::ScreenPointTarget*);
bool sendMsgInitTouchTargetInfo(al::HitSensor*, al::HitSensor*, struct TouchTargetInfo*,
                                sead::Vector3<float> const*);
bool sendMsgInitTouchTargetInfo(al::ScreenPointer*, al::ScreenPointTarget*, TouchTargetInfo*,
                                sead::Vector3<float> const*);
bool sendMsgCollisionImpulse(al::HitSensor*, al::HitSensor*, sead::Vector3<float>*,
                             sead::Vector3<float> const&, float, sead::Vector3<float> const&,
                             float);
bool sendMsgWhipHold(al::HitSensor*, al::HitSensor*, struct WhipTargetInfo*);
bool sendMsgWhipBind(al::HitSensor*, al::HitSensor*, WhipTargetInfo*);
bool sendMsgWhipThrow(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&);
bool sendMsgMagnet(al::HitSensor*, al::HitSensor*, bool);
bool sendMsgMagnetBulletAttack(al::HitSensor*, al::HitSensor*, float);
bool sendMsgDashPanel(al::HitSensor*, al::HitSensor*, int);
bool sendMsgTrampolineCrackJump(al::HitSensor*, al::HitSensor*, float, float);
bool sendMsgCapTouchWall(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&,
                         sead::Vector3<float> const&);
bool sendMsgCapRethrow(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&,
                       sead::Vector3<float> const&, sead::Vector3<float> const&);
bool sendMsgCapRethrowReturnOnly(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&,
                                 sead::Vector3<float> const&, sead::Vector3<float> const&);
bool sendMsgCapChangeGiant(al::HitSensor*, al::HitSensor*, float, int);
bool sendMsgPackunEatCancel(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&,
                            sead::Vector3<float> const&);
bool sendMsgPackunEatEnd(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&,
                         sead::Vector3<float> const&);
bool sendMsgPackunEatStartFollow(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const*);
bool sendMsgFireBlowerAttack(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&,
                             sead::Vector3<float> const&, float);
// bool sendMsgPaint(al::HitSensor *,al::HitSensor *,sead::Color4u8 const&,int,int);
bool sendMsgPaintTexture(al::HitSensor*, al::HitSensor*, int, float, int);
// bool sendMsgCheckPaintClear(al::HitSensor *,al::HitSensor *,sead::Color4u8
// const&,sead::Vector3<float> const&,int);
bool sendMsgCheckPaintAlpha(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&);
bool sendMsgByugoBlow(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&);
bool sendMsgHackDirectStageInit(al::HitSensor*, al::HitSensor*, IUsePlayerHack*);
bool sendMsgObjSnapForce(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&);
bool sendMsgCapBeamerBeam(al::HitSensor*, al::HitSensor*);
bool sendMsgHosuiAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgHosuiAttackCollide(al::HitSensor*, al::HitSensor*);
bool sendMsgHosuiAttackNoEffect(al::HitSensor*, al::HitSensor*);
bool sendMsgHosuiAttackStrong(al::HitSensor*, al::HitSensor*);
bool sendMsgHosuiTouch(al::HitSensor*, al::HitSensor*);
bool sendMsgHosuiTrample(al::HitSensor*, al::HitSensor*);
bool sendMsgHosuiTrampleReflect(al::HitSensor*, al::HitSensor*);
bool sendMsgHosuiTrampleReflectHigh(al::HitSensor*, al::HitSensor*);
bool sendMsgBubbleAttack(al::HitSensor*, al::HitSensor*);
bool sendMsgBubbleAttackToPecho(al::HitSensor*, al::HitSensor*);
bool sendMsgBubbleReflectH(al::HitSensor*, al::HitSensor*);
bool sendMsgBubbleReflectV(al::HitSensor*, al::HitSensor*);
bool sendMsgBubbleWallTouch(al::HitSensor*, al::HitSensor*);
bool sendMsgBubbleGroundTouchTrigger(al::HitSensor*, al::HitSensor*);
bool sendMsgBubbleLauncherStart(al::HitSensor*, al::HitSensor*);
bool sendMsgSenobiPartsMove(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&, float);
bool sendMsgStampTo2D(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&);
bool sendMsgAirExplosion(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&);
bool sendMsgPushVelocity(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&);
bool sendMsgGhostRecordStartOk(al::HitSensor*, al::HitSensor*, char const*);
bool sendMsgSandGeyserRaise(al::HitSensor*, al::HitSensor*, float, float);
bool sendMsgRaceWait(al::LiveActor*);
bool sendMsgRaceStart(al::LiveActor*);
bool sendMsgRaceStop(al::LiveActor*);
bool sendMsgRaceReturnToCourse(al::LiveActor*, sead::Vector3<float> const&,
                               sead::Vector3<float> const&);
bool sendMsgPlayerLookAtPosition(al::HitSensor*, al::HitSensor*, sead::Vector3<float>*);
bool sendMsgTargetMarkerPosition(al::HitSensor*, al::HitSensor*, sead::Vector3<float>*);
bool sendMsgHackBlowJump(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&, float);
bool sendMsgGolemStampPushV(al::HitSensor*, al::HitSensor*, float);
bool sendMsgGolemStampPushH(al::HitSensor*, al::HitSensor*, float);
bool sendMsgRequestPlayerWaitAnimDigPoint(al::HitSensor*, al::HitSensor*);
bool sendMsgEventFlowScareCheck(al::HitSensor*, al::HitSensor*, al::EventFlowExecutor*);
bool sendMsgPlayerItemGetAll(al::HitSensor*, al::HitSensor*);
bool sendMsgPlayerItemGetAll2D(al::HitSensor*, al::HitSensor*);
bool sendMsgTRexAttackAll(al::HitSensor*, al::HitSensor*);
bool sendMsgSeedTouch(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&,
                      sead::Vector3<float> const&);
bool sendMsgSphinxRideAttackTouchThrough(al::HitSensor*, al::HitSensor*,
                                         sead::Vector3<float> const&, sead::Vector3<float> const&);
bool sendMsgSphinxRideAttackTouch(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&,
                                  sead::Vector3<float> const&);
bool sendMsgBlockUpperPunch2D(al::HitSensor*, al::HitSensor*);
bool sendMsgGotogotonOn(al::HitSensor*, al::HitSensor*);
bool sendMsgGotogotonGetJumpPath(al::HitSensor*, al::HitSensor*, al::ParabolicPath*);
bool sendMsgGotogotonGoalExist(al::HitSensor*, al::HitSensor*);
bool sendMsgGotogotonGoalMatch(al::HitSensor*, al::HitSensor*, struct GotogotonMark const*);
bool sendMsgBossMagmaBreathForce(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&);
bool sendMsgBossMagmaCatchPlayer(al::HitSensor*, al::HitSensor*);
bool sendMsgBossMagmaReleasePlayer(al::HitSensor*, al::HitSensor*);
bool sendMsgBossMagmaDeadDemoStart(al::HitSensor*, al::HitSensor*);
bool sendMsgBossMagmaDeadDemoEnd(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&);
bool sendMsgBossMagmaResetPos(al::HitSensor*, al::HitSensor*, sead::Vector3<float> const&);
bool sendMsgBossMagmaQueryToBubble(al::HitSensor*, al::HitSensor*);
bool sendMsgCheckFishingTarget(al::HitSensor*, al::HitSensor*, struct FishingFish const*);
bool sendMsgPushToPlayerAndKillVelocityToTarget(al::LiveActor*, al::HitSensor*, al::HitSensor*);
bool sendMsgPushToPlayerAndKillVelocityToTargetH(al::LiveActor*, al::HitSensor*, al::HitSensor*);
bool sendMsgInitCapTarget(al::HitSensor*, al::HitSensor*, struct CapTargetInfo const**);
bool sendMsgTransferHack(al::HitSensor*, al::HitSensor*);
bool sendMsgRequestTransferHack(al::HitSensor*, al::HitSensor*);
bool sendMsgInitHack(al::HitSensor*, al::HitSensor*);
bool sendMsgEndHack(al::HitSensor*, al::HitSensor*, HackEndParam const*);
bool sendMsgNpcScareByEnemy(al::HitSensor*, al::HitSensor*, int);
} // namespace rs
