#pragma once

#include "types.h"

class PlayerConst { // 0x9A8 i think is PlayerConst's size, which is every single entry plus some extra space for something
    public: // note: these functions are in the order that the addresses are in, so doing a bit of messing around with these declarations should also allow for the full header to be decompiled
        virtual float getGravity(void) const;
        virtual float getFrictionAttack(void) const;
        virtual float getPushPower(void) const;
        virtual float getWaitPoseDegreeMax(void) const;
        virtual float getHillPoseDegreeMax(void) const;
        virtual float getTiltPoseDegreeMax(void) const;
        virtual float getSlerpQuatRate(void) const;
        virtual float getSlerpQuatRateWait(void) const;
        virtual float getSlerpQuatGrav(void) const;
        virtual int getPreInputFrameCapThrow(void) const;
        virtual int getEnableActionFrameCapCatch(void) const;
        virtual float getJumpPowerCapCatch(void) const;
        virtual float getJumpGravityCapCatch(void) const;
        virtual int getRunTimeContinuousThrow(void) const;
        virtual float getRunSpeedMaxContinuousThrow(void) const;
        virtual int getRunAccelFrameContinuousThrow(void) const;
        virtual float getSeparateCheckHeight(void) const;
        virtual float getSeparateOffsetLerpRate(void) const;
        virtual float getSeparateEnableThrowHeight(void) const;
        virtual float getTall(void) const;
        virtual float getCollisionRadius(void) const;
        virtual float getCollisionRadiusSquat(void) const;
        virtual float getCollisionRadiusStand(void) const;
        virtual float getCollisionSmallStepHeight(void) const;
        virtual float getCollisionResetLimit(void) const;
        virtual float getReflectCeilingPower(void) const;
        virtual float getReflectTossPower(void) const;
        virtual float getReflectUpperPunchScaleH(void) const;
        virtual float getCollisionHitDownAngleH(void) const;
        virtual float getCollisionHitDownEscapeAngleV(void) const;
        virtual float getShadowDropHeightScale(void) const;
        virtual float getShadowDropNormalAdd(void) const;
        virtual float getShadowDropLengthMin(void) const;
        virtual float getShadowDropLengthMax(void) const;
        virtual float getShadowDropLengthExtend(void) const;
        virtual float getGravityDamage(void) const;
        virtual float getHopPowerDamage(void) const;
        virtual float getPushPowerDamage(void) const;
        virtual int getDamageCancelFrame(void) const;
        virtual int getDamageInvalidCount(void) const;
        virtual int getDamageInvalidCountRecovery(void) const;
        virtual int getDamageInvalidCountAbyss(void) const;
        virtual float getNormalMinSpeed2D(void) const;
        virtual float getNormalMaxSpeed2D(void) const;
        virtual float getDashMaxSpeed2D(void) const;
        virtual int getNormalAccelFrame2D(void) const;
        virtual int getDashAccelFrame2D(void) const;
        virtual int getNormalDashAnimFrame2D(void) const;
        virtual int getNormalBrakeFrame2D(void) const;
        virtual int getStickOnBrakeFrame2D(void) const;
        virtual int getBrakeTurnStartFrame2D(void) const;
        virtual float getTurnEndSpeedRate2D(void) const;
        virtual float getJumpPowerMin2DArea(void) const;
        virtual float getJumpPowerMax2DArea(void) const;
        virtual float getJumpPowerMinBorder2D(void) const;
        virtual float getJumpPowerMaxBorder2D(void) const;
        virtual float getGravityMove(void) const;
        virtual float getNormalMaxSpeed(void) const;
        virtual float getNormalMinSpeed(void) const;
        virtual int getNormalAccelFrame(void) const;
        virtual float getRunAccelAverageScale(void) const;
        virtual int getNormalBrakeFram(void) const;
        virtual float getDashJudgeSpeed(void) const;
        virtual int getStickOnBrakeFrame(void) const;
        virtual int getNormalDashAnimFrame(void) const;
        virtual float getRunAfterTurnSpeedMax(void) const;
        virtual float getRunAfterTurnScale(void) const;
        virtual int getRunAfterTurnFrame(void) const;
        virtual int getBrakeTurnStartFrame(void) const;
        virtual float getBrakeOnSpeedRate(void) const;
        virtual int getBrakeOnCounterBorder(void) const;
        virtual int getWallPushFrame(void) const;
        virtual int getRunDeepDownFrame(void) const;
        virtual int getRunDeepDownMargine(void) const;
        virtual int getQuickTurnJumpFrame(void) const;
        virtual int getRoundAccelFrame(void) const;
        virtual int getRoundBrakeFrame(void) const;
        virtual float getRoundFastDegree(void) const;
        virtual int getRoundAccelFrameFast(void) const;
        virtual float getRoundMinDegree(void) const;
        virtual int getRoundBrakeFrameForce(void) const;
        virtual float getRoundFastDegreeForce(void) const;
        virtual float getRoundLimitDegreeForce(void) const;
        virtual float getRoundLimitDegreeForceFast(void) const;
        virtual int getRoundAccelFrameForceFast(void) const;
        virtual float getRoundLimitDegreeMin(void) const;
        virtual float getRoundLimitDegree(void) const;
        virtual int getIceAccelFrame(void) const;
        virtual int getIceBrakeFrame(void) const;
        virtual int getIceBrakeFrameHigh(void) const;
        virtual int getIceBrakeFrameWall(void) const;
        virtual int getIceRoundAccelFrame(void) const;
        virtual int getIceRoundAccelFrameFast(void) const;
        virtual int getIceRoundBrakeFrame(void) const;
        virtual float getIceRoundFastDegree(void) const;
        virtual float getIceRoundMinDegree(void) const;
        virtual float getIceRoundLimitDegree(void) const;
        virtual float getHillAddSpeed(void) const;
        virtual float getHillSubSpeed(void) const;
        virtual int getHillAccelAddFrame(void) const;
        virtual int getHillAccelSubFrame(void) const;
        virtual float getHillAccelSubAngleMin(void) const;
        virtual float getHillAccelSubAngleMax(void) const;
        virtual float getStandAngleMin(void) const;
        virtual float getStandAngleMax(void) const;
        virtual float getHillAngleSpeedMin(void) const;
        virtual float getHillAngleSpeedMax(void) const;
        virtual int getSpinCapThrowFrame(void) const;
        virtual int getSpinCapThrowFrameAir(void) const;
        virtual int getSpinCapThrowFrameSwim(void) const;
        virtual int getSpinCapThrowFrameSwing(void) const;
        virtual int getSpinCapThrowFrameContinuous(void) const;
        virtual int getSpinAttackFrame(void) const;
        virtual int getSpinBrakeFrame(void) const;
        virtual float getSpinAirJumpPower(void) const;
        virtual float getSpinAirSpeedMax(void) const;
        virtual float getGravitySpinAir(void) const;
        virtual float getSlerpQuatRateSpinAir(void) const;
        virtual float getSpinBrakeRate(void) const;
        virtual float getSpinBrakeSideAccel(void) const;
        virtual float getSpinBrakeSideBrakeRate(void) const;
        virtual float getSpinBrakeSideMaxSpeedRate(void) const;
        virtual float getSpinRoundLimitDegree(void) const;
        virtual float getDamageFireJumpPower1st(void) const;
        virtual float getDamageFireJumpPower2nd(void) const;
        virtual float getDamageFireJumpMoveSpeed(void) const;
        virtual float getDamageFireCeilHitSpeed(void) const;
        virtual float getDamageFireGravity(void) const;
        virtual int getDamageFireNoGravityFrame(void) const;
        virtual int getDamageFireRunTime(void) const;
        virtual float getDamageFireRunSpeed(void) const;
        virtual float getDamageFireRunBrakeFrame(void) const;
        virtual int getSandSinkDeadTime(void) const;
        virtual int getSandSinkBrakeHeightH(void) const;
        virtual int getSandSinkBrakeHeightV(void) const;
        virtual float getSandSinkHeight(void) const;
        virtual float getSandSinkCapThrow(void) const;
        virtual float getSandSinkBrakeMinH(void) const;
        virtual float getSandSinkBrakeMaxH(void) const;
        virtual float getSandSinkBrakeMinV(void) const;
        virtual float getSandSinkBrakeMaxV(void) const;
        virtual float getSlopeSlideAngleStart(void) const;
        virtual float getSlopeSlideAngleEnd(void) const;
        virtual float getSlopeSlideAccel(void) const;
        virtual float getSlopeSlideBrake(void) const;
        virtual float getSlopeSlideMaxSpeed(void) const;
        virtual float getSlopeSlideSpeedEnd(void) const;
        virtual float getSlopeSlideSideAccel(void) const;
        virtual float getSlopeSlideSideBrake(void) const;
        virtual float getSlopeSlideSideMaxSpeed(void) const;
        virtual float getSlopeTurnDegree(void) const;
        virtual int getSlideInvalidFrame(void) const;
        virtual int getSlopeForceFrame(void) const;
        virtual float getSlopeSlideForceSideAccel(void) const;
        virtual float getSlopeSlideForceSideBrake(void) const;
        virtual float getSlopeSlideForceSideMaxSpeed(void) const;
        virtual float getSlopeSlideForceTurnDegree(void) const;
        virtual float getSlopeRollingSpeedStart(void) const;
        virtual float getSlopeRollingSpeedBoost(void) const;
        virtual float getSlopeRollingMaxSpeed(void) const;
        virtual int getSlopeRollingFrameMinBoost(void) const;
        virtual int getSlopeRollingFrameMin(void) const;
        virtual float getSlopeRollingStartJumpPower(void) const;
        virtual float getSlopeRollingStartSlideSpeed(void) const;
        virtual float getSlopeRollingAccel(void) const;
        virtual float getSlopeRollingBrake(void) const;
        virtual float getSlopeRollingAgainst(void) const;
        virtual float getSlopeRollingAnglePowerMax(void) const;
        virtual float getSlopeRollingSpeedEnd(void) const;
        virtual float getSlopeRollingSideAccel(void) const;
        virtual float getSlopeRollingSideBrake(void) const;
        virtual float getSlopeRollingSideMaxSpeed(void) const;
        virtual int getSlopeRollingUnRollFrame(void) const;
        virtual float getSlopeRollingEndBrake(void) const;
        virtual float getSlopeRollingEndBrakeEndSpeed(void) const;
        virtual float getSlopeRollingReStartAccel(void) const;
        virtual float getSlopeRollingReStartMaxAdd(void) const;
        virtual int getSlopeRollingReStarterval(void) const;
        virtual int getSlopeRollingReStartSwing(void) const;
        virtual int getSlopeRollingReStartCharge(void) const;
        virtual int getSlopeRollingReStartForce(void) const;
        virtual float getSlopeRollingAccelOnSkate(void) const;
        virtual float getSlopeRollingSideAccelOnSkate(void) const;
        virtual float getSlopeRollingBrakeOnSkate(void) const;
        virtual int getExtendFrame(void) const;
        virtual float getJumpInertiaRate(void) const;
        virtual float getJumpPowerMin(void) const;
        virtual float getJumpPowerMax(void) const;
        virtual float getJumpGravity(void) const;
        virtual float getJumpBaseSpeedMax(void) const;
        virtual float getJumpMoveSpeedMin(void) const;
        virtual float getJumpMoveSpeedMax(void) const;
        virtual float getJumpAccelFront(void) const;
        virtual float getJumpAccelBack(void) const;
        virtual float getJumpAccelTurn(void) const;
        virtual float getJumpTurnAngleStart(void) const;
        virtual float getJumpTurnAngleLimit(void) const;
        virtual float getJumpTurnAngleFast(void) const;
        virtual float getJumpTurnAngleFastLimit(void) const;
        virtual int getJumpTurnAccelFrame(void) const;
        virtual int getJumpTurnAccelFrameFast(void) const;
        virtual int getJumpTurnBrakeFrame(void) const;
        virtual float getTrampleGravity(void) const;
        virtual float getTrampleJumpPower(void) const;
        virtual float getTrampleHighGravity(void) const;
        virtual float getTrampleHighJumpPower(void) const;
        virtual float getTrampleGravity2D(void) const;
        virtual float getTrampleJumpPower2D(void) const;
        virtual float getTrampleHighGravity2D(void) const;
        virtual float getTrampleHighJumpPower2D(void) const;
        virtual float getTrampleHipDropGravity(void) const;
        virtual float getTrampleHipDropJumpPower(void) const;
        virtual float getTrampleRisingBrakeVelH(void) const;
        virtual float getTrampleJumpCodePower(void) const;
        virtual float getTrampleJumpCodePowerSmall(void) const;
        virtual float getCapLeapFrogJumpGravity(void) const;
        virtual float getCapLeapFrogJumpPower(void) const;
        virtual float getCapLeapFrogJumpPowerAir(void) const;
        virtual float getObjLeapFrogJumpPower(void) const;
        virtual float getObjLeapFrogJumpPowerHigh(void) const;
        virtual float getCapHeadSpringJumpGravity(void) const;
        virtual float getCapHeadSpringJumpPower(void) const;
        virtual float getCapHeadSpringJumpGravityHigh(void) const;
        virtual float getCapHeadSpringJumpPowerHigh(void) const;
        virtual float getCapHeadSpringSpeedMax(void) const;
        virtual int getContinuousJumpPreInputFrame(void) const;
        virtual int getContinuousJumpCount(void) const;
        virtual int getContinuousJumpTimer(void) const;
        virtual float getContinuousJumpPowerMin(void) const;
        virtual float getJumpPowerMax2nd(void) const;
        virtual float getJumpGravity2nd(void) const;
        virtual float getJumpPowerMax3rd(void) const;
        virtual float getJumpGravity3rd(void) const;
        virtual float getSpinFlowerJumpGravity(void) const;
        virtual float getSpinFlowerJumpFallSpeedMax(void) const;
        virtual float getSpinFlowerJumpMovePower(void) const;
        virtual float getSpinFlowerJumpVelMax(void) const;
        virtual int getSpinFlowerJumpStayFrame(void) const;
        virtual float getSpinFlowerJumpStaySpeedMax(void) const;
        virtual float getSpinFlowerJumpNoInputBrake(void) const;
        virtual float getSpinFlowerJumpDownFallInitSpeed(void) const;
        virtual float getSpinFlowerJumpDownFallPower(void) const;
        virtual float getSpinFlowerJumpDownFallSpeedMax(void) const;
        virtual float getJumpGravityForceRun(void) const;
        virtual float getJumpPowerForceRun(void) const;
        virtual float getCapCatchPopPower(void) const;
        virtual float getCapCatchPopGravity(void) const;
        virtual float getSquatJumpGravity(void) const;
        virtual float getSquatJumpPower(void) const;
        virtual float getSquatJumpBackPower(void) const;
        virtual float getSquatJumpMovePowerFront(void) const;
        virtual float getSquatJumpMovePowerSide(void) const;
        virtual float getSquatJumpMoveSpeedMax(void) const;
        virtual float getTurnJumpGravity(void) const;
        virtual float getTurnJumpPower(void) const;
        virtual float getTurnJumpVelH(void) const;
        virtual float getTurnJumpBrake(void) const;
        virtual float getTurnJumpAccel(void) const;
        virtual float getTurnJumpSideAccel(void) const;
        virtual float getLongJumpAccel(void) const;
        virtual float getLongJumpBrake(void) const;
        virtual float getLongJumpSideAccel(void) const;
        virtual float getLongJumpGravity(void) const;
        virtual float getLongJumpJumpPow(void) const;
        virtual float getLongJumpMovePow(void) const;
        virtual float getLongJumpInitSpeed(void) const;
        virtual float getLongJumpSpeed(void) const;
        virtual float getLongJumpSpeedMin(void) const;
        virtual int getContinuousLongJumpCount(void) const;
        virtual int getContinuousLongJumpTimer(void) const;
        virtual float getGravityAir(void) const;
        virtual float getFrictionAir(void) const;
        virtual float getFallSpeedMax(void) const;
        virtual float getLongFallDistance(void) const;
        virtual float getFallWallScaleVelocity(void) const;
        virtual int getDownFallFrameMin(void) const;
        virtual float getGravityWallSlide(void) const;
        virtual float getWallHeightLowLimit(void) const;
        virtual float getWallKeepDegree(void) const;
        virtual int getWallKeepFrame(void) const;
        virtual float getWallJumpGravity(void) const;
        virtual float getWallJumpHSpeed(void) const;
        virtual float getWallJumpPower(void) const;
        virtual int getWallJumpInvalidateInputFrame(void) const;
        virtual int getWallInhibitAfterPunch(void) const;
        virtual float getWallFollowAngleH(void) const;
        virtual float getWallFollowAngleV(void) const;
        virtual float getWallCatchDegree(void) const;
        virtual float getWallCatchHeightEdgeTop(void) const;
        virtual float getWallCatchHeightBottom(void) const;
        virtual float getWallCatchKeepDegree(void) const;
        virtual float getWallCatchMoveDegree(void) const;
        virtual float getWallCatchMoveSpeed(void) const;
        virtual float getWallCatchMoveHeightRange(void) const;
        virtual int getWallCatchMoveerpolate(void) const;
        virtual int getWallCatchMoveFrame(void) const;
        virtual int getWallCatchMoveFrameFast(void) const;
        virtual int getWallCatchMoveFrameSwing(void) const;
        virtual float getWallCatchInputRepeatAngle(void) const;
        virtual float getWallClimbDegree(void) const;
        virtual int getWallClimbJumpStartFrame(void) const;
        virtual int getWallClimbJumpEndFrame(void) const;
        virtual int getWallClimbStartFrame(void) const;
        virtual float getWallClimbGravity(void) const;
        virtual float getWallFallJumpSpeed(void) const;
        virtual float getWallClimbJumpSpeedV(void) const;
        virtual float getWallClimbJumpSpeedH(void) const;
        virtual float getWallClimbJumpGravity(void) const;
        virtual int getWallClimbJumpInvalidFrame(void) const;
        virtual float getWallCatchHipLocalOffset(void) const;
        virtual float getWallCatchHipStability(void) const;
        virtual float getWallCatchHipFriction(void) const;
        virtual float getWallCatchHipLimitDegree(void) const;
        virtual float getWallCatchStainAreaOffset(void) const;
        virtual float getGrabCeilRange(void) const;
        virtual float getGrabCeilBodyRadius(void) const;
        virtual float getGrabCeilLeaveSpeedMin(void) const;
        virtual float getGrabCeilLeavePopPower(void) const;
        virtual float getGrabCeilLeavePopGravity(void) const;
        virtual float getGrabCeilSwingStartOffset(void) const;
        virtual float getGrabCeilReverseInputBorder(void) const;
        virtual float getGrabCeilInputPowerBorder(void) const;
        virtual float getGrabCeilSwingWaitEnergy(void) const;
        virtual float getGrabCeilEnableJumpEnergy(void) const;
        virtual float getGrabCeilEnableJumpEnergyMax(void) const;
        virtual float getGrabCeilJumpForceAngle(void) const;
        virtual float getGrabCeilJumpPower(void) const;
        virtual float getGrabCeilJumpMoveMin(void) const;
        virtual float getGrabCeilJumpMoveMax(void) const;
        virtual float getGrabCeilJumpGravity(void) const;
        virtual int getGrabCeilJumpInvalidFrame(void) const;
        virtual int getGrabCeilEnableNextFrame(void) const;
        virtual int getGrabCeilEnableFallSnapFrame(void) const;
        virtual int getPoleClimbPreInputSwing(void) const;
        virtual float getPoleClimbInputRepeatAngle(void) const;
        virtual float getPoleClimbInputDegreeMove(void) const;
        virtual float getPoleClimbCatchRange(void) const;
        virtual float getPoleClimbCatchRangeMin(void) const;
        virtual float getPoleClimbCatchRangeMax(void) const;
        virtual float getPoleClimbJointAngleMin(void) const;
        virtual float getPoleClimbJointAngleMax(void) const;
        virtual float getPoleClimbJointRangeMin(void) const;
        virtual float getPoleClimbJointRangeMax(void) const;
        virtual float getPoleClimbMoveWallDegree(void) const;
        virtual float getPoleClimbUpMargine(void) const;
        virtual float getPoleClimbUpSpeed(void) const;
        virtual int getPoleClimbUpFrame(void) const;
        virtual int getPoleClimbUpFrameFast(void) const;
        virtual int getPoleClimbUpFrameSwing(void) const;
        virtual float getPoleClimbDownSpeed(void) const;
        virtual float getPoleClimbDownSpeedFast(void) const;
        virtual float getPoleClimbDownSpeedSwing(void) const;
        virtual int getPoleClimbDownFrame(void) const;
        virtual int getPoleClimbDownKeepTime(void) const;
        virtual float getPoleClimbTurnDist(void) const;
        virtual int getPoleClimbTurnFrame(void) const;
        virtual int getPoleClimbTurnStopFrame(void) const;
        virtual int getPoleTopStartFrame(void) const;
        virtual int getPoleTopEndFrame(void) const;
        virtual float getPoleTopTurnSpeed(void) const;
        virtual float getPoleTopEndUnderOffsetY(void) const;
        virtual int getGroundSpinFrame(void) const;
        virtual float getGroundSpinMoveSpeedMax(void) const;
        virtual float getGroundSpinAccelRate(void) const;
        virtual float getGroundSpinBrakeRate(void) const;
        virtual float getSpinJumpGravity(void) const;
        virtual float getSpinJumpPower(void) const;
        virtual float getSpinJumpMoveSpeedMax(void) const;
        virtual float getSpinJumpDownFallInitSpeed(void) const;
        virtual float getSpinJumpDownFallPower(void) const;
        virtual float getSpinJumpDownFallSpeedMax(void) const;
        virtual float getSquatBrakeEndSpeed(void) const;
        virtual float getSquatAccelRate(void) const;
        virtual float getSquatBrakeRate(void) const;
        virtual float getSquatBrakeRateOnSkate(void) const;
        virtual float getSquatBrakeSideAccel(void) const;
        virtual float getSquatBrakeSideRate(void) const;
        virtual float getSquatBrakeSideAccelOnSkate(void) const;
        virtual float getSquatBrakeSideRateOnSkate(void) const;
        virtual float getSquatBrakeSideMaxSpeedRate(void) const;
        virtual float getSquatWalkSpeed(void) const;
        virtual float getSquatWalkTurnSpeed(void) const;
        virtual int getSquatWalkTurnFrame(void) const;
        virtual float getSquatJumpCeilSlideSpeed2D(void) const;
        virtual float getHipDropSpeed(void) const;
        virtual float getHipDropGravity(void) const;
        virtual float getHipDropSpeedMax(void) const;
        virtual int getHipDropLandCancelFrame(void) const;
        virtual float getHipDropHeight(void) const;
        virtual int getHipDropMsgerval(void) const;
        virtual float getJumpHipDropPower(void) const;
        virtual int getJumpHipDropPermitBeginFrame(void) const;
        virtual int getJumpHipDropPermitEndFrame(void) const;
        virtual float getHeadSlidingSpeed(void) const;
        virtual float getHeadSlidingSpeedMin(void) const;
        virtual float getHeadSlidingBrake(void) const;
        virtual float getHeadSlidingSideAccel(void) const;
        virtual float getHeadSlidingJump(void) const;
        virtual float getHeadSlidingGravityAir(void) const;
        virtual float getSwimCenterOffset(void) const;
        virtual float getSwimWallCatchOffset(void) const;
        virtual float getSwimRisePower(void) const;
        virtual float getSwimRiseSpeedMax(void) const;
        virtual int getSwimRiseFrame(void) const;
        virtual float getSwimGravity(void) const;
        virtual float getSwimGravityWalk(void) const;
        virtual float getSwimFallSpeedMax(void) const;
        virtual float getSwimFloorAccelH(void) const;
        virtual float getSwimFloorSpeedMaxH(void) const;
        virtual float getSwimHighAccelH(void) const;
        virtual float getSwimHighSpeedMaxH(void) const;
        virtual float getSwimLowAccelH(void) const;
        virtual float getSwimLowSpeedMaxH(void) const;
        virtual float getSwimBrakeRateH(void) const;
        virtual float getSwimWallHitSpeedMinH(void) const;
        virtual int getSwimHighAccelPermitFrame(void) const;
        virtual float getSwimFlowFieldBlend(void) const;
        virtual float getSwimWalkAnimMinRate(void) const;
        virtual float getSwimWalkAnimMaxRate(void) const;
        virtual float getSwimWalkMaxSpeed(void) const;
        virtual float getSwimSpinCapUpPower(void) const;
        virtual float getSwimSpinCapUpSpeedMax(void) const;
        virtual float getSwimRotStartAngle(void) const;
        virtual float getSwimRotFastAngle(void) const;
        virtual int getSwimRotAccelFrame(void) const;
        virtual int getSwimRotAccelFrameFast(void) const;
        virtual int getSwimRotBrakeFrame(void) const;
        virtual float getSwimRotSpeedChangeStart(void) const;
        virtual float getSwimRotSpeedForward(void) const;
        virtual float getSwimRotSpeedMax(void) const;
        virtual float getSwimSurfaceAccelH(void) const;
        virtual float getSwimSurfaceSpeedMaxH(void) const;
        virtual int getSwimSurfaceSpinCapFrame(void) const;
        virtual float getSwimSurfaceSpinCapSpeedMaxH(void) const;
        virtual float getSwimSurfaceStartDist(void) const;
        virtual float getSwimSurfaceEndDist(void) const;
        virtual float getSwimSurfaceGravity(void) const;
        virtual float getSwimSurfaceBaseHeight(void) const;
        virtual float getSwimSurfaceSpring(void) const;
        virtual float getSwimSurfaceDamper(void) const;
        virtual int getSwimSurfaceDamperStart(void) const;
        virtual int getSwimSurfaceDamperFrame(void) const;
        virtual float getSwimSurfaceEnableJumpHeight(void) const;
        virtual int getSwimSurfacePreInputJumpFrame(void) const;
        virtual float getSwimSurfaceMoveSpring(void) const;
        virtual float getSwimSurfaceMoveDamper(void) const;
        virtual float getSwimSurfaceMoveBaseHeight(void) const;
        virtual float getSwimRunSurfaceBaseHeight(void) const;
        virtual float getSwimRunSurfaceApproachRate(void) const;
        virtual float getSwimRunSurfaceApproachLimit(void) const;
        virtual float getSwimRunSurfaceBrakeBorder(void) const;
        virtual float getSwimRunSurfaceBrakeH(void) const;
        virtual float getSwimRunSurfaceApproachBorderMax(void) const;
        virtual float getSwimRunSurfaceApproachBorderMin(void) const;
        virtual float getSwimRunSurfaceApproachRateMin(void) const;
        virtual float getSwimFallInSpeed(void) const;
        virtual float getSwimFallInBrakeH(void) const;
        virtual float getSwimFallInBrakeV(void) const;
        virtual float getSwimHeadInBrakeH(void) const;
        virtual float getSwimHeadInBrakeV(void) const;
        virtual float getSwimHeadInRisePower(void) const;
        virtual float getSwimHeadInRiseSpeedMax(void) const;
        virtual float getSwimHeadInSurfaceHeight(void) const;
        virtual int getSwimFallInForceSurfaceFrame(void) const;
        virtual int getSwimFallInvalidJumpFrame(void) const;
        virtual float getSwimDiveStartSpeed(void) const;
        virtual float getSwimDiveBrake(void) const;
        virtual float getSwimDiveEndSpeed(void) const;
        virtual int getSwimDiveLandCount(void) const;
        virtual int getSwimDiveLandCancelFrame(void) const;
        virtual int getSwimDiveNoBrakeFrame(void) const;
        virtual int getSwimDiveButtonValidFrame(void) const;
        virtual int getSwimDiveEndFrame(void) const;
        virtual float getSwimDiveInBrakeH(void) const;
        virtual float getSwimDiveInBrakeV(void) const;
        virtual float getSwimDiveInRisePower(void) const;
        virtual float getSwimDiveInRiseSpeedMax(void) const;
        virtual float getSwimDiveInSurfaceHeight(void) const;
        virtual int getSwimDiveInKeepFrame(void) const;
        virtual int getSwimHeadSlidingFrame(void) const;
        virtual int getSwimHeadSlidingBrakeFrame(void) const;
        virtual float getSwimHeadSlidingSpeed(void) const;
        virtual float getSwimHeadSlidingSpeedEnd(void) const;
        virtual float getSwimHeadSlidingBrake(void) const;
        virtual float getSwimHeadSlidingSideAccel(void) const;
        virtual float getSwimHeadSlidingJump(void) const;
        virtual float getSwimHeadSlidingGravity(void) const;
        virtual int getSwimHeadSlidingEndBrakeFrame(void) const;
        virtual int getSwimHeadSlidingEndSpeedMin(void) const;
        virtual float getSwimJumpHipDropSpeed(void) const;
        virtual float getSwimJumpHipDropBrakeV(void) const;
        virtual float getSwimJumpHipDropBrakeVCeiling(void) const;
        virtual float getSwimJumpHipDropGravity(void) const;
        virtual float getSwimJumpHipDropCancelSpeed(void) const;
        virtual float getSwimJumpHipDropAccelH(void) const;
        virtual float getSwimJumpHipDropMoveSpeedH(void) const;
        virtual float getSwimJumpHipDropPopSpeed(void) const;
        virtual float getSwimJumpHipDropPopJumpAdd(void) const;
        virtual float getSwimTramplePower(void) const;
        virtual float getDiveTramplePower(void) const;
        virtual int getDiveTrampleCancelFrame(void) const;
        virtual float getDamageSwimPushPower(void) const;
        virtual float getDamageSwimGravity(void) const;
        virtual int getDamageSwimCancelFrame(void) const;
        virtual float getDamageSwimSurfaceGravity(void) const;
        virtual float getDamageSwimSurfaceHopPower(void) const;
        virtual float getDamageSwimSurfacePushPower(void) const;
        virtual float getDamageSwimSurfaceLandSpeed(void) const;
        virtual float getDamageSwimSurfaceLandBrake(void) const;
        virtual float getDamageSwimSurfaceLandEndSpeed(void) const;
        virtual int getDamageSwimSurfaceCancelFrame(void) const;
        virtual float getDamageSwimBrakeRateGround(void) const;
        virtual int getOxygenReduceFrame(void) const;
        virtual int getOxygenNoReduceFrame(void) const;
        virtual int getOxygenRecoveryFrame(void) const;
        virtual int getOxygenDamageerval(void) const;
        virtual int getIceWaterDamageerval(void) const;
        virtual int getIceWaterRecoveryFrame(void) const;
        virtual float getMoveAnimSpeedMax(void) const;
        virtual float getAnimFrameRateSpeedMin(void) const;
        virtual float getRunBorderSpeed(void) const;
        virtual float getRunBlendRange(void) const;
        virtual float getDashBorderSpeed(void) const;
        virtual float getDashBlendRange(void) const;
        virtual float getDashFastBorderSpeed(void) const;
        virtual float getDashFastBlendRange(void) const;
        virtual float getAnimFrameRateSpeedMax(void) const;
        virtual float getAnimFrameRateRunStart(void) const;
        virtual float getAnimFrameRateMinRun(void) const;
        virtual float getAnimFrameRateMaxRun(void) const;
        virtual float getAnimFrameRateMaxDash(void) const;
        virtual float getAnimFrameRateMaxDashFast(void) const;
        virtual float getRunStartPlayFrameScale(void) const;
        virtual int getRunStartBlendFrame(void) const;
        virtual float getDamageFireRunAnimRate(void) const;
        virtual float getRunSkateAnimSpeedOffset(void) const;
        virtual float getAnimFrameRateRange2D(void) const;
        virtual float getAnimFrameRateMinRun2D(void) const;
        virtual float getAnimFrameRateMaxRun2D(void) const;
        virtual int getIKBlendFrameRun(void) const;
        virtual float getIKBlendRateRunMin(void) const;
        virtual float getIKBlendRateRunMax(void) const;
        virtual float getRollingAnimBorderSpeedMin(void) const;
        virtual float getRollingAnimBorderSpeedMax(void) const;
        virtual float getRollingAnimFrameRateMin(void) const;
        virtual float getRollingAnimFrameRateMax(void) const;
        virtual int getSwimPaddleAnimerval(void) const;
        virtual int getSwimPaddleAnimRateervalMax(void) const;
        virtual int getSwimPaddleAnimRateervalMin(void) const;
        virtual float getSwimPaddleAnimMaxRate(void) const;
        virtual float getSwimBentForwardMax(void) const;
        virtual float getSwimBentForwardBlendRate(void) const;
        virtual float getSwimBentSideMax(void) const;
        virtual float getSwimBentSpineMax(void) const;
        virtual float getSwimBentSideBlendRate(void) const;
        virtual float getSwimBentFrontMax(void) const;
        virtual float getSwimBentFrontBlendRate(void) const;
        virtual float getSwimWalkAnimSpeedMax(void) const;
        virtual float getSwimWalkAnimSpeedMin(void) const;
        virtual float getSwimWalkAnimFrameRateMax(void) const;
        virtual float getSwimWalkAnimFrameRateMin(void) const;
        virtual float getSandSinkBorderMin(void) const;
        virtual float getSandSinkBorderMax(void) const;
        virtual float getSandSinkBorderRateMin(void) const;
        virtual float getSandSinkBorderRateMax(void) const;
        virtual float getSandSinkFrameRateMin(void) const;
        virtual float getSandSinkFrameRateMax(void) const;
        virtual int getLookAtEyeKeepFrame(void) const;
        virtual int getLookAtEyeKeepFrameInSight(void) const;
        virtual int getLookAtEyeKeepFrameWait(void) const;
        virtual float getLookAtEyeDistance(void) const;
        virtual float getLookAtEyeAngleMinH(void) const;
        virtual float getLookAtEyeAngleMinInSightH(void) const;
        virtual float getLookAtEyeAngleMaxH(void) const;
        virtual float getLookAtEyeAngleMinV(void) const;
        virtual float getLookAtEyeAngleMinInSightV(void) const;
        virtual float getLookAtEyeAngleMaxV(void) const;
        virtual float getTiltEyeBorderStart(void) const;
        virtual float getTiltEyeBorderEnd(void) const;
        virtual float getTiltEyeAngleScale(void) const;
        virtual float getCenterTiltRateMax(void) const;
        virtual float getNoseChildLocalOffset(void) const;
        virtual float getNoseStability(void) const;
        virtual float getNoseFriction(void) const;
        virtual float getNoseLimitDegree(void) const;
        virtual float getMustacheChildLocalOffset(void) const;
        virtual float getMustacheStability(void) const;
        virtual float getMustacheFriction(void) const;
        virtual float getMustacheLimitDegree(void) const;
        virtual int getCaperpolateFrame(void) const;
        virtual float getCapChildLocalOffset(void) const;
        virtual float getCapStability(void) const;
        virtual float getCapFriction(void) const;
        virtual float getCapLimitDegree(void) const;
        virtual float getCapTransStability(void) const;
        virtual float getCapTransFriction(void) const;
        virtual float getCapTransLimit(void) const;
        virtual int getCapManHeroEyesWaitAppearFrame(void) const;
        virtual int getDeadWipeStartDamage(void) const;
        virtual int getDeadWipeWaitDamage(void) const;
        virtual int getDeadWipeStartAbyss(void) const;
        virtual int getDeadWipeWaitAbyss(void) const;
        virtual int getDeadWipeStartAbyssWithCapMsg(void) const;
        virtual int getDeadWipeWaitAbyssWithCapMsg(void) const;
        virtual int getDeadWipeStartPress(void) const;
        virtual int getDeadWipeWaitPress(void) const;
        virtual int getDeadWipeStartSandSink(void) const;
        virtual int getDeadWipeWaitSandSink(void) const;
    // private:
        float mGravity;
        float mFrictionAttack;
        float mPushPower;
        float mWaitPoseDegreeMax;
        float mHillPoseDegreeMax;
        float mTiltPoseDegreeMax;
        float mSlerpQuatRate;
        float mSlerpQuatRateWait;
        float mSlerpQuatGrav;
        int mPreInputFrameCapThrow;
        int mEnableActionFrameCapCatch;
        float mJumpPowerCapCatch;
        float mJumpGravityCapCatch;
        int mRunTimeContinuousThrow;
        float mRunSpeedMaxContinuousThrow;
        int mRunAccelFrameContinuousThrow;
        float mSeparateCheckHeight;
        float mSeparateOffsetLerpRate;
        float mSeparateEnableThrowHeight;
        float mTall;
        float mCollisionRadius;
        float mCollisionRadiusSquat;
        float mCollisionRadiusStand;
        float mCollisionSmallStepHeight;
        float mCollisionResetLimit;
        float mReflectCeilingPower;
        float mReflectTossPower;
        float mReflectUpperPunchScaleH;
        float mCollisionHitDownAngleH;
        float mCollisionHitDownEscapeAngleV;
        float mShadowDropHeightScale;
        float mShadowDropNormalAdd;
        float mShadowDropLengthMin;
        float mShadowDropLengthMax;
        float mShadowDropLengthExtend;
        float mGravityDamage;
        float mHopPowerDamage;
        float mPushPowerDamage;
        int mDamageCancelFrame;
        int mDamageInvalidCount;
        int mDamageInvalidCountRecovery;
        int mDamageInvalidCountAbyss;
        float mNormalMinSpeed2D;
        float mNormalMaxSpeed2D;
        float mDashMaxSpeed2D;
        int mNormalAccelFrame2D;
        int mDashAccelFrame2D;
        int mNormalDashAnimFrame2D;
        int mNormalBrakeFrame2D;
        int mStickOnBrakeFrame2D;
        int mBrakeTurnStartFrame2D;
        float mTurnEndSpeedRate2D;
        float mJumpPowerMin2DArea;
        float mJumpPowerMax2DArea;
        float mJumpPowerMinBorder2D;
        float mJumpPowerMaxBorder2D;
        float mGravityMove;
        float mNormalMaxSpeed;
        float mNormalMinSpeed;
        int mNormalAccelFrame;
        float mRunAccelAverageScale;
        int mNormalBrakeFrame;
        float mDashJudgeSpeed;
        int mStickOnBrakeFrame;
        int mNormalDashAnimFrame;
        float mRunAfterTurnSpeedMax;
        float mRunAfterTurnScale;
        int mRunAfterTurnFrame;
        int mBrakeTurnStartFrame;
        float mBrakeOnSpeedRate;
        int mBrakeOnCounterBorder;
        int mWallPushFrame;
        int mRunDeepDownFrame;
        int mRunDeepDownMargine;
        int mQuickTurnJumpFrame;
        int mRoundAccelFrame;
        int mRoundBrakeFrame;
        float mRoundFastDegree;
        int mRoundAccelFrameFast;
        float mRoundMinDegree;
        int mRoundBrakeFrameForce;
        float mRoundFastDegreeForce;
        float mRoundLimitDegreeForce;
        float mRoundLimitDegreeForceFast;
        int mRoundAccelFrameForceFast;
        float mRoundLimitDegreeMin;
        float mRoundLimitDegree;
        int mIceAccelFrame;
        int mIceBrakeFrame;
        int mIceBrakeFrameHigh;
        int mIceBrakeFrameWall;
        int mIceRoundAccelFrame;
        int mIceRoundAccelFrameFast;
        int mIceRoundBrakeFrame;
        float mIceRoundFastDegree;
        float mIceRoundMinDegree;
        float mIceRoundLimitDegree;
        float mHillAddSpeed;
        float mHillSubSpeed;
        int mHillAccelAddFrame;
        int mHillAccelSubFrame;
        float mHillAccelSubAngleMin;
        float mHillAccelSubAngleMax;
        float mStandAngleMin;
        float mStandAngleMax;
        float mHillAngleSpeedMin;
        float mHillAngleSpeedMax;
        int mSpinCapThrowFrame;
        int mSpinCapThrowFrameAir;
        int mSpinCapThrowFrameSwim;
        int mSpinCapThrowFrameSwing;
        int mSpinCapThrowFrameContinuous;
        int mSpinAttackFrame;
        int mSpinBrakeFrame;
        float mSpinAirJumpPower;
        float mSpinAirSpeedMax;
        float mGravitySpinAir;
        float mSlerpQuatRateSpinAir;
        float mSpinBrakeRate;
        float mSpinBrakeSideAccel;
        float mSpinBrakeSideBrakeRate;
        float mSpinBrakeSideMaxSpeedRate;
        float mSpinRoundLimitDegree;
        float mDamageFireJumpPower1st;
        float mDamageFireJumpPower2nd;
        float mDamageFireJumpMoveSpeed;
        float mDamageFireCeilHitSpeed;
        float mDamageFireGravity;
        int mDamageFireNoGravityFrame;
        int mDamageFireRunTime;
        float mDamageFireRunSpeed;
        float mDamageFireRunBrakeFrame;
        int mSandSinkDeadTime;
        int mSandSinkBrakeHeightH;
        int mSandSinkBrakeHeightV;
        float mSandSinkHeight;
        float mSandSinkCapThrow;
        float mSandSinkBrakeMinH;
        float mSandSinkBrakeMaxH;
        float mSandSinkBrakeMinV;
        float mSandSinkBrakeMaxV;
        float mSlopeSlideAngleStart;
        float mSlopeSlideAngleEnd;
        float mSlopeSlideAccel;
        float mSlopeSlideBrake;
        float mSlopeSlideMaxSpeed;
        float mSlopeSlideSpeedEnd;
        float mSlopeSlideSideAccel;
        float mSlopeSlideSideBrake;
        float mSlopeSlideSideMaxSpeed;
        float mSlopeTurnDegree;
        int mSlideInvalidFrame;
        int mSlopeForceFrame;
        float mSlopeSlideForceSideAccel;
        float mSlopeSlideForceSideBrake;
        float mSlopeSlideForceSideMaxSpeed;
        float mSlopeSlideForceTurnDegree;
        float mSlopeRollingSpeedStart;
        float mSlopeRollingSpeedBoost;
        float mSlopeRollingMaxSpeed;
        int mSlopeRollingFrameMinBoost;
        int mSlopeRollingFrameMin;
        float mSlopeRollingStartJumpPower;
        float mSlopeRollingStartSlideSpeed;
        float mSlopeRollingAccel;
        float mSlopeRollingBrake;
        float mSlopeRollingAgainst;
        float mSlopeRollingAnglePowerMax;
        float mSlopeRollingSpeedEnd;
        float mSlopeRollingSideAccel;
        float mSlopeRollingSideBrake;
        float mSlopeRollingSideMaxSpeed;
        int mSlopeRollingUnRollFrame;
        float mSlopeRollingEndBrake;
        float mSlopeRollingEndBrakeEndSpeed;
        float mSlopeRollingReStartAccel;
        float mSlopeRollingReStartMaxAdd;
        int mSlopeRollingReStartinterval;
        int mSlopeRollingReStartSwing;
        int mSlopeRollingReStartCharge;
        int mSlopeRollingReStartForce;
        float mSlopeRollingAccelOnSkate;
        float mSlopeRollingSideAccelOnSkate;
        float mSlopeRollingBrakeOnSkate;
        int mExtendFrame;
        float mJumpInertiaRate;
        float mJumpPowerMin;
        float mJumpPowerMax;
        float mJumpGravity;
        float mJumpBaseSpeedMax;
        float mJumpMoveSpeedMin;
        float mJumpMoveSpeedMax;
        float mJumpAccelFront;
        float mJumpAccelBack;
        float mJumpAccelTurn;
        float mJumpTurnAngleStart;
        float mJumpTurnAngleLimit;
        float mJumpTurnAngleFast;
        float mJumpTurnAngleFastLimit;
        int mJumpTurnAccelFrame;
        int mJumpTurnAccelFrameFast;
        int mJumpTurnBrakeFrame;
        float mTrampleGravity;
        float mTrampleJumpPower;
        float mTrampleHighGravity;
        float mTrampleHighJumpPower;
        float mTrampleGravity2D;
        float mTrampleJumpPower2D;
        float mTrampleHighGravity2D;
        float mTrampleHighJumpPower2D;
        float mTrampleHipDropGravity;
        float mTrampleHipDropJumpPower;
        float mTrampleRisingBrakeVelH;
        float mTrampleJumpCodePower;
        float mTrampleJumpCodePowerSmall;
        float mCapLeapFrogJumpGravity;
        float mCapLeapFrogJumpPower;
        float mCapLeapFrogJumpPowerAir;
        float mObjLeapFrogJumpPower;
        float mObjLeapFrogJumpPowerHigh;
        float mCapHeadSpringJumpGravity;
        float mCapHeadSpringJumpPower;
        float mCapHeadSpringJumpGravityHigh;
        float mCapHeadSpringJumpPowerHigh;
        float mCapHeadSpringSpeedMax;
        int mContinuousJumpPreInputFrame;
        int mContinuousJumpCount;
        int mContinuousJumpTimer;
        float mContinuousJumpPowerMin;
        float mJumpPowerMax2nd;
        float mJumpGravity2nd;
        float mJumpPowerMax3rd;
        float mJumpGravity3rd;
        float mSpinFlowerJumpGravity;
        float mSpinFlowerJumpFallSpeedMax;
        float mSpinFlowerJumpMovePower;
        float mSpinFlowerJumpVelMax;
        int mSpinFlowerJumpStayFrame;
        float mSpinFlowerJumpStaySpeedMax;
        float mSpinFlowerJumpNoInputBrake;
        float mSpinFlowerJumpDownFallInitSpeed;
        float mSpinFlowerJumpDownFallPower;
        float mSpinFlowerJumpDownFallSpeedMax;
        float mJumpGravityForceRun;
        float mJumpPowerForceRun;
        float mCapCatchPopPower;
        float mCapCatchPopGravity;
        float mSquatJumpGravity;
        float mSquatJumpPower;
        float mSquatJumpBackPower;
        float mSquatJumpMovePowerFront;
        float mSquatJumpMovePowerSide;
        float mSquatJumpMoveSpeedMax;
        float mTurnJumpGravity;
        float mTurnJumpPower;
        float mTurnJumpVelH;
        float mTurnJumpBrake;
        float mTurnJumpAccel;
        float mTurnJumpSideAccel;
        float mLongJumpAccel;
        float mLongJumpBrake;
        float mLongJumpSideAccel;
        float mLongJumpGravity;
        float mLongJumpJumpPow;
        float mLongJumpMovePow;
        float mLongJumpInitSpeed;
        float mLongJumpSpeed;
        float mLongJumpSpeedMin;
        int mContinuousLongJumpCount;
        int mContinuousLongJumpTimer;
        float mGravityAir;
        float mFrictionAir;
        float mFallSpeedMax;
        float mLongFallDistance;
        float mFallWallScaleVelocity;
        int mDownFallFrameMin;
        float mGravityWallSlide;
        float mWallHeightLowLimit;
        float mWallKeepDegree;
        int mWallKeepFrame;
        float mWallJumpGravity;
        float mWallJumpHSpeed;
        float mWallJumpPower;
        int mWallJumpInvalidateInputFrame;
        int mWallInhibitAfterPunch;
        float mWallFollowAngleH;
        float mWallFollowAngleV;
        float mWallCatchDegree;
        float mWallCatchHeightEdgeTop;
        float mWallCatchHeightBottom;
        float mWallCatchKeepDegree;
        float mWallCatchMoveDegree;
        float mWallCatchMoveSpeed;
        float mWallCatchMoveHeightRange;
        int mWallCatchMoveinterpolate;
        int mWallCatchMoveFrame;
        int mWallCatchMoveFrameFast;
        int mWallCatchMoveFrameSwing;
        float mWallCatchInputRepeatAngle;
        float mWallClimbDegree;
        int mWallClimbJumpStartFrame;
        int mWallClimbJumpEndFrame;
        int mWallClimbStartFrame;
        float mWallClimbGravity;
        float mWallFallJumpSpeed;
        float mWallClimbJumpSpeedV;
        float mWallClimbJumpSpeedH;
        float mWallClimbJumpGravity;
        int mWallClimbJumpInvalidFrame;
        float mWallCatchHipLocalOffset;
        float mWallCatchHipStability;
        float mWallCatchHipFriction;
        float mWallCatchHipLimitDegree;
        float mWallCatchStainAreaOffset;
        float mGrabCeilRange;
        float mGrabCeilBodyRadius;
        float mGrabCeilLeaveSpeedMin;
        float mGrabCeilLeavePopPower;
        float mGrabCeilLeavePopGravity;
        float mGrabCeilSwingStartOffset;
        float mGrabCeilReverseInputBorder;
        float mGrabCeilInputPowerBorder;
        float mGrabCeilSwingWaitEnergy;
        float mGrabCeilEnableJumpEnergy;
        float mGrabCeilEnableJumpEnergyMax;
        float mGrabCeilJumpForceAngle;
        float mGrabCeilJumpPower;
        float mGrabCeilJumpMoveMin;
        float mGrabCeilJumpMoveMax;
        float mGrabCeilJumpGravity;
        int mGrabCeilJumpInvalidFrame;
        int mGrabCeilEnableNextFrame;
        int mGrabCeilEnableFallSnapFrame;
        int mPoleClimbPreInputSwing;
        float mPoleClimbInputRepeatAngle;
        float mPoleClimbInputDegreeMove;
        float mPoleClimbCatchRange;
        float mPoleClimbCatchRangeMin;
        float mPoleClimbCatchRangeMax;
        float mPoleClimbJointAngleMin;
        float mPoleClimbJointAngleMax;
        float mPoleClimbJointRangeMin;
        float mPoleClimbJointRangeMax;
        float mPoleClimbMoveWallDegree;
        float mPoleClimbUpMargine;
        float mPoleClimbUpSpeed;
        int mPoleClimbUpFrame;
        int mPoleClimbUpFrameFast;
        int mPoleClimbUpFrameSwing;
        float mPoleClimbDownSpeed;
        float mPoleClimbDownSpeedFast;
        float mPoleClimbDownSpeedSwing;
        int mPoleClimbDownFrame;
        int mPoleClimbDownKeepTime;
        float mPoleClimbTurnDist;
        int mPoleClimbTurnFrame;
        int mPoleClimbTurnStopFrame;
        int mPoleTopStartFrame;
        int mPoleTopEndFrame;
        float mPoleTopTurnSpeed;
        float mPoleTopEndUnderOffsetY;
        int mGroundSpinFrame;
        float mGroundSpinMoveSpeedMax;
        float mGroundSpinAccelRate;
        float mGroundSpinBrakeRate;
        float mSpinJumpGravity;
        float mSpinJumpPower;
        float mSpinJumpMoveSpeedMax;
        float mSpinJumpDownFallInitSpeed;
        float mSpinJumpDownFallPower;
        float mSpinJumpDownFallSpeedMax;
        float mSquatBrakeEndSpeed;
        float mSquatAccelRate;
        float mSquatBrakeRate;
        float mSquatBrakeRateOnSkate;
        float mSquatBrakeSideAccel;
        float mSquatBrakeSideRate;
        float mSquatBrakeSideAccelOnSkate;
        float mSquatBrakeSideRateOnSkate;
        float mSquatBrakeSideMaxSpeedRate;
        float mSquatWalkSpeed;
        float mSquatWalkTurnSpeed;
        int mSquatWalkTurnFrame;
        float mSquatJumpCeilSlideSpeed2D;
        float mHipDropSpeed;
        float mHipDropGravity;
        float mHipDropSpeedMax;
        int mHipDropLandCancelFrame;
        float mHipDropHeight;
        int mHipDropMsginterval;
        float mJumpHipDropPower;
        int mJumpHipDropPermitBeginFrame;
        int mJumpHipDropPermitEndFrame;
        float mHeadSlidingSpeed;
        float mHeadSlidingSpeedMin;
        float mHeadSlidingBrake;
        float mHeadSlidingSideAccel;
        float mHeadSlidingJump;
        float mHeadSlidingGravityAir;
        float mSwimCenterOffset;
        float mSwimWallCatchOffset;
        float mSwimRisePower;
        float mSwimRiseSpeedMax;
        int mSwimRiseFrame;
        float mSwimGravity;
        float mSwimGravityWalk;
        float mSwimFallSpeedMax;
        float mSwimFloorAccelH;
        float mSwimFloorSpeedMaxH;
        float mSwimHighAccelH;
        float mSwimHighSpeedMaxH;
        float mSwimLowAccelH;
        float mSwimLowSpeedMaxH;
        float mSwimBrakeRateH;
        float mSwimWallHitSpeedMinH;
        int mSwimHighAccelPermitFrame;
        float mSwimFlowFieldBlend;
        float mSwimWalkAnimMinRate;
        float mSwimWalkAnimMaxRate;
        float mSwimWalkMaxSpeed;
        float mSwimSpinCapUpPower;
        float mSwimSpinCapUpSpeedMax;
        float mSwimRotStartAngle;
        float mSwimRotFastAngle;
        int mSwimRotAccelFrame;
        int mSwimRotAccelFrameFast;
        int mSwimRotBrakeFrame;
        float mSwimRotSpeedChangeStart;
        float mSwimRotSpeedForward;
        float mSwimRotSpeedMax;
        float mSwimSurfaceAccelH;
        float mSwimSurfaceSpeedMaxH;
        int mSwimSurfaceSpinCapFrame;
        float mSwimSurfaceSpinCapSpeedMaxH;
        float mSwimSurfaceStartDist;
        float mSwimSurfaceEndDist;
        float mSwimSurfaceGravity;
        float mSwimSurfaceBaseHeight;
        float mSwimSurfaceSpring;
        float mSwimSurfaceDamper;
        int mSwimSurfaceDamperStart;
        int mSwimSurfaceDamperFrame;
        float mSwimSurfaceEnableJumpHeight;
        int mSwimSurfacePreInputJumpFrame;
        float mSwimSurfaceMoveSpring;
        float mSwimSurfaceMoveDamper;
        float mSwimSurfaceMoveBaseHeight;
        float mSwimRunSurfaceBaseHeight;
        float mSwimRunSurfaceApproachRate;
        float mSwimRunSurfaceApproachLimit;
        float mSwimRunSurfaceBrakeBorder;
        float mSwimRunSurfaceBrakeH;
        float mSwimRunSurfaceApproachBorderMax;
        float mSwimRunSurfaceApproachBorderMin;
        float mSwimRunSurfaceApproachRateMin;
        float mSwimFallInSpeed;
        float mSwimFallInBrakeH;
        float mSwimFallInBrakeV;
        float mSwimHeadInBrakeH;
        float mSwimHeadInBrakeV;
        float mSwimHeadInRisePower;
        float mSwimHeadInRiseSpeedMax;
        float mSwimHeadInSurfaceHeight;
        int mSwimFallInForceSurfaceFrame;
        int mSwimFallInvalidJumpFrame;
        float mSwimDiveStartSpeed;
        float mSwimDiveBrake;
        float mSwimDiveEndSpeed;
        int mSwimDiveLandCount;
        int mSwimDiveLandCancelFrame;
        int mSwimDiveNoBrakeFrame;
        int mSwimDiveButtonValidFrame;
        int mSwimDiveEndFrame;
        float mSwimDiveInBrakeH;
        float mSwimDiveInBrakeV;
        float mSwimDiveInRisePower;
        float mSwimDiveInRiseSpeedMax;
        float mSwimDiveInSurfaceHeight;
        int mSwimDiveInKeepFrame;
        int mSwimHeadSlidingFrame;
        int mSwimHeadSlidingBrakeFrame;
        float mSwimHeadSlidingSpeed;
        float mSwimHeadSlidingSpeedEnd;
        float mSwimHeadSlidingBrake;
        float mSwimHeadSlidingSideAccel;
        float mSwimHeadSlidingJump;
        float mSwimHeadSlidingGravity;
        int mSwimHeadSlidingEndBrakeFrame;
        int mSwimHeadSlidingEndSpeedMin;
        float mSwimJumpHipDropSpeed;
        float mSwimJumpHipDropBrakeV;
        float mSwimJumpHipDropBrakeVCeiling;
        float mSwimJumpHipDropGravity;
        float mSwimJumpHipDropCancelSpeed;
        float mSwimJumpHipDropAccelH;
        float mSwimJumpHipDropMoveSpeedH;
        float mSwimJumpHipDropPopSpeed;
        float mSwimJumpHipDropPopJumpAdd;
        float mSwimTramplePower;
        float mDiveTramplePower;
        int mDiveTrampleCancelFrame;
        float mDamageSwimPushPower;
        float mDamageSwimGravity;
        int mDamageSwimCancelFrame;
        float mDamageSwimSurfaceGravity;
        float mDamageSwimSurfaceHopPower;
        float mDamageSwimSurfacePushPower;
        float mDamageSwimSurfaceLandSpeed;
        float mDamageSwimSurfaceLandBrake;
        float mDamageSwimSurfaceLandEndSpeed;
        int mDamageSwimSurfaceCancelFrame;
        float mDamageSwimBrakeRateGround;
        int mOxygenReduceFrame;
        int mOxygenNoReduceFrame;
        int mOxygenRecoveryFrame;
        int mOxygenDamageinterval;
        int mIceWaterDamageinterval;
        int mIceWaterRecoveryFrame;
        float mMoveAnimSpeedMax;
        float mAnimFrameRateSpeedMin;
        float mRunBorderSpeed;
        float mRunBlendRange;
        float mDashBorderSpeed;
        float mDashBlendRange;
        float mDashFastBorderSpeed;
        float mDashFastBlendRange;
        float mAnimFrameRateSpeedMax;
        float mAnimFrameRateRunStart;
        float mAnimFrameRateMinRun;
        float mAnimFrameRateMaxRun;
        float mAnimFrameRateMaxDash;
        float mAnimFrameRateMaxDashFast;
        float mRunStartPlayFrameScale;
        int mRunStartBlendFrame;
        float mDamageFireRunAnimRate;
        float mRunSkateAnimSpeedOffset;
        float mAnimFrameRateRange2D;
        float mAnimFrameRateMinRun2D;
        float mAnimFrameRateMaxRun2D;
        int mIKBlendFrameRun;
        float mIKBlendRateRunMin;
        float mIKBlendRateRunMax;
        float mRollingAnimBorderSpeedMin;
        float mRollingAnimBorderSpeedMax;
        float mRollingAnimFrameRateMin;
        float mRollingAnimFrameRateMax;
        int mSwimPaddleAniminterval;
        int mSwimPaddleAnimRateintervalMax;
        int mSwimPaddleAnimRateintervalMin;
        float mSwimPaddleAnimMaxRate;
        float mSwimBentForwardMax;
        float mSwimBentForwardBlendRate;
        float mSwimBentSideMax;
        float mSwimBentSpineMax;
        float mSwimBentSideBlendRate;
        float mSwimBentFrontMax;
        float mSwimBentFrontBlendRate;
        float mSwimWalkAnimSpeedMax;
        float mSwimWalkAnimSpeedMin;
        float mSwimWalkAnimFrameRateMax;
        float mSwimWalkAnimFrameRateMin;
        float mSandSinkBorderMin;
        float mSandSinkBorderMax;
        float mSandSinkBorderRateMin;
        float mSandSinkBorderRateMax;
        float mSandSinkFrameRateMin;
        float mSandSinkFrameRateMax;
        int mLookAtEyeKeepFrame;
        int mLookAtEyeKeepFrameInSight;
        int mLookAtEyeKeepFrameWait;
        float mLookAtEyeDistance;
        float mLookAtEyeAngleMinH;
        float mLookAtEyeAngleMinInSightH;
        float mLookAtEyeAngleMaxH;
        float mLookAtEyeAngleMinV;
        float mLookAtEyeAngleMinInSightV;
        float mLookAtEyeAngleMaxV;
        float mTiltEyeBorderStart;
        float mTiltEyeBorderEnd;
        float mTiltEyeAngleScale;
        float mCenterTiltRateMax;
        float mNoseChildLocalOffset;
        float mNoseStability;
        float mNoseFriction;
        float mNoseLimitDegree;
        float mMustacheChildLocalOffset;
        float mMustacheStability;
        float mMustacheFriction;
        float mMustacheLimitDegree;
        int mCapinterpolateFrame;
        float mCapChildLocalOffset;
        float mCapStability;
        float mCapFriction;
        float mCapLimitDegree;
        float mCapTransStability;
        float mCapTransFriction;
        float mCapTransLimit;
        int mCapManHeroEyesWaitAppearFrame;
        int mDeadWipeStartDamage;
        int mDeadWipeWaitDamage;
        int mDeadWipeStartAbyss;
        int mDeadWipeWaitAbyss;
        int mDeadWipeStartAbyssWithCapMsg;
        int mDeadWipeWaitAbyssWithCapMsg;
        int mDeadWipeStartPress;
        int mDeadWipeWaitPress;
        int mDeadWipeStartSandSink;
        int mDeadWipeWaitSandSink;
        int mDeadWipeStartNoOxygen;
        int mDeadWipeWaitNoOxygen;
        int mDeadWipeStartIceWater;
        int mDeadWipeWaitIceWater;
        float mCoinDashSpeed;
        float mCoinDashSpeedLimit;
        float mAdditionalSpeedLimit;
};