#pragma once

#include <math/seadVector.h>
#include <math/seadQuat.h>
#include <gfx/seadColor.h>

namespace al {
    void separateScalarAndDirection(float *,sead::Vector2f *,sead::Vector2f const&);
    void separateScalarAndDirection(float *,sead::Vector3f *,sead::Vector3f const&);
    void limitVectorSeparateHV(sead::Vector3f *,sead::Vector3f const&,float,float);
    void parallelizeVec(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&);
    void calcVectorSeparateHV(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&,float,float);
    void limitVectorParallelVertical(sead::Vector3f *,sead::Vector3f const&,float,float);
    void separateVectorParallelVertical(sead::Vector3f *,sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&);
    void addVectorLimit(sead::Vector3f *,sead::Vector3f const&,float);
    void alongVectorNormalH(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&,sead::Vector3f const&);
    void calcDistanceVecToPlane(sead::Vector3f const&,sead::Vector3f const&,sead::Vector3f const&,sead::Vector3f const&);
    void limitPlanePos(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&,sead::Vector3f const&);
    void limitCylinderInPos(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&,sead::Vector3f const&,float);
    void limitCylinderInDir(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&,sead::Vector3f const&,sead::Vector3f const&);
    void limitCylinderInPos(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&,float);
    void limitCylinderInDir(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&,sead::Vector3f const&);
    void roundOffVec(sead::Vector3f *,sead::Vector3f const&);
    void roundOffVec(sead::Vector3f *);
    void roundOffVec(sead::Vector2f *,sead::Vector2f const&);
    void roundOffVec(sead::Vector2f *);
    void snapToGrid(float,float,float);
    void snapVecToGrid(sead::Vector3f *,sead::Vector3f const&,float,sead::Vector3f const&);
    void snapVecToGrid(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&,sead::Vector3f const&);
    void limitVectorOppositeDir(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&,float);
    void scaleVectorDirection(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&,float);
    void scaleVectorExceptDirection(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&,float);
    void snapVecToDirAxisY(sead::Vector3f *,sead::Vector3f const&,int);
    void calcDir(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&);
    void calcDirH(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&);
    void calcDirOnPlane(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&,sead::Vector3f const&);
    void mapRangeLogarithmic(float,float,float,float,float,float);
    void calcDirFromLongitudeLatitude(sead::Vector3f *,float,float);
    void calcLongitudeLatitudeFromDir(float *,float *,sead::Vector3f const&);
    void getMaxAbsElementIndex(sead::Vector3<int> const&);
    void getMaxAbsElementValue(sead::Vector3f const&);
    void getMaxAbsElementValue(sead::Vector3<int> const&);
    void getMinAbsElementIndex(sead::Vector3f const&);
    void getMinAbsElementIndex(sead::Vector3<int> const&);
    void getMinAbsElementValue(sead::Vector3f const&);
    void getMinAbsElementValue(sead::Vector3<int> const&);
    void calcNearVecFromAxis2(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&,sead::Vector3f const&);
    void calcNearVecFromAxis3(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&,sead::Vector3f const&,sead::Vector3f const&);
    void calcDirVerticalAny(sead::Vector3f *,sead::Vector3f const&);
    void calcDirSlide(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&);
    void calcNearVecFromAxis3(sead::Vector3f *,sead::Vector3f const&,sead::Quatf const&);
    void calcQuatLocalAxisAll(sead::Quatf const&,sead::Vector3f *,sead::Vector3f *,sead::Vector3f *);
    void addRandomVector(sead::Vector3f *,sead::Vector3f const&,float);
    void turnRandomVector(sead::Vector3f *,sead::Vector3f const&,float);
    void makeAxisFrontUp(sead::Vector3f *,sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&);
    void makeAxisFrontSide(sead::Vector3f *,sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&);
    void makeAxisUpFront(sead::Vector3f *,sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&);
    void makeAxisUpSide(sead::Vector3f *,sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&);
    void makeQuatFromTwoAxis(sead::Quatf *,sead::Vector3f const&,sead::Vector3f const&,int,int);
    void makeQuatFrontUp(sead::Quatf *,sead::Vector3f const&,sead::Vector3f const&);
    void makeQuatFrontSide(sead::Quatf *,sead::Vector3f const&,sead::Vector3f const&);
    void makeQuatFrontNoSupport(sead::Quatf *,sead::Vector3f const&);
    void makeQuatUpFront(sead::Quatf *,sead::Vector3f const&,sead::Vector3f const&);
    void makeQuatUpSide(sead::Quatf *,sead::Vector3f const&,sead::Vector3f const&);
    void makeQuatUpNoSupport(sead::Quatf *,sead::Vector3f const&);
    void makeQuatSideUp(sead::Quatf *,sead::Vector3f const&,sead::Vector3f const&);
    void makeQuatSideFront(sead::Quatf *,sead::Vector3f const&,sead::Vector3f const&);
    void makeQuatSideNoSupport(sead::Quatf *,sead::Vector3f const&);
    void makeQuatFromToQuat(sead::Quatf *,sead::Quatf const&,sead::Quatf const&);
    void makeQuatRotationRate(sead::Quatf *,sead::Vector3f const&,sead::Vector3f const&,float);
    void makeQuatRotationLimit(sead::Quatf *,sead::Vector3f const&,sead::Vector3f const&,float);
    void makeQuatAxisRotation(sead::Quatf *,sead::Vector3f const&,sead::Vector3f const&,sead::Vector3f const&,float);
    void makeQuatRotateDegree(sead::Quatf *,sead::Vector3f const&,float);
    void slerpQuat(sead::Quatf *,sead::Quatf const&,sead::Quatf const&,float);
    void calcQuatSide(sead::Vector3f *,sead::Quatf const&);
    void calcQuatUp(sead::Vector3f *,sead::Quatf const&);
    void calcQuatGravity(sead::Vector3f *,sead::Quatf const&);
    void calcQuatFront(sead::Vector3f *,sead::Quatf const&);
    void calcQuatUpY(sead::Quatf const&);
    void calcQuatFrontY(sead::Quatf const&);
    void calcQuatLocalAxis(sead::Vector3f *,sead::Quatf const&,int);
    void calcQuatLocalSignAxis(sead::Vector3f *,sead::Quatf const&,int);
    void calcQuatRotateDegree(sead::Vector3f *,sead::Quatf const&);
    void calcQuatRotateRadian(sead::Vector3f *,sead::Quatf const&);
    void calcQuatRotateAxisAndDegree(sead::Vector3f *,float *,sead::Quatf const&);
    void calcQuatRotateAxisAndDegree(sead::Vector3f *,float *,sead::Quatf const&,sead::Quatf const&);
    void rotateQuatRadian(sead::Quatf *,sead::Quatf const&,sead::Vector3f const&,float);
    void makeQuatXDegree(sead::Quatf *,float);
    void makeQuatYDegree(sead::Quatf *,float);
    void makeQuatZDegree(sead::Quatf *,float);
    void rotateQuatXDirDegree(sead::Quatf *,sead::Quatf const&,float);
    void rotateQuatYDirDegree(sead::Quatf *,sead::Quatf const&,float);
    void rotateQuatZDirDegree(sead::Quatf *,sead::Quatf const&,float);
    void rotateQuatLocalDirDegree(sead::Quatf *,sead::Quatf const&,int,float);
    void rotateQuatMoment(sead::Quatf *,sead::Quatf const&,sead::Vector3f const&);
    void rotateQuatMomentDegree(sead::Quatf *,sead::Quatf const&,sead::Vector3f const&);
    void rotateQuatRollBall(sead::Quatf *,sead::Quatf const&,sead::Vector3f const&,sead::Vector3f const&,float);
    void calcMomentRollBall(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&,float);
    void turnQuat(sead::Quatf *,sead::Quatf const&,sead::Vector3f const&,sead::Vector3f const&,float);
    void turnQuatXDirRadian(sead::Quatf *,sead::Quatf const&,sead::Vector3f const&,float);
    void turnQuatYDirRadian(sead::Quatf *,sead::Quatf const&,sead::Vector3f const&,float);
    void turnQuatZDirRadian(sead::Quatf *,sead::Quatf const&,sead::Vector3f const&,float);
    void turnQuatXDirRate(sead::Quatf *,sead::Quatf const&,sead::Vector3f const&,float);
    void turnQuatYDirRate(sead::Quatf *,sead::Quatf const&,sead::Vector3f const&,float);
    void turnQuatZDirRate(sead::Quatf *,sead::Quatf const&,sead::Vector3f const&,float);
    void tiltQuatDegree(sead::Quatf *,sead::Quatf const&,sead::Vector3f const&,sead::Vector3f const&,float);
    void tiltQuatXDirDegree(sead::Quatf *,sead::Quatf const&,sead::Vector3f const&,float);
    void tiltQuatYDirDegree(sead::Quatf *,sead::Quatf const&,sead::Vector3f const&,float);
    void tiltQuatZDirDegree(sead::Quatf *,sead::Quatf const&,sead::Vector3f const&,float);
    void turnQuatWithAxisDegree(sead::Quatf *,sead::Quatf const&,sead::Vector3f const&,sead::Vector3f const&,sead::Vector3f const&,float);
    void turnQuatXDirWithYDirDegree(sead::Quatf *,sead::Quatf const&,sead::Vector3f const&,float);
    void turnQuatXDirWithZDirDegree(sead::Quatf *,sead::Quatf const&,sead::Vector3f const&,float);
    void turnQuatYDirWithZDirDegree(sead::Quatf *,sead::Quatf const&,sead::Vector3f const&,float);
    void turnQuatYDirWithXDirDegree(sead::Quatf *,sead::Quatf const&,sead::Vector3f const&,float);
    void turnQuatZDirWithXDirDegree(sead::Quatf *,sead::Quatf const&,sead::Vector3f const&,float);
    void turnQuatZDirWithYDirDegree(sead::Quatf *,sead::Quatf const&,sead::Vector3f const&,float);
    void turnQuatZDirToTargetWithAxis(sead::Quatf *,sead::Vector3f const&,sead::Vector3f const&,float);
    void turnQuatFrontToDirDegreeH(sead::Quatf *,sead::Vector3f const&,float);
    void rotateQuatAndTransDegree(sead::Quatf *,sead::Vector3f *,sead::Quatf const&,sead::Vector3f const&,sead::Vector3f const&,sead::Vector3f const&,float);
    void turnVecToVecDegree(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&,float);
    void turnVecToVecRate(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&,float);
    void turnVecToVecCos(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&,float,sead::Vector3f const&,float);
    void turnVecToVecCosOnPlane(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&,sead::Vector3f const&,float);
    void turnVecToVecCosOnPlane(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&,float);
    void rotateVectorCenterDegree(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&,sead::Vector3f const&,float);
    void rotateVectorDegreeX(sead::Vector3f *,float);
    void rotateVectorDegreeY(sead::Vector3f *,float);
    void rotateVectorDegreeZ(sead::Vector3f *,float);
    void rotateVectorQuat(sead::Vector3f *,sead::Quatf const&);

    void clampV3f(sead::Vector3f *,sead::Vector3f const&,sead::Vector3f const&);
    void clampV2f(sead::Vector2f *,sead::Vector2f const&,sead::Vector2f const&);

}