#pragma once

#include <math/seadVector.h>
#include <math/seadMatrix.h>

namespace al {

    class LiveActor;
    class SklAnimRetargettingInfo;

    void startSklAnim(al::LiveActor *,char const*);
    void startSklAnimInterpole(al::LiveActor *,char const*,char const*);
    void tryStartSklAnimIfExist(al::LiveActor *,char const*);
    bool isSklAnimExist(al::LiveActor const*,char const*);
    void tryStartSklAnimIfNotPlaying(al::LiveActor *,char const*);
    bool isSklAnimPlaying(al::LiveActor const*,char const*,int);
    void startSklAnimBlend(al::LiveActor *,char const*,char const*,char const*,char const*,char const*,char const*);
    void startSklAnimBlendInterpole(al::LiveActor *,char const*,char const*,char const*,char const*,char const*,char const*,char const*);
    void copySklAnim(al::LiveActor *,al::LiveActor const*);
    bool isExistSklAnimRetargetting(al::LiveActor const*);
    bool isSklAnimRetargettingValid(al::LiveActor const*);
    void validateSklAnimRetargetting(al::LiveActor const*);
    void invalidateSklAnimRetargetting(al::LiveActor const*);
    void clearSklAnimInterpole(al::LiveActor *);
    bool isSklAnimExist(al::LiveActor const*);
    bool isSklAnimEnd(al::LiveActor const*,int);
    bool isSklAnimOneTime(al::LiveActor const*,char const*);
    bool isSklAnimOneTime(al::LiveActor const*,int);
    bool isSklAnimPlaying(al::LiveActor const*,int);
    void getPlayingSklAnimName(al::LiveActor const*,int);
    void getSklAnimFrame(al::LiveActor const*,int);
    void getSklAnimFrameRate(al::LiveActor const*,int);
    void getSklAnimFrameMax(al::LiveActor const*,int);
    void getSklAnimFrameMax(al::LiveActor const*,char const*);
    void setSklAnimFrame(al::LiveActor *,float,int);
    void setSklAnimFrameRate(al::LiveActor *,float,int);
    void setSklAnimFrameAndStop(al::LiveActor *,float,int);
    void getSklAnimBlendNum(al::LiveActor const*);
    void getSklAnimBlendWeight(al::LiveActor const*,int);
    void setSklAnimBlendWeight(al::LiveActor *,float,int);
    void setSklAnimBlendWeightDouble(al::LiveActor *,float);
    void setSklAnimBlendWeightDouble(al::LiveActor *,float,float);
    void setSklAnimBlendWeightTriple(al::LiveActor *,float,float,float);
    void setSklAnimBlendWeightQuad(al::LiveActor *,float,float,float,float);
    void setSklAnimBlendWeightFivefold(al::LiveActor *,float,float,float,float,float);
    void setSklAnimBlendWeightSixfold(al::LiveActor *,float,float,float,float,float,float);
    void setSklAnimBlendFrameAll(al::LiveActor *,float,bool);
    void setSklAnimBlendFrameRateAll(al::LiveActor *,float,bool);
    void startMtpAnim(al::LiveActor *,char const*);
    void startMtpAnimAndSetFrameAndStop(al::LiveActor *,char const*,float);
    void setMtpAnimFrame(al::LiveActor *,float);
    void setMtpAnimFrameRate(al::LiveActor *,float);
    void tryStartMtpAnimIfExist(al::LiveActor *,char const*);
    bool isMtpAnimExist(al::LiveActor const*,char const*);
    void tryStartMtpAnimIfNotPlaying(al::LiveActor *,char const*);
    bool isMtpAnimPlaying(al::LiveActor const*,char const*);
    void clearMtpAnim(al::LiveActor *);
    bool isMtpAnimExist(al::LiveActor const*);
    bool isMtpAnimEnd(al::LiveActor const*);
    bool isMtpAnimOneTime(al::LiveActor const*,char const*);
    bool isMtpAnimOneTime(al::LiveActor const*);
    void getPlayingMtpAnimName(al::LiveActor const*);
    bool isMtpAnimPlaying(al::LiveActor const*);
    void getMtpAnimFrame(al::LiveActor const*);
    void getMtpAnimFrameRate(al::LiveActor const*);
    void getMtpAnimFrameMax(al::LiveActor const*);
    void getMtpAnimFrameMax(al::LiveActor const*,char const*);
    void setMtpAnimFrameAndStop(al::LiveActor *,float);
    void setMtpAnimFrameAndStopEnd(al::LiveActor *);
    void startMclAnim(al::LiveActor *,char const*);
    void tryStartMclAnimIfExist(al::LiveActor *,char const*);
    bool isMclAnimExist(al::LiveActor const*,char const*);
    void tryStartMclAnimIfNotPlaying(al::LiveActor *,char const*);
    bool isMclAnimPlaying(al::LiveActor const*,char const*);
    void clearMclAnim(al::LiveActor *);
    bool isMclAnimExist(al::LiveActor const*);
    bool isMclAnimEnd(al::LiveActor const*);
    bool isMclAnimOneTime(al::LiveActor const*,char const*);
    bool isMclAnimOneTime(al::LiveActor const*);
    void getPlayingMclAnimName(al::LiveActor const*);
    bool isMclAnimPlaying(al::LiveActor const*);
    void getMclAnimFrame(al::LiveActor const*);
    void getMclAnimFrameRate(al::LiveActor const*);
    void getMclAnimFrameMax(al::LiveActor const*);
    void getMclAnimFrameMax(al::LiveActor const*,char const*);
    void setMclAnimFrame(al::LiveActor *,float);
    void setMclAnimFrameRate(al::LiveActor *,float);
    void startMclAnimAndSetFrameAndStop(al::LiveActor *,char const*,float);
    void setMclAnimFrameAndStop(al::LiveActor *,float);
    void setMclAnimNormalFrameAndStop(al::LiveActor *,float);
    void setMclAnimFrameAndStopEnd(al::LiveActor *);
    void startMtsAnim(al::LiveActor *,char const*);
    void startMtsAnimAndSetFrameAndStop(al::LiveActor *,char const*,float);
    void setMtsAnimFrame(al::LiveActor *,float);
    void setMtsAnimFrameRate(al::LiveActor *,float);
    void tryStartMtsAnimIfExist(al::LiveActor *,char const*);
    bool isMtsAnimExist(al::LiveActor const*,char const*);
    void tryStartMtsAnimIfNotPlaying(al::LiveActor *,char const*);
    bool isMtsAnimPlaying(al::LiveActor const*,char const*);
    void clearMtsAnim(al::LiveActor *);
    bool isMtsAnimExist(al::LiveActor const*);
    bool isMtsAnimEnd(al::LiveActor const*);
    bool isMtsAnimOneTime(al::LiveActor const*,char const*);
    bool isMtsAnimOneTime(al::LiveActor const*);
    void getPlayingMtsAnimName(al::LiveActor const*);
    bool isMtsAnimPlaying(al::LiveActor const*);
    void getMtsAnimFrame(al::LiveActor const*);
    void getMtsAnimFrameRate(al::LiveActor const*);
    void getMtsAnimFrameMax(al::LiveActor const*);
    void getMtsAnimFrameMax(al::LiveActor const*,char const*);
    void setMtsAnimFrameAndStop(al::LiveActor *,float);
    void setMtsAnimFrameAndStopEnd(al::LiveActor *);
    void createMatAnimSlotForMcl(al::LiveActor *);
    void createMatAnimSlotForMtp(al::LiveActor *);
    void createMatAnimSlotForMts(al::LiveActor *);
    void startMatAnim(al::LiveActor *,char const*);
    void startMatAnimAndSetFrameAndStop(al::LiveActor *,char const*,float);
    void setMatAnimFrame(al::LiveActor *,float);
    void setMatAnimFrameRate(al::LiveActor *,float);
    void tryStartMatAnimIfExist(al::LiveActor *,char const*);
    bool isMatAnimExist(al::LiveActor const*,char const*);
    void tryStartMatAnimIfNotPlaying(al::LiveActor *,char const*);
    bool isMatAnimPlaying(al::LiveActor const*,char const*);
    void clearMatAnim(al::LiveActor *);
    bool isMatAnimExist(al::LiveActor const*);
    bool isMatAnimEnd(al::LiveActor const*);
    bool isMatAnimOneTime(al::LiveActor const*,char const*);
    bool isMatAnimOneTime(al::LiveActor const*);
    void getPlayingMatAnimName(al::LiveActor const*);
    bool isMatAnimPlaying(al::LiveActor const*);
    void getMatAnimFrame(al::LiveActor const*);
    void getMatAnimFrameRate(al::LiveActor const*);
    void getMatAnimFrameMax(al::LiveActor const*);
    void getMatAnimFrameMax(al::LiveActor const*,char const*);
    void setMatAnimFrameAndStop(al::LiveActor *,float);
    void setMatAnimFrameAndStopEnd(al::LiveActor *);
    void startVisAnim(al::LiveActor *,char const*);
    void tryStartVisAnimIfExist(al::LiveActor *,char const*);
    bool isVisAnimExist(al::LiveActor const*,char const*);
    void tryStartVisAnimIfNotPlaying(al::LiveActor *,char const*);
    bool isVisAnimPlaying(al::LiveActor const*,char const*);
    void clearVisAnim(al::LiveActor *);
    bool isVisAnimExist(al::LiveActor const*);
    bool isVisAnimEnd(al::LiveActor const*);
    bool isVisAnimOneTime(al::LiveActor const*,char const*);
    bool isVisAnimOneTime(al::LiveActor const*);
    void getPlayingVisAnimName(al::LiveActor const*);
    bool isVisAnimPlaying(al::LiveActor const*);
    void getVisAnimFrame(al::LiveActor const*);
    void getVisAnimFrameRate(al::LiveActor const*);
    void getVisAnimFrameMax(al::LiveActor const*);
    void getVisAnimFrameMax(al::LiveActor const*,char const*);
    void setVisAnimFrame(al::LiveActor *,float);
    void setVisAnimFrameRate(al::LiveActor *,float);
    void setVisAnimFrameAndStop(al::LiveActor *,float);
    void setVisAnimFrameAndStopEnd(al::LiveActor *);
    void startVisAnimAndSetFrameAndStop(al::LiveActor *,char const*,float);
    void startVisAnimForAction(al::LiveActor *,char const*);
    void tryStartVisAnimIfExistForAction(al::LiveActor *,char const*);
    void tryStartVisAnimIfNotPlayingForAction(al::LiveActor *,char const*);
    bool isVisAnimPlayingForAction(al::LiveActor const*,char const*);
    void clearVisAnimForAction(al::LiveActor *);
    bool isVisAnimEndForAction(al::LiveActor const*);
    bool isVisAnimOneTimeForAction(al::LiveActor const*,char const*);
    bool isVisAnimOneTimeForAction(al::LiveActor const*);
    void getPlayingVisAnimNameForAction(al::LiveActor const*);
    bool isVisAnimPlayingForAction(al::LiveActor const*);
    void getVisAnimFrameForAction(al::LiveActor const*);
    void getVisAnimFrameRateForAction(al::LiveActor const*);
    void getVisAnimFrameMaxForAction(al::LiveActor const*);
    void setVisAnimFrameForAction(al::LiveActor *,float);
    void setVisAnimFrameRateForAction(al::LiveActor *,float);
    void setVisAnimFrameAndStopForAction(al::LiveActor *,float);
    void setVisAnimFrameAndStopEndForAction(al::LiveActor *);
    void startVisAnimAndSetFrameAndStopForAction(al::LiveActor *,char const*,float);
    void setAllAnimFrame(al::LiveActor *,float);
    void setAllAnimFrameRate(al::LiveActor *,float);
    void initAndBindSklAnimRetargetting(al::LiveActor *,char const*,sead::Vector3<float> const&);
    void createSklAnimRetargetting(al::LiveActor const*,char const*,sead::Vector3<float> const&);
    void bindSklAnimRetargetting(al::LiveActor const*,al::SklAnimRetargettingInfo const*);
    void createSklAnimRetargetting(al::LiveActor const*,al::LiveActor const*,sead::Vector3<float> const&);
    void unbindSklAnimRetargetting(al::LiveActor const*);
    void initPartialSklAnim(al::LiveActor *,int,int,int);
    void getPartialSklAnimSlotNum(al::LiveActor *);
    void addPartialSklAnimPartsList(al::LiveActor *,char const*,char const*,int);
    void addPartialSklAnimPartsListRecursive(al::LiveActor *,char const*,int);
    void calcJoitsAmountFromJoint(al::LiveActor *,char const*);
    void startPartialSklAnim(al::LiveActor *,char const*,int,int,al::SklAnimRetargettingInfo const*);
    void startPartialSklAnimWithInterpolate(al::LiveActor *,char const*,int,int,int,al::SklAnimRetargettingInfo const*);
    void clearPartialSklAnim(al::LiveActor *,int);
    void clearPartialSklAnimWithInterpolate(al::LiveActor *,int,int);
    bool isPartialSklAnimEnd(al::LiveActor const*,int);
    bool isPartialSklAnimOneTime(al::LiveActor const*,int);
    bool isPartialSklAnimAttached(al::LiveActor const*,int);
    bool isPartialSklAnimPlaying(al::LiveActor const*,char const*,int);
    void getPlayingPartialSklAnimName(al::LiveActor const*,int);
    void getPartialSklAnimFrame(al::LiveActor const*,int);
    void setPartialSklAnimFrame(al::LiveActor *,int,float);
    void getPartialSklAnimFrameRate(al::LiveActor const*,int);
    void setPartialSklAnimFrameRate(al::LiveActor *,int,float);
    void setBaseMtxAndCalcAnim(al::LiveActor *,sead::Matrix34f const&,sead::Vector3f const&);
}

namespace alAnimFunction {
    bool isAllAnimEnd(al::LiveActor const*,int);
    void getAllAnimFrame(al::LiveActor const*,int);
    void getAllAnimFrameMax(al::LiveActor const*,char const*,int);
    void getAllAnimFrameRate(al::LiveActor const*,int);
    void getAllAnimName(al::LiveActor const*);
}
