/*
 * Copyright (c) 2020 h1k421
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

// NVN types reconstructed from Darksiders II DWARF information.
// NOTE: This only includes enums and structs used for NVN 53.105 but might contain more elements
// than expected (as Darksiders II uses a newer version of NVN).
// TODO: Include the extra information from the version used on Darksiders II for completeness.

#pragma once

#ifdef __cplusplus
extern "C" {
#endif

#include <stddef.h>
#include <stdint.h>

typedef uint8_t NVNboolean;
typedef uint64_t NVNtextureHandle;
typedef uint64_t NVNimageHandle;
typedef uint64_t NVNcommandHandle;
typedef uint64_t NVNbufferAddress;
typedef uint64_t NVNtextureAddress;
typedef int NVNdebugDomainId;
typedef int NVNstorageClass;
typedef void* NVNsubroutineLinkageMapPtr;
typedef void* NVNnativeWindow;

typedef struct {
    char reserved[0x3000];
} NVNdevice;

typedef struct {
    char reserved[0x40];
} NVNdeviceBuilder;

typedef struct {
    // TODO: reverse and define this as it looks like it's not an opaque type.
    char dummy[1];
} NVNtextureSparseTileLayout;

typedef struct {
    // TODO: reverse and define this as it looks like it's not an opaque type.
    char dummy[1];
} NVNdrawTextureRegion;

typedef struct {
    char reserved[0x18];
} NVNmultisampleState;

typedef struct {
    char reserved[0x8];
} NVNdepthStencilState;

typedef struct {
    char reserved[0x4];
} NVNchannelMaskState;

typedef struct {
    char reserved[0x4];
} NVNpolygonState;

typedef struct {
    NVNbufferAddress address;
    uint64_t size;
} NVNbufferRange;

typedef struct {
    unsigned char reserved[4];
} NVNcolorState;

typedef struct {
    uint64_t counter;
    uint64_t timestamp;
} NVNcounterData;

typedef struct {
    uint64_t value;
} NVNseparateTextureHandle;

typedef struct {
    uint64_t value;
} NVNseparateSamplerHandle;

typedef struct {
    char reserved[0x2000];
} NVNqueue;

typedef struct {
    // TODO: reverse and define this as it looks like it's not an opaque type.
    char dummy[1];
} NVNqueueErrorInfo;

typedef struct {
    char reserved[0x40];
} NVNqueueBuilder;

typedef struct {
    char reserved[384];
} NVNwindow;

typedef struct {
    char reserved[0xC0];
} NVNtexture;

typedef struct {
    char reserved[0x28];
} NVNtextureView;

typedef struct {
    char reserved[0xA0];
} NVNcommandBuffer;

typedef struct {
    char reserved[0x40];
} NVNsync;

typedef struct {
    int x;
    int y;
    int width;
    int height;
} NVNrectangle;

typedef struct {
    char reserved[0xC0];
} NVNprogram;

typedef struct {
    NVNbufferAddress data;
    const void* control;
} NVNshaderData;

typedef struct {
    char reserved[0x100];
} NVNmemoryPool;

typedef struct {
    char reserved[0x20];
} NVNtexturePool;

typedef struct {
    char reserved[0x20];
} NVNsamplerPool;

typedef struct {
    char reserved[0x8];
} NVNblendState;

typedef struct {
    char reserved[0x4];
} NVNvertexAttribState;

typedef struct {
    char reserved[0x8];
} NVNvertexStreamState;

typedef struct {
    char reserved[0x40];
} NVNmemoryPoolBuilder;

typedef struct {
    // TODO: reverse and define this as it looks like it's not an opaque type.
    char dummy[1];
} NVNmappingRequest;

typedef struct {
    char reserved[0x60];
} NVNsamplerBuilder;

typedef struct {
    char reserved[0x30];
} NVNsampler;

typedef struct {
    char reserved[0x40];
} NVNbufferBuilder;

typedef struct {
    char reserved[0x30];
} NVNbuffer;

typedef struct {
    char reserved[0x40];
} NVNevent;

typedef struct {
    char reserved[0x20];
} NVNeventBuilder;

typedef struct {
    int xoffset;
    int yoffset;
    int zoffset;
    int width;
    int height;
    int depth;
} NVNcopyRegion;

typedef struct {
    char reserved[0x40];
} NVNwindowBuilder;

typedef struct {
    char reserved[0x80];
} NVNtextureBuilder;

typedef struct {
    unsigned char layout[8];
} NVNpackagedTextureLayout;

typedef enum {
    NVN_DEVICE_INFO_API_MAJOR_VERSION = 0x0,
    NVN_DEVICE_INFO_API_MINOR_VERSION = 0x1,
    NVN_DEVICE_INFO_UNIFORM_BUFFER_BINDINGS_PER_STAGE = 0x2,
    NVN_DEVICE_INFO_MAX_UNIFORM_BUFFER_SIZE = 0x3,
    NVN_DEVICE_INFO_UNIFORM_BUFFER_ALIGNMENT = 0x4,
    NVN_DEVICE_INFO_COLOR_BUFFER_BINDINGS = 0x5,
    NVN_DEVICE_INFO_VERTEX_BUFFER_BINDINGS = 0x6,
    NVN_DEVICE_INFO_TRANSFORM_FEEDBACK_BUFFER_BINDINGS = 0x7,
    NVN_DEVICE_INFO_SHADER_STORAGE_BUFFER_BINDINGS_PER_STAGE = 0x8,
    NVN_DEVICE_INFO_TEXTURE_BINDINGS_PER_STAGE = 0x9,
    NVN_DEVICE_INFO_COUNTER_ALIGNMENT = 0xA,
    NVN_DEVICE_INFO_TRANSFORM_FEEDBACK_BUFFER_ALIGNMENT = 0xB,
    NVN_DEVICE_INFO_TRANSFORM_FEEDBACK_CONTROL_ALIGNMENT = 0xC,
    NVN_DEVICE_INFO_INDIRECT_DRAW_ALIGNMENT = 0xD,
    NVN_DEVICE_INFO_VERTEX_ATTRIBUTES = 0xE,
    NVN_DEVICE_INFO_TEXTURE_DESCRIPTOR_SIZE = 0xF,
    NVN_DEVICE_INFO_SAMPLER_DESCRIPTOR_SIZE = 0x10,
    NVN_DEVICE_INFO_RESERVED_TEXTURE_DESCRIPTORS = 0x11,
    NVN_DEVICE_INFO_RESERVED_SAMPLER_DESCRIPTORS = 0x12,
    NVN_DEVICE_INFO_COMMAND_BUFFER_COMMAND_ALIGNMENT = 0x13,
    NVN_DEVICE_INFO_COMMAND_BUFFER_CONTROL_ALIGNMENT = 0x14,
    NVN_DEVICE_INFO_COMMAND_BUFFER_MIN_COMMAND_SIZE = 0x15,
    NVN_DEVICE_INFO_COMMAND_BUFFER_MIN_CONTROL_SIZE = 0x16,
    NVN_DEVICE_INFO_SHADER_SCRATCH_MEMORY_SCALE_FACTOR_MINIMUM = 0x17,
    NVN_DEVICE_INFO_SHADER_SCRATCH_MEMORY_SCALE_FACTOR_RECOMMENDED = 0x18,
    NVN_DEVICE_INFO_SHADER_SCRATCH_MEMORY_ALIGNMENT = 0x19,
    NVN_DEVICE_INFO_SHADER_SCRATCH_MEMORY_GRANULARITY = 0x1A,
    NVN_DEVICE_INFO_MAX_TEXTURE_ANISOTROPY = 0x1B,
    NVN_DEVICE_INFO_MAX_COMPUTE_WORK_GROUP_SIZE_X = 0x1C,
    NVN_DEVICE_INFO_MAX_COMPUTE_WORK_GROUP_SIZE_Y = 0x1D,
    NVN_DEVICE_INFO_MAX_COMPUTE_WORK_GROUP_SIZE_Z = 0x1E,
    NVN_DEVICE_INFO_MAX_COMPUTE_WORK_GROUP_SIZE_THREADS = 0x1F,
    NVN_DEVICE_INFO_MAX_COMPUTE_DISPATCH_WORK_GROUPS_X = 0x20,
    NVN_DEVICE_INFO_MAX_COMPUTE_DISPATCH_WORK_GROUPS_Y = 0x21,
    NVN_DEVICE_INFO_MAX_COMPUTE_DISPATCH_WORK_GROUPS_Z = 0x22,
    NVN_DEVICE_INFO_IMAGE_BINDINGS_PER_STAGE = 0x23,
    NVN_DEVICE_INFO_MAX_TEXTURE_POOL_SIZE = 0x24,
    NVN_DEVICE_INFO_MAX_SAMPLER_POOL_SIZE = 0x25,
    NVN_DEVICE_INFO_MAX_VIEWPORTS = 0x26,
    NVN_DEVICE_INFO_MEMPOOL_TEXTURE_OBJECT_PAGE_ALIGNMENT = 0x27,
    NVN_DEVICE_INFO_SUPPORTS_MIN_MAX_FILTERING = 0x28,
    NVN_DEVICE_INFO_SUPPORTS_STENCIL8_FORMAT = 0x29,
    NVN_DEVICE_INFO_SUPPORTS_ASTC_FORMATS = 0x2A,
    NVN_DEVICE_INFO_L2_SIZE = 0x2B,
    NVN_DEVICE_INFO_MAX_TEXTURE_LEVELS = 0x2C,
    NVN_DEVICE_INFO_MAX_TEXTURE_LAYERS = 0x2D,
    NVN_DEVICE_INFO_GLSLC_MAX_SUPPORTED_GPU_CODE_MAJOR_VERSION = 0x2E,
    NVN_DEVICE_INFO_GLSLC_MIN_SUPPORTED_GPU_CODE_MAJOR_VERSION = 0x2F,
    NVN_DEVICE_INFO_GLSLC_MAX_SUPPORTED_GPU_CODE_MINOR_VERSION = 0x30,
    NVN_DEVICE_INFO_GLSLC_MIN_SUPPORTED_GPU_CODE_MINOR_VERSION = 0x31,
    NVN_DEVICE_INFO_SUPPORTS_CONSERVATIVE_RASTER = 0x32,
    NVN_DEVICE_INFO_SUBPIXEL_BITS = 0x33,
    NVN_DEVICE_INFO_MAX_SUBPIXEL_BIAS_BITS = 0x34,
    NVN_DEVICE_INFO_INDIRECT_DISPATCH_ALIGNMENT = 0x35,
    NVN_DEVICE_INFO_ZCULL_SAVE_RESTORE_ALIGNMENT = 0x36,
    NVN_DEVICE_INFO_SHADER_SCRATCH_MEMORY_COMPUTE_SCALE_FACTOR_MINIMUM = 0x37,
    NVN_DEVICE_INFO_LINEAR_TEXTURE_STRIDE_ALIGNMENT = 0x38,
    NVN_DEVICE_INFO_LINEAR_RENDER_TARGET_STRIDE_ALIGNMENT = 0x39,
    NVN_DEVICE_INFO_MEMORY_POOL_PAGE_SIZE = 0x3A,
    NVN_DEVICE_INFO_SUPPORTS_ZERO_FROM_UNMAPPED_VIRTUAL_POOL_PAGES = 0x3B,
    NVN_DEVICE_INFO_UNIFORM_BUFFER_UPDATE_ALIGNMENT = 0x3C,
    NVN_DEVICE_INFO_MAX_TEXTURE_SIZE = 0x3D,
    NVN_DEVICE_INFO_MAX_BUFFER_TEXTURE_SIZE = 0x3E,
    NVN_DEVICE_INFO_MAX_3D_TEXTURE_SIZE = 0x3F,
    NVN_DEVICE_INFO_MAX_CUBE_MAP_TEXTURE_SIZE = 0x40,
    NVN_DEVICE_INFO_MAX_RECTANGLE_TEXTURE_SIZE = 0x41,
    NVN_DEVICE_INFO_SUPPORTS_PASSTHROUGH_GEOMETRY_SHADERS = 0x42,
    NVN_DEVICE_INFO_SUPPORTS_VIEWPORT_SWIZZLE = 0x43,
    NVN_DEVICE_INFO_SUPPORTS_SPARSE_TILED_PACKAGED_TEXTURES = 0x44,
    NVN_DEVICE_INFO_SUPPORTS_ADVANCED_BLEND_MODES = 0x45,
    NVN_DEVICE_INFO_MAX_PRESENT_INTERVAL = 0x46,
    NVN_DEVICE_INFO_SUPPORTS_DRAW_TEXTURE = 0x47,
    NVN_DEVICE_INFO_SUPPORTS_TARGET_INDEPENDENT_RASTERIZATION = 0x48,
    NVN_DEVICE_INFO_SUPPORTS_FRAGMENT_COVERAGE_TO_COLOR = 0x49,
    NVN_DEVICE_INFO_SUPPORTS_POST_DEPTH_COVERAGE = 0x4A,
    NVN_DEVICE_INFO_SUPPORTS_IMAGES_USING_TEXTURE_HANDLES = 0x4B,
    NVN_DEVICE_INFO_SUPPORTS_SAMPLE_LOCATIONS = 0x4C,
    NVN_DEVICE_INFO_MAX_SAMPLE_LOCATION_TABLE_ENTRIES = 0x4D,
    NVN_DEVICE_INFO_SHADER_CODE_MEMORY_POOL_PADDING_SIZE = 0x4E,
    NVN_DEVICE_INFO_MAX_PATCH_SIZE = 0x4F,
    NVN_DEVICE_INFO_QUEUE_COMMAND_MEMORY_GRANULARITY = 0x50,
    NVN_DEVICE_INFO_QUEUE_COMMAND_MEMORY_MIN_SIZE = 0x51,
    NVN_DEVICE_INFO_QUEUE_COMMAND_MEMORY_DEFAULT_SIZE = 0x52,
    NVN_DEVICE_INFO_QUEUE_COMPUTE_MEMORY_GRANULARITY = 0x53,
    NVN_DEVICE_INFO_QUEUE_COMPUTE_MEMORY_MIN_SIZE = 0x54,
    NVN_DEVICE_INFO_QUEUE_COMPUTE_MEMORY_DEFAULT_SIZE = 0x55,
    NVN_DEVICE_INFO_QUEUE_COMMAND_MEMORY_MIN_FLUSH_THRESHOLD = 0x56,
    NVN_DEVICE_INFO_SUPPORTS_FRAGMENT_SHADER_INTERLOCK = 0x57,
    NVN_DEVICE_INFO_MAX_TEXTURES_PER_WINDOW = 0x58,
    NVN_DEVICE_INFO_MIN_TEXTURES_PER_WINDOW = 0x59,
    NVN_DEVICE_INFO_SUPPORTS_DEBUG_LAYER = 0x5A,
    NVN_DEVICE_INFO_QUEUE_CONTROL_MEMORY_MIN_SIZE = 0x5B,
    NVN_DEVICE_INFO_QUEUE_CONTROL_MEMORY_DEFAULT_SIZE = 0x5C,
    NVN_DEVICE_INFO_QUEUE_CONTROL_MEMORY_GRANULARITY = 0x5D,
    NVN_DEVICE_INFO_SEPARATE_TEXTURE_BINDINGS_PER_STAGE = 0x5E,
    NVN_DEVICE_INFO_SEPARATE_SAMPLER_BINDINGS_PER_STAGE = 0x5F,
    NVN_DEVICE_INFO_DEBUG_GROUPS_MAX_DOMAIN_ID = 0x60,
    NVN_DEVICE_INFO_EVENTS_SUPPORT_REDUCTION_OPERATIONS = 0x61,

    NVN_DEVICE_INFO_LARGE = 0x7FFFFFFF
} NVNdeviceInfo;

typedef enum {
    NVN_DEVICE_FLAG_DEBUG_ENABLE = 0x1,
    NVN_DEVICE_FLAG_DEBUG_SKIP_CALLS_ON_ERROR = 0x2,
    NVN_DEVICE_FLAG_DEBUG_DRAW_VALIDATION = 0x4,
    NVN_DEVICE_FLAG_DEFERRED_FINALIZE = 0x8,
    NVN_DEVICE_FLAG_DEBUG_DRAW_VALIDATION_HEAVY = 0x10,
    NVN_DEVICE_FLAG_DEBUG_ENABLE_LEVEL_0 = 0x20,
    NVN_DEVICE_FLAG_DEBUG_ENABLE_LEVEL_1 = 0x40,
    NVN_DEVICE_FLAG_DEBUG_ENABLE_LEVEL_2 = 0x1,
    NVN_DEVICE_FLAG_DEBUG_ENABLE_LEVEL_3 = 0x4,
    NVN_DEVICE_FLAG_DEBUG_ENABLE_LEVEL_4 = 0x10,
    NVN_DEVICE_FLAG_DEFERRED_FIRMWARE_MEMORY_RECLAIM = 0x80,
    NVN_DEVICE_FLAG_ENABLE_SEPARATE_SAMPLER_TEXTURE_SUPPORT = 0x100,

    NVN_DEVICE_FLAG_LARGE = 0x7FFFFFFF
} NVNdeviceFlagBits;

enum NVNclearColorMask {
    NVN_CLEAR_COLOR_MASK_R_BIT = 0x1,
    NVN_CLEAR_COLOR_MASK_G_BIT = 0x2,
    NVN_CLEAR_COLOR_MASK_B_BIT = 0x4,
    NVN_CLEAR_COLOR_MASK_A_BIT = 0x8,
    NVN_CLEAR_COLOR_MASK_RGBA = 0xF,
    NVN_CLEAR_COLOR_MASK_LARGE = 0x7FFFFFFF
};

typedef enum {
    NVN_DEBUG_CALLBACK_SOURCE_API = 0x0,

    NVN_DEBUG_CALLBACK_SOURCE_LARGE = 0x7FFFFFFF
} NVNdebugCallbackSource;

typedef enum {
    NVN_DEBUG_CALLBACK_TYPE_API_ERROR = 0x0,
    NVN_DEBUG_CALLBACK_TYPE_API_WARNING = 0x1,

    NVN_DEBUG_CALLBACK_TYPE_LARGE = 0x7FFFFFFF
} NVNdebugCallbackType;

typedef enum {
    NVN_DEBUG_CALLBACK_SEVERITY_HIGH = 0x0,
    NVN_DEBUG_CALLBACK_SEVERITY_MEDIUM = 0x1,
    NVN_DEBUG_CALLBACK_SEVERITY_LOW = 0x2,
    NVN_DEBUG_CALLBACK_SEVERITY_NOTIFICATION = 0x3,

    NVN_DEBUG_CALLBACK_SEVERITY_LARGE = 0x7FFFFFFF
} NVNdebugCallbackSeverity;

typedef enum {
    NVN_WINDOW_ORIGIN_MODE_LOWER_LEFT = 0x0,
    NVN_WINDOW_ORIGIN_MODE_UPPER_LEFT = 0x1,

    NVN_WINDOW_ORIGIN_MODE_LARGE = 0x7FFFFFFF
} NVNwindowOriginMode;

typedef enum {
    NVN_DEPTH_MODE_NEAR_IS_MINUS_W = 0x0,
    NVN_DEPTH_MODE_NEAR_IS_ZERO = 0x1,

    NVN_DEPTH_MODE_LARGE = 0x7FFFFFFF
} NVNdepthMode;

typedef enum {
    NVN_FORMAT_NONE = 0x0,
    NVN_FORMAT_R8 = 0x1,
    NVN_FORMAT_R8SN = 0x2,
    NVN_FORMAT_R8UI = 0x3,
    NVN_FORMAT_R8I = 0x4,
    NVN_FORMAT_R16F = 0x5,
    NVN_FORMAT_R16 = 0x6,
    NVN_FORMAT_R16SN = 0x7,
    NVN_FORMAT_R16UI = 0x8,
    NVN_FORMAT_R16I = 0x9,
    NVN_FORMAT_R32F = 0xA,
    NVN_FORMAT_R32UI = 0xB,
    NVN_FORMAT_R32I = 0xC,
    NVN_FORMAT_RG8 = 0xD,
    NVN_FORMAT_RG8SN = 0xE,
    NVN_FORMAT_RG8UI = 0xF,
    NVN_FORMAT_RG8I = 0x10,
    NVN_FORMAT_RG16F = 0x11,
    NVN_FORMAT_RG16 = 0x12,
    NVN_FORMAT_RG16SN = 0x13,
    NVN_FORMAT_RG16UI = 0x14,
    NVN_FORMAT_RG16I = 0x15,
    NVN_FORMAT_RG32F = 0x16,
    NVN_FORMAT_RG32UI = 0x17,
    NVN_FORMAT_RG32I = 0x18,
    NVN_FORMAT_RGB8 = 0x19,
    NVN_FORMAT_RGB8SN = 0x1A,
    NVN_FORMAT_RGB8UI = 0x1B,
    NVN_FORMAT_RGB8I = 0x1C,
    NVN_FORMAT_RGB16F = 0x1D,
    NVN_FORMAT_RGB16 = 0x1E,
    NVN_FORMAT_RGB16SN = 0x1F,
    NVN_FORMAT_RGB16UI = 0x20,
    NVN_FORMAT_RGB16I = 0x21,
    NVN_FORMAT_RGB32F = 0x22,
    NVN_FORMAT_RGB32UI = 0x23,
    NVN_FORMAT_RGB32I = 0x24,
    NVN_FORMAT_RGBA8 = 0x25,
    NVN_FORMAT_RGBA8SN = 0x26,
    NVN_FORMAT_RGBA8UI = 0x27,
    NVN_FORMAT_RGBA8I = 0x28,
    NVN_FORMAT_RGBA16F = 0x29,
    NVN_FORMAT_RGBA16 = 0x2A,
    NVN_FORMAT_RGBA16SN = 0x2B,
    NVN_FORMAT_RGBA16UI = 0x2C,
    NVN_FORMAT_RGBA16I = 0x2D,
    NVN_FORMAT_RGBA32F = 0x2E,
    NVN_FORMAT_RGBA32UI = 0x2F,
    NVN_FORMAT_RGBA32I = 0x30,
    NVN_FORMAT_STENCIL8 = 0x31,
    NVN_FORMAT_DEPTH16 = 0x32,
    NVN_FORMAT_DEPTH24 = 0x33,
    NVN_FORMAT_DEPTH32F = 0x34,
    NVN_FORMAT_DEPTH24_STENCIL8 = 0x35,
    NVN_FORMAT_DEPTH32F_STENCIL8 = 0x36,
    NVN_FORMAT_RGBX8_SRGB = 0x37,
    NVN_FORMAT_RGBA8_SRGB = 0x38,
    NVN_FORMAT_RGBA4 = 0x39,
    NVN_FORMAT_RGB5 = 0x3A,
    NVN_FORMAT_RGB5A1 = 0x3B,
    NVN_FORMAT_RGB565 = 0x3C,
    NVN_FORMAT_RGB10A2 = 0x3D,
    NVN_FORMAT_RGB10A2UI = 0x3E,
    NVN_FORMAT_R11G11B10F = 0x3F,
    NVN_FORMAT_RGB9E5F = 0x40,
    NVN_FORMAT_RGB_DXT1 = 0x41,
    NVN_FORMAT_RGBA_DXT1 = 0x42,
    NVN_FORMAT_RGBA_DXT3 = 0x43,
    NVN_FORMAT_RGBA_DXT5 = 0x44,
    NVN_FORMAT_RGB_DXT1_SRGB = 0x45,
    NVN_FORMAT_RGBA_DXT1_SRGB = 0x46,
    NVN_FORMAT_RGBA_DXT3_SRGB = 0x47,
    NVN_FORMAT_RGBA_DXT5_SRGB = 0x48,
    NVN_FORMAT_RGTC1_UNORM = 0x49,
    NVN_FORMAT_RGTC1_SNORM = 0x4A,
    NVN_FORMAT_RGTC2_UNORM = 0x4B,
    NVN_FORMAT_RGTC2_SNORM = 0x4C,
    NVN_FORMAT_BPTC_UNORM = 0x4D,
    NVN_FORMAT_BPTC_UNORM_SRGB = 0x4E,
    NVN_FORMAT_BPTC_SFLOAT = 0x4F,
    NVN_FORMAT_BPTC_UFLOAT = 0x50,
    NVN_FORMAT_R8_UI2F = 0x51,
    NVN_FORMAT_R8_I2F = 0x52,
    NVN_FORMAT_R16_UI2F = 0x53,
    NVN_FORMAT_R16_I2F = 0x54,
    NVN_FORMAT_R32_UI2F = 0x55,
    NVN_FORMAT_R32_I2F = 0x56,
    NVN_FORMAT_RG8_UI2F = 0x57,
    NVN_FORMAT_RG8_I2F = 0x58,
    NVN_FORMAT_RG16_UI2F = 0x59,
    NVN_FORMAT_RG16_I2F = 0x5A,
    NVN_FORMAT_RG32_UI2F = 0x5B,
    NVN_FORMAT_RG32_I2F = 0x5C,
    NVN_FORMAT_RGB8_UI2F = 0x5D,
    NVN_FORMAT_RGB8_I2F = 0x5E,
    NVN_FORMAT_RGB16_UI2F = 0x5F,
    NVN_FORMAT_RGB16_I2F = 0x60,
    NVN_FORMAT_RGB32_UI2F = 0x61,
    NVN_FORMAT_RGB32_I2F = 0x62,
    NVN_FORMAT_RGBA8_UI2F = 0x63,
    NVN_FORMAT_RGBA8_I2F = 0x64,
    NVN_FORMAT_RGBA16_UI2F = 0x65,
    NVN_FORMAT_RGBA16_I2F = 0x66,
    NVN_FORMAT_RGBA32_UI2F = 0x67,
    NVN_FORMAT_RGBA32_I2F = 0x68,
    NVN_FORMAT_RGB10A2SN = 0x69,
    NVN_FORMAT_RGB10A2I = 0x6A,
    NVN_FORMAT_RGB10A2_UI2F = 0x6B,
    NVN_FORMAT_RGB10A2_I2F = 0x6C,
    NVN_FORMAT_RGBX8 = 0x6D,
    NVN_FORMAT_RGBX8SN = 0x6E,
    NVN_FORMAT_RGBX8UI = 0x6F,
    NVN_FORMAT_RGBX8I = 0x70,
    NVN_FORMAT_RGBX16F = 0x71,
    NVN_FORMAT_RGBX16 = 0x72,
    NVN_FORMAT_RGBX16SN = 0x73,
    NVN_FORMAT_RGBX16UI = 0x74,
    NVN_FORMAT_RGBX16I = 0x75,
    NVN_FORMAT_RGBX32F = 0x76,
    NVN_FORMAT_RGBX32UI = 0x77,
    NVN_FORMAT_RGBX32I = 0x78,
    NVN_FORMAT_RGBA_ASTC_4x4 = 0x79,
    NVN_FORMAT_RGBA_ASTC_5x4 = 0x7A,
    NVN_FORMAT_RGBA_ASTC_5x5 = 0x7B,
    NVN_FORMAT_RGBA_ASTC_6x5 = 0x7C,
    NVN_FORMAT_RGBA_ASTC_6x6 = 0x7D,
    NVN_FORMAT_RGBA_ASTC_8x5 = 0x7E,
    NVN_FORMAT_RGBA_ASTC_8x6 = 0x7F,
    NVN_FORMAT_RGBA_ASTC_8x8 = 0x80,
    NVN_FORMAT_RGBA_ASTC_10x5 = 0x81,
    NVN_FORMAT_RGBA_ASTC_10x6 = 0x82,
    NVN_FORMAT_RGBA_ASTC_10x8 = 0x83,
    NVN_FORMAT_RGBA_ASTC_10x10 = 0x84,
    NVN_FORMAT_RGBA_ASTC_12x10 = 0x85,
    NVN_FORMAT_RGBA_ASTC_12x12 = 0x86,
    NVN_FORMAT_RGBA_ASTC_4x4_SRGB = 0x87,
    NVN_FORMAT_RGBA_ASTC_5x4_SRGB = 0x88,
    NVN_FORMAT_RGBA_ASTC_5x5_SRGB = 0x89,
    NVN_FORMAT_RGBA_ASTC_6x5_SRGB = 0x8A,
    NVN_FORMAT_RGBA_ASTC_6x6_SRGB = 0x8B,
    NVN_FORMAT_RGBA_ASTC_8x5_SRGB = 0x8C,
    NVN_FORMAT_RGBA_ASTC_8x6_SRGB = 0x8D,
    NVN_FORMAT_RGBA_ASTC_8x8_SRGB = 0x8E,
    NVN_FORMAT_RGBA_ASTC_10x5_SRGB = 0x8F,
    NVN_FORMAT_RGBA_ASTC_10x6_SRGB = 0x90,
    NVN_FORMAT_RGBA_ASTC_10x8_SRGB = 0x91,
    NVN_FORMAT_RGBA_ASTC_10x10_SRGB = 0x92,
    NVN_FORMAT_RGBA_ASTC_12x10_SRGB = 0x93,
    NVN_FORMAT_RGBA_ASTC_12x12_SRGB = 0x94,
    NVN_FORMAT_BGR565 = 0x95,
    NVN_FORMAT_BGR5 = 0x96,
    NVN_FORMAT_BGR5A1 = 0x97,
    NVN_FORMAT_A1BGR5 = 0x98,
    NVN_FORMAT_BGRX8 = 0x99,
    NVN_FORMAT_BGRA8 = 0x9A,
    NVN_FORMAT_BGRX8_SRGB = 0x9B,
    NVN_FORMAT_BGRA8_SRGB = 0x9C,

    NVN_FORMAT_LARGE = 0x7FFFFFFF
} NVNformat;

typedef enum {
    NVN_DEBUG_OBJECT_TYPE_WINDOW = 0x0,
    NVN_DEBUG_OBJECT_TYPE_QUEUE = 0x1,
    NVN_DEBUG_OBJECT_TYPE_COMMAND_BUFFER = 0x2,
    NVN_DEBUG_OBJECT_TYPE_MEMORY_POOL = 0x3,
    NVN_DEBUG_OBJECT_TYPE_SYNC = 0x7,
    NVN_DEBUG_OBJECT_TYPE_PROGRAM = 0x9,
    NVN_DEBUG_OBJECT_TYPE_TEXTURE_POOL = 0xA,
    NVN_DEBUG_OBJECT_TYPE_SAMPLER_POOL = 0xB,

    NVN_DEBUG_OBJECT_TYPE_LARGE = 0x7FFFFFFF
} NVNdebugObjectType;

typedef enum {
    NVN_QUEUE_GET_ERROR_RESULT_GPU_NO_ERROR = 0x0,
    NVN_QUEUE_GET_ERROR_RESULT_GPU_ERROR_UNKNOWN = 0x1,
    NVN_QUEUE_GET_ERROR_RESULT_GPU_ERROR_MMU_FAULT = 0x2,
    NVN_QUEUE_GET_ERROR_RESULT_GPU_ERROR_PBDMA_EXCEPTION = 0x3,
    NVN_QUEUE_GET_ERROR_RESULT_GPU_ERROR_ENGINE_EXCEPTION = 0x4,
    NVN_QUEUE_GET_ERROR_RESULT_GPU_ERROR_TIMEOUT = 0x5,

    NVN_QUEUE_GET_ERROR_RESULT_LARGE = 0x7FFFFFFF
} NVNqueueGetErrorResult;

typedef enum {
    NVN_QUEUE_BUILDER_FLAGS_NONE = 0x0,
    NVN_QUEUE_BUILDER_FLAGS_NO_FRAGMENT_INTERLOCK = 0x1,
    NVN_QUEUE_BUILDER_FLAGS_NO_ZCULL = 0x2,

    NVN_QUEUE_BUILDER_FLAGS_LARGE = 0x7FFFFFFF
} NVNqueueBuilderFlags;

typedef enum {
    NVN_QUEUE_ACQUIRE_TEXTURE_RESULT_SUCCESS = 0x0,
    NVN_QUEUE_ACQUIRE_TEXTURE_RESULT_NATIVE_ERROR = 0x1,

    NVN_QUEUE_ACQUIRE_TEXTURE_RESULT_LARGE = 0x7FFFFFFF
} NVNqueueAcquireTextureResult;

typedef enum {
    NVN_WINDOW_ACQUIRE_TEXTURE_RESULT_SUCCESS = 0x0,
    NVN_WINDOW_ACQUIRE_TEXTURE_RESULT_NATIVE_ERROR = 0x1,

    NVN_WINDOW_ACQUIRE_TEXTURE_RESULT_LARGE = 0x7FFFFFFF
} NVNwindowAcquireTextureResult;

typedef enum {
    NVN_MEMORY_POOL_FLAGS_CPU_NO_ACCESS = 0x1,
    NVN_MEMORY_POOL_FLAGS_CPU_UNCACHED = 0x2,
    NVN_MEMORY_POOL_FLAGS_CPU_CACHED = 0x4,
    NVN_MEMORY_POOL_FLAGS_GPU_NO_ACCESS = 0x8,
    NVN_MEMORY_POOL_FLAGS_GPU_UNCACHED = 0x10,
    NVN_MEMORY_POOL_FLAGS_GPU_CACHED = 0x20,
    NVN_MEMORY_POOL_FLAGS_SHADER_CODE = 0x40,
    NVN_MEMORY_POOL_FLAGS_COMPRESSIBLE = 0x80,
    NVN_MEMORY_POOL_FLAGS_PHYSICAL = 0x100,
    NVN_MEMORY_POOL_FLAGS_VIRTUAL = 0x200,

    NVN_MEMORY_POOL_FLAGS_LARGE = 0x7FFFFFFF
} NVNmemoryPoolFlags;

typedef enum {
    NVN_TEXTURE_SWIZZLE_ZERO = 0x0,
    NVN_TEXTURE_SWIZZLE_ONE = 0x1,
    NVN_TEXTURE_SWIZZLE_R = 0x2,
    NVN_TEXTURE_SWIZZLE_G = 0x3,
    NVN_TEXTURE_SWIZZLE_B = 0x4,
    NVN_TEXTURE_SWIZZLE_A = 0x5,

    NVN_TEXTURE_SWIZZLE_LARGE = 0x7FFFFFFF
} NVNtextureSwizzle;

typedef enum {
    NVN_SHADER_STAGE_VERTEX = 0x0,
    NVN_SHADER_STAGE_FRAGMENT = 0x1,
    NVN_SHADER_STAGE_GEOMETRY = 0x2,
    NVN_SHADER_STAGE_TESS_CONTROL = 0x3,
    NVN_SHADER_STAGE_TESS_EVALUATION = 0x4,
    NVN_SHADER_STAGE_COMPUTE = 0x5,

    NVN_SHADER_STAGE_LARGE = 0x7FFFFFFF
} NVNshaderStage;

typedef enum {
    NVN_SHADER_STAGE_VERTEX_BIT = 0x1,
    NVN_SHADER_STAGE_FRAGMENT_BIT = 0x2,
    NVN_SHADER_STAGE_GEOMETRY_BIT = 0x4,
    NVN_SHADER_STAGE_TESS_CONTROL_BIT = 0x8,
    NVN_SHADER_STAGE_TESS_EVALUATION_BIT = 0x10,
    NVN_SHADER_STAGE_COMPUTE_BIT = 0x20,
    NVN_SHADER_STAGE_ALL_GRAPHICS_BITS = 31,

    NVN_SHADER_STAGE_BITS_LARGE = 0x7FFFFFFF
} NVNshaderStageBits;

typedef enum {
    NVN_EVENT_WAIT_MODE_EQUAL = 0x0,
    NVN_EVENT_WAIT_MODE_GEQUAL_WRAP = 0x1,

    NVN_EVENT_WAIT_MODE_LARGE = 0x7FFFFFFF
} NVNeventWaitMode;

typedef enum {
    NVN_EVENT_SIGNAL_MODE_WRITE = 0x0,
    NVN_EVENT_SIGNAL_MODE_ADD = 0x1,

    NVN_EVENT_SIGNAL_MODE_LARGE = 0x7FFFFFFF
} NVNeventSignalMode;

typedef enum {
    NVN_EVENT_SIGNAL_LOCATION_TOP = 0x0,
    NVN_EVENT_SIGNAL_LOCATION_VERTEX_PIPE = 0x1,
    NVN_EVENT_SIGNAL_LOCATION_BOTTOM = 0x2,

    NVN_EVENT_SIGNAL_LOCATION_LARGE = 0x7FFFFFFF
} NVNeventSignalLocation;

typedef enum {
    NVN_SYNC_CONDITION_ALL_GPU_COMMANDS_COMPLETE = 0x0,
    NVN_SYNC_CONDITION_GRAPHICS_WORLD_SPACE_COMPLETE = 0x1,

    NVN_SYNC_CONDITION_LARGE = 0x7FFFFFFF
} NVNsyncCondition;

typedef enum {
    NVN_COUNTER_TYPE_TIMESTAMP = 0x0,
    NVN_COUNTER_TYPE_SAMPLES_PASSED = 0x1,
    NVN_COUNTER_TYPE_INPUT_VERTICES = 0x2,
    NVN_COUNTER_TYPE_INPUT_PRIMITIVES = 0x3,
    NVN_COUNTER_TYPE_VERTEX_SHADER_INVOCATIONS = 0x4,
    NVN_COUNTER_TYPE_TESS_CONTROL_SHADER_INVOCATIONS = 0x5,
    NVN_COUNTER_TYPE_TESS_EVALUATION_SHADER_INVOCATIONS = 0x6,
    NVN_COUNTER_TYPE_GEOMETRY_SHADER_INVOCATIONS = 0x7,
    NVN_COUNTER_TYPE_FRAGMENT_SHADER_INVOCATIONS = 0x8,
    NVN_COUNTER_TYPE_TESS_EVALUATION_SHADER_PRIMITIVES = 0x9,
    NVN_COUNTER_TYPE_GEOMETRY_SHADER_PRIMITIVES = 0xA,
    NVN_COUNTER_TYPE_CLIPPER_INPUT_PRIMITIVES = 0xB,
    NVN_COUNTER_TYPE_CLIPPER_OUTPUT_PRIMITIVES = 0xC,
    NVN_COUNTER_TYPE_PRIMITIVES_GENERATED = 0xD,
    NVN_COUNTER_TYPE_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN = 0xE,
    NVN_COUNTER_TYPE_ZCULL_STATS = 0xF,
    NVN_COUNTER_TYPE_TIMESTAMP_TOP = 0x10,

    NVN_COUNTER_TYPE_LARGE = 0x7FFFFFFF
} NVNcounterType;

typedef enum {
    NVN_FACE_NONE = 0x0,
    NVN_FACE_FRONT = 0x1,
    NVN_FACE_BACK = 0x2,
    NVN_FACE_FRONT_AND_BACK = 0x3,

    NVN_FACE_LARGE = 0x7FFFFFFF
} NVNface;

typedef enum {
    NVN_COMMAND_BUFFER_MEMORY_EVENT_OUT_OF_COMMAND_MEMORY = 0x0,
    NVN_COMMAND_BUFFER_MEMORY_EVENT_OUT_OF_CONTROL_MEMORY = 0x1,

    NVN_COMMAND_BUFFER_MEMORY_EVENT_LARGE = 0x7FFFFFFF
} NVNcommandBufferMemoryEvent;

typedef enum {
    NVN_DRAW_PRIMITIVE_POINTS = 0x0,
    NVN_DRAW_PRIMITIVE_LINES = 0x1,
    NVN_DRAW_PRIMITIVE_LINE_LOOP = 0x2,
    NVN_DRAW_PRIMITIVE_LINE_STRIP = 0x3,
    NVN_DRAW_PRIMITIVE_TRIANGLES = 0x4,
    NVN_DRAW_PRIMITIVE_TRIANGLE_STRIP = 0x5,
    NVN_DRAW_PRIMITIVE_TRIANGLE_FAN = 0x6,
    NVN_DRAW_PRIMITIVE_QUADS = 0x7,
    NVN_DRAW_PRIMITIVE_QUAD_STRIP = 0x8,
    NVN_DRAW_PRIMITIVE_POLYGON = 0x9,
    NVN_DRAW_PRIMITIVE_LINES_ADJACENCY = 0xA,
    NVN_DRAW_PRIMITIVE_LINE_STRIP_ADJACENCY = 0xB,
    NVN_DRAW_PRIMITIVE_TRIANGLES_ADJACENCY = 0xC,
    NVN_DRAW_PRIMITIVE_TRIANGLE_STRIP_ADJACENCY = 0xD,
    NVN_DRAW_PRIMITIVE_PATCHES = 0xE,

    NVN_DRAW_PRIMITIVE_LARGE = 0x7FFFFFFF
} NVNdrawPrimitive;

typedef enum {
    NVN_INDEX_TYPE_UNSIGNED_BYTE = 0x0,
    NVN_INDEX_TYPE_UNSIGNED_SHORT = 0x1,
    NVN_INDEX_TYPE_UNSIGNED_INT = 0x2,

    NVN_INDEX_TYPE_LARGE = 0x7FFFFFFF
} NVNindexType;

typedef enum {
    NVN_TEXTURE_FLAGS_DISPLAY = 0x1,
    NVN_TEXTURE_FLAGS_VIDEO_DECODE = 0x2,
    NVN_TEXTURE_FLAGS_IMAGE = 0x4,
    NVN_TEXTURE_FLAGS_COMPRESSIBLE = 0x8,
    NVN_TEXTURE_FLAGS_LINEAR = 0x10,
    NVN_TEXTURE_FLAGS_SPARSE = 0x20,
    NVN_TEXTURE_FLAGS_LINEAR_RENDER_TARGET = 0x40,
    NVN_TEXTURE_FLAGS_ADAPTIVE_ZCULL = 0x80,
    NVN_TEXTURE_FLAGS_DEPTH16_PREFER_FAST_CLEAR = 0x100,
    NVN_TEXTURE_FLAGS_MINIMAL_LAYOUT = 0x200,
    NVN_TEXTURE_FLAGS_ZCULL_SUPPORT_STENCIL = 0x400,

    NVN_TEXTURE_FLAGS_LARGE = 0x7FFFFFFF
} NVNtextureFlags;

typedef enum {
    NVN_BARRIER_ORDER_PRIMITIVES_BIT = 0x1,
    NVN_BARRIER_ORDER_FRAGMENTS_BIT = 0x2,
    NVN_BARRIER_ORDER_FRAGMENTS_TILED_BIT = 0x4,
    NVN_BARRIER_ORDER_INDIRECT_DATA_BIT = 0x8,
    NVN_BARRIER_INVALIDATE_TEXTURE_BIT = 0x10,
    NVN_BARRIER_INVALIDATE_SHADER_BIT = 0x20,
    NVN_BARRIER_INVALIDATE_TEXTURE_DESCRIPTOR_BIT = 0x40,
    NVN_BARRIER_INVALIDATE_ZCULL_BIT = 0x80,
    NVN_BARRIER_BITS_LARGE = 0x7FFFFFFF
} NVNbarrierBits;

typedef enum {
    NVN_TEXTURE_TARGET_1D = 0x0,
    NVN_TEXTURE_TARGET_2D = 0x1,
    NVN_TEXTURE_TARGET_3D = 0x2,
    NVN_TEXTURE_TARGET_1D_ARRAY = 0x3,
    NVN_TEXTURE_TARGET_2D_ARRAY = 0x4,
    NVN_TEXTURE_TARGET_2D_MULTISAMPLE = 0x5,
    NVN_TEXTURE_TARGET_2D_MULTISAMPLE_ARRAY = 0x6,
    NVN_TEXTURE_TARGET_RECTANGLE = 0x7,
    NVN_TEXTURE_TARGET_CUBEMAP = 0x8,
    NVN_TEXTURE_TARGET_CUBEMAP_ARRAY = 0x9,
    NVN_TEXTURE_TARGET_BUFFER = 0xA,

    NVN_TEXTURE_TARGET_LARGE = 0x7FFFFFFF
} NVNtextureTarget;

typedef enum {
    NVN_TEXTURE_DEPTH_STENCIL_MODE_DEPTH = 0x0,
    NVN_TEXTURE_DEPTH_STENCIL_MODE_STENCIL = 0x1,

    NVN_TEXTURE_DEPTH_STENCIL_MODE_LARGE = 0x7FFFFFFF
} NVNtextureDepthStencilMode;

typedef enum {
    NVN_LOGIC_OP_CLEAR = 0x0,
    NVN_LOGIC_OP_AND = 0x1,
    NVN_LOGIC_OP_AND_REVERSE = 0x2,
    NVN_LOGIC_OP_COPY = 0x3,
    NVN_LOGIC_OP_AND_INVERTED = 0x4,
    NVN_LOGIC_OP_NOOP = 0x5,
    NVN_LOGIC_OP_XOR = 0x6,
    NVN_LOGIC_OP_OR = 0x7,
    NVN_LOGIC_OP_NOR = 0x8,
    NVN_LOGIC_OP_EQUIV = 0x9,
    NVN_LOGIC_OP_INVERT = 0xA,
    NVN_LOGIC_OP_OR_REVERSE = 0xB,
    NVN_LOGIC_OP_COPY_INVERTED = 0xC,
    NVN_LOGIC_OP_OR_INVERTED = 0xD,
    NVN_LOGIC_OP_NAND = 0xE,
    NVN_LOGIC_OP_SET = 0xF,

    NVN_LOGIC_OP_LARGE = 0x7FFFFFFF
} NVNlogicOp;

typedef enum {
    NVN_ALPHA_FUNC_NEVER = 0x1,
    NVN_ALPHA_FUNC_LESS = 0x2,
    NVN_ALPHA_FUNC_EQUAL = 0x3,
    NVN_ALPHA_FUNC_LEQUAL = 0x4,
    NVN_ALPHA_FUNC_GREATER = 0x5,
    NVN_ALPHA_FUNC_NOTEQUAL = 0x6,
    NVN_ALPHA_FUNC_GEQUAL = 0x7,
    NVN_ALPHA_FUNC_ALWAYS = 0x8,

    NVN_ALPHA_FUNC_LARGE = 0x7FFFFFFF
} NVNalphaFunc;

typedef enum {
    NVN_BLEND_ADVANCED_MODE_NONE = 0x0,
    NVN_BLEND_ADVANCED_MODE_ZERO = 0x5,
    NVN_BLEND_ADVANCED_MODE_SRC = 0x6,
    NVN_BLEND_ADVANCED_MODE_DST = 0x7,
    NVN_BLEND_ADVANCED_MODE_SRC_OVER = 0x8,
    NVN_BLEND_ADVANCED_MODE_DST_OVER = 0x9,
    NVN_BLEND_ADVANCED_MODE_SRC_IN = 0xA,
    NVN_BLEND_ADVANCED_MODE_DST_IN = 0xB,
    NVN_BLEND_ADVANCED_MODE_SRC_OUT = 0xC,
    NVN_BLEND_ADVANCED_MODE_DST_OUT = 0xD,
    NVN_BLEND_ADVANCED_MODE_SRC_ATOP = 0xE,
    NVN_BLEND_ADVANCED_MODE_DST_ATOP = 0xF,
    NVN_BLEND_ADVANCED_MODE_XOR = 0x10,
    NVN_BLEND_ADVANCED_MODE_PLUS = 0x11,
    NVN_BLEND_ADVANCED_MODE_PLUS_CLAMPED = 0x12,
    NVN_BLEND_ADVANCED_MODE_PLUS_CLAMPED_ALPHA = 0x13,
    NVN_BLEND_ADVANCED_MODE_PLUS_DARKER = 0x14,
    NVN_BLEND_ADVANCED_MODE_MULTIPLY = 0x15,
    NVN_BLEND_ADVANCED_MODE_SCREEN = 0x16,
    NVN_BLEND_ADVANCED_MODE_OVERLAY = 0x17,
    NVN_BLEND_ADVANCED_MODE_DARKEN = 0x18,
    NVN_BLEND_ADVANCED_MODE_LIGHTEN = 0x19,
    NVN_BLEND_ADVANCED_MODE_COLORDODGE = 0x1A,
    NVN_BLEND_ADVANCED_MODE_COLORBURN = 0x1B,
    NVN_BLEND_ADVANCED_MODE_HARDLIGHT = 0x1C,
    NVN_BLEND_ADVANCED_MODE_SOFTLIGHT = 0x1D,
    NVN_BLEND_ADVANCED_MODE_DIFFERENCE = 0x1E,
    NVN_BLEND_ADVANCED_MODE_MINUS = 0x1F,
    NVN_BLEND_ADVANCED_MODE_MINUS_CLAMPED = 0x20,
    NVN_BLEND_ADVANCED_MODE_EXCLUSION = 0x21,
    NVN_BLEND_ADVANCED_MODE_CONTRAST = 0x22,
    NVN_BLEND_ADVANCED_MODE_INVERT = 0x23,
    NVN_BLEND_ADVANCED_MODE_INVERT_RGB = 0x24,
    NVN_BLEND_ADVANCED_MODE_INVERT_OVG = 0x25,
    NVN_BLEND_ADVANCED_MODE_LINEARDODGE = 0x26,
    NVN_BLEND_ADVANCED_MODE_LINEARBURN = 0x27,
    NVN_BLEND_ADVANCED_MODE_VIVIDLIGHT = 0x28,
    NVN_BLEND_ADVANCED_MODE_LINEARLIGHT = 0x29,
    NVN_BLEND_ADVANCED_MODE_PINLIGHT = 0x2A,
    NVN_BLEND_ADVANCED_MODE_HARDMIX = 0x2B,
    NVN_BLEND_ADVANCED_MODE_RED = 0x2C,
    NVN_BLEND_ADVANCED_MODE_GREEN = 0x2D,
    NVN_BLEND_ADVANCED_MODE_BLUE = 0x2E,
    NVN_BLEND_ADVANCED_MODE_HSL_HUE = 0x2F,
    NVN_BLEND_ADVANCED_MODE_HSL_SATURATION = 0x30,
    NVN_BLEND_ADVANCED_MODE_HSL_COLOR = 0x31,
    NVN_BLEND_ADVANCED_MODE_HSL_LUMINOSITY = 0x32,

    NVN_BLEND_ADVANCED_MODE_LARGE = 0x7FFFFFFF
} NVNblendAdvancedMode;

typedef enum {
    NVN_MIN_FILTER_NEAREST = 0x0,
    NVN_MIN_FILTER_LINEAR = 0x1,
    NVN_MIN_FILTER_NEAREST_MIPMAP_NEAREST = 0x2,
    NVN_MIN_FILTER_LINEAR_MIPMAP_NEAREST = 0x3,
    NVN_MIN_FILTER_NEAREST_MIPMAP_LINEAR = 0x4,
    NVN_MIN_FILTER_LINEAR_MIPMAP_LINEAR = 0x5,

    NVN_MIN_FILTER_LARGE = 0x7FFFFFFF
} NVNminFilter;

typedef enum {
    NVN_MAG_FILTER_NEAREST = 0x0,
    NVN_MAG_FILTER_LINEAR = 0x1,

    NVN_MAG_FILTER_LARGE = 0x7FFFFFFF
} NVNmagFilter;

typedef enum {
    NVN_WRAP_MODE_CLAMP = 0x0,
    NVN_WRAP_MODE_REPEAT = 0x1,
    NVN_WRAP_MODE_MIRROR_CLAMP = 0x2,
    NVN_WRAP_MODE_MIRROR_CLAMP_TO_EDGE = 0x3,
    NVN_WRAP_MODE_MIRROR_CLAMP_TO_BORDER = 0x4,
    NVN_WRAP_MODE_CLAMP_TO_BORDER = 0x5,
    NVN_WRAP_MODE_MIRRORED_REPEAT = 0x6,
    NVN_WRAP_MODE_CLAMP_TO_EDGE = 0x7,

    NVN_WRAP_MODE_LARGE = 0x7FFFFFFF
} NVNwrapMode;

typedef enum {
    NVN_COMPARE_MODE_NONE = 0x0,
    NVN_COMPARE_MODE_COMPARE_R_TO_TEXTURE = 0x1,

    NVN_COMPARE_MODE_LARGE = 0x7FFFFFFF
} NVNcompareMode;

typedef enum {
    NVN_COMPARE_FUNC_NEVER = 0x1,
    NVN_COMPARE_FUNC_LESS = 0x2,
    NVN_COMPARE_FUNC_EQUAL = 0x3,
    NVN_COMPARE_FUNC_LEQUAL = 0x4,
    NVN_COMPARE_FUNC_GREATER = 0x5,
    NVN_COMPARE_FUNC_NOTEQUAL = 0x6,
    NVN_COMPARE_FUNC_GEQUAL = 0x7,
    NVN_COMPARE_FUNC_ALWAYS = 0x8,

    NVN_COMPARE_FUNC_LARGE = 0x7FFFFFFF
} NVNcompareFunc;

typedef enum {
    NVN_SAMPLER_REDUCTION_AVERAGE = 0x0,
    NVN_SAMPLER_REDUCTION_MIN = 0x1,
    NVN_SAMPLER_REDUCTION_MAX = 0x2,

    NVN_SAMPLER_REDUCTION_LARGE = 0x7FFFFFFF
} NVNsamplerReduction;

typedef enum {
    NVN_BLEND_FUNC_ZERO = 0x1,
    NVN_BLEND_FUNC_ONE = 0x2,
    NVN_BLEND_FUNC_SRC_COLOR = 0x3,
    NVN_BLEND_FUNC_ONE_MINUS_SRC_COLOR = 0x4,
    NVN_BLEND_FUNC_SRC_ALPHA = 0x5,
    NVN_BLEND_FUNC_ONE_MINUS_SRC_ALPHA = 0x6,
    NVN_BLEND_FUNC_DST_ALPHA = 0x7,
    NVN_BLEND_FUNC_ONE_MINUS_DST_ALPHA = 0x8,
    NVN_BLEND_FUNC_DST_COLOR = 0x9,
    NVN_BLEND_FUNC_ONE_MINUS_DST_COLOR = 0xA,
    NVN_BLEND_FUNC_SRC_ALPHA_SATURATE = 0xB,
    NVN_BLEND_FUNC_SRC1_COLOR = 0x10,
    NVN_BLEND_FUNC_ONE_MINUS_SRC1_COLOR = 0x11,
    NVN_BLEND_FUNC_SRC1_ALPHA = 0x12,
    NVN_BLEND_FUNC_ONE_MINUS_SRC1_ALPHA = 0x13,
    NVN_BLEND_FUNC_CONSTANT_COLOR = 0x61,
    NVN_BLEND_FUNC_ONE_MINUS_CONSTANT_COLOR = 0x62,
    NVN_BLEND_FUNC_CONSTANT_ALPHA = 0x63,
    NVN_BLEND_FUNC_ONE_MINUS_CONSTANT_ALPHA = 0x64,

    NVN_BLEND_FUNC_LARGE = 0x7FFFFFFF
} NVNblendFunc;

typedef enum {
    NVN_BLEND_EQUATION_ADD = 0x1,
    NVN_BLEND_EQUATION_SUB = 0x2,
    NVN_BLEND_EQUATION_REVERSE_SUB = 0x3,
    NVN_BLEND_EQUATION_MIN = 0x4,
    NVN_BLEND_EQUATION_MAX = 0x5,

    NVN_BLEND_EQUATION_LARGE = 0x7FFFFFFF
} NVNblendEquation;

typedef enum {
    NVN_BLEND_ADVANCED_OVERLAP_UNCORRELATED = 0x0,
    NVN_BLEND_ADVANCED_OVERLAP_DISJOINT = 0x1,
    NVN_BLEND_ADVANCED_OVERLAP_CONJOINT = 0x2,

    NVN_BLEND_ADVANCED_OVERLAP_LARGE = 0x7FFFFFFF
} NVNblendAdvancedOverlap;

typedef enum {
    NVN_COVERAGE_MODULATION_MODE_NONE = 0x0,
    NVN_COVERAGE_MODULATION_MODE_RGB = 0x1,
    NVN_COVERAGE_MODULATION_MODE_ALPHA = 0x2,
    NVN_COVERAGE_MODULATION_MODE_RGBA = 0x3,

    NVN_COVERAGE_MODULATION_MODE_LARGE = 0x7FFFFFFF
} NVNcoverageModulationMode;

typedef enum {
    NVN_DEPTH_FUNC_NEVER = 0x1,
    NVN_DEPTH_FUNC_LESS = 0x2,
    NVN_DEPTH_FUNC_EQUAL = 0x3,
    NVN_DEPTH_FUNC_LEQUAL = 0x4,
    NVN_DEPTH_FUNC_GREATER = 0x5,
    NVN_DEPTH_FUNC_NOTEQUAL = 0x6,
    NVN_DEPTH_FUNC_GEQUAL = 0x7,
    NVN_DEPTH_FUNC_ALWAYS = 0x8,

    NVN_DEPTH_FUNC_LARGE = 0x7FFFFFFF
} NVNdepthFunc;

typedef enum {
    NVN_STENCIL_FUNC_NEVER = 0x1,
    NVN_STENCIL_FUNC_LESS = 0x2,
    NVN_STENCIL_FUNC_EQUAL = 0x3,
    NVN_STENCIL_FUNC_LEQUAL = 0x4,
    NVN_STENCIL_FUNC_GREATER = 0x5,
    NVN_STENCIL_FUNC_NOTEQUAL = 0x6,
    NVN_STENCIL_FUNC_GEQUAL = 0x7,
    NVN_STENCIL_FUNC_ALWAYS = 0x8,

    NVN_STENCIL_FUNC_LARGE = 0x7FFFFFFF
} NVNstencilFunc;

typedef enum {
    NVN_STENCIL_OP_KEEP = 0x1,
    NVN_STENCIL_OP_ZERO = 0x2,
    NVN_STENCIL_OP_REPLACE = 0x3,
    NVN_STENCIL_OP_INCR = 0x4,
    NVN_STENCIL_OP_DECR = 0x5,
    NVN_STENCIL_OP_INVERT = 0x6,
    NVN_STENCIL_OP_INCR_WRAP = 0x7,
    NVN_STENCIL_OP_DECR_WRAP = 0x8,

    NVN_STENCIL_OP_LARGE = 0x7FFFFFFF
} NVNstencilOp;

typedef enum {
    NVN_FRONT_FACE_CW = 0x0,
    NVN_FRONT_FACE_CCW = 0x1,

    NVN_FRONT_FACE_LARGE = 0x7FFFFFFF
} NVNfrontFace;

typedef enum {
    NVN_SYNC_WAIT_RESULT_ALREADY_SIGNALED = 0x0,
    NVN_SYNC_WAIT_RESULT_CONDITION_SATISFIED = 0x1,
    NVN_SYNC_WAIT_RESULT_TIMEOUT_EXPIRED = 0x2,
    NVN_SYNC_WAIT_RESULT_FAILED = 0x3,

    NVN_SYNC_WAIT_RESULT_LARGE = 0x7FFFFFFF
} NVNsyncWaitResult;

typedef enum {
    NVN_POLYGON_OFFSET_ENABLE_NONE = 0x0,
    NVN_POLYGON_OFFSET_ENABLE_POINT = 0x1,
    NVN_POLYGON_OFFSET_ENABLE_LINE = 0x2,
    NVN_POLYGON_OFFSET_ENABLE_FILL = 0x4,

    NVN_POLYGON_OFFSET_ENABLE_LARGE = 0x7FFFFFFF
} NVNpolygonOffsetEnable;

typedef enum {
    NVN_POLYGON_MODE_POINT = 0x0,
    NVN_POLYGON_MODE_LINE = 0x1,
    NVN_POLYGON_MODE_FILL = 0x2,

    NVN_POLYGON_MODE_LARGE = 0x7FFFFFFF
} NVNpolygonMode;

typedef enum {
    NVN_VIEWPORT_SWIZZLE_POSITIVE_X = 0x0,
    NVN_VIEWPORT_SWIZZLE_NEGATIVE_X = 0x1,
    NVN_VIEWPORT_SWIZZLE_POSITIVE_Y = 0x2,
    NVN_VIEWPORT_SWIZZLE_NEGATIVE_Y = 0x3,
    NVN_VIEWPORT_SWIZZLE_POSITIVE_Z = 0x4,
    NVN_VIEWPORT_SWIZZLE_NEGATIVE_Z = 0x5,
    NVN_VIEWPORT_SWIZZLE_POSITIVE_W = 0x6,
    NVN_VIEWPORT_SWIZZLE_NEGATIVE_W = 0x7,

    NVN_VIEWPORT_SWIZZLE_LARGE = 0x7FFFFFFF
} NVNviewportSwizzle;

typedef enum {
    NVN_TILED_CACHE_ACTION_ENABLE = 0x1,
    NVN_TILED_CACHE_ACTION_DISABLE = 0x2,
    NVN_TILED_CACHE_ACTION_FLUSH = 0x3,
    NVN_TILED_CACHE_ACTION_FLUSH_NO_TILING = 0x4,
    NVN_TILED_CACHE_ACTION_ENABLE_RENDER_TARGET_BINNING = 0x5,
    NVN_TILED_CACHE_ACTION_DISABLE_RENDER_TARGET_BINNING = 0x6,

    NVN_TILED_CACHE_ACTION_LARGE = 0x7FFFFFFF
} NVNtiledCacheAction;

typedef enum {
    NVN_CONDITIONAL_RENDER_MODE_RENDER_IF_EQUAL = 0x0,
    NVN_CONDITIONAL_RENDER_MODE_RENDER_IF_NOT_EQUAL = 0x1,

    NVN_CONDITIONAL_RENDER_MODE_LARGE = 0x7FFFFFFF
} NVNconditionalRenderMode;

typedef enum {
    NVN_COPY_FLAGS_NONE = 0x0,
    NVN_COPY_FLAGS_LINEAR_FILTER_BIT = 0x1,
    NVN_COPY_FLAGS_ENGINE_2D_BIT = 0x2,
    NVN_COPY_FLAGS_MIRROR_X_BIT = 0x4,
    NVN_COPY_FLAGS_MIRROR_Y_BIT = 0x8,
    NVN_COPY_FLAGS_MIRROR_Z_BIT = 0x10,
    NVN_COPY_FLAGS_LARGE = 0x7FFFFFFF
} NVNcopyFlags;

#ifdef __cplusplus
}
#endif

typedef void (*PFNNVNGENERICFUNCPTRPROC)(void);
typedef PFNNVNGENERICFUNCPTRPROC (*PFNNVNBOOTSTRAPLOADERPROC)(const char*);
typedef void (*PFNNVNCOMMANDBUFFERMEMORYCALLBACKPROC)(NVNcommandBuffer*,
                                                      NVNcommandBufferMemoryEvent, size_t, void*);
typedef void (*PFNNVNDEBUGCALLBACKPROC)(NVNdebugCallbackSource source, NVNdebugCallbackType type,
                                        int id, NVNdebugCallbackSeverity severity,
                                        const unsigned char* message, void* user);
typedef void (*PFNNVNWALKDEBUGDATABASECALLBACKPROC)(void*, void*);

typedef void (*PFNNVNDEVICEBUILDERSETDEFAULTSPROC)(NVNdeviceBuilder*);
typedef void (*PFNNVNDEVICEBUILDERSETFLAGSPROC)(NVNdeviceBuilder*, int);
typedef NVNboolean (*PFNNVNDEVICEINITIALIZEPROC)(NVNdevice*, const NVNdeviceBuilder*);
typedef void (*PFNNVNDEVICEFINALIZEPROC)(NVNdevice*);
typedef void (*PFNNVNDEVICESETDEBUGLABELPROC)(NVNdevice*, const char*);
typedef PFNNVNGENERICFUNCPTRPROC (*PFNNVNDEVICEGETPROCADDRESSPROC)(const NVNdevice*, const char*);
typedef void (*PFNNVNDEVICEGETINTEGERPROC)(const NVNdevice*, NVNdeviceInfo, int*);
typedef uint64_t (*PFNNVNDEVICEGETCURRENTTIMESTAMPINNANOSECONDSPROC)(const NVNdevice*);
typedef void (*PFNNVNDEVICESETINTERMEDIATESHADERCACHEPROC)(NVNdevice*, int);
typedef NVNtextureHandle (*PFNNVNDEVICEGETTEXTUREHANDLEPROC)(const NVNdevice*, int, int);
typedef NVNtextureHandle (*PFNNVNDEVICEGETTEXELFETCHHANDLEPROC)(const NVNdevice*, int);
typedef NVNimageHandle (*PFNNVNDEVICEGETIMAGEHANDLEPROC)(const NVNdevice*, int);
typedef void (*PFNNVNDEVICEINSTALLDEBUGCALLBACKPROC)(NVNdevice*, const PFNNVNDEBUGCALLBACKPROC,
                                                     void*, NVNboolean);
typedef NVNdebugDomainId (*PFNNVNDEVICEGENERATEDEBUGDOMAINIDPROC)(const NVNdevice*, const char*);
typedef void (*PFNNVNDEVICESETWINDOWORIGINMODEPROC)(NVNdevice*, NVNwindowOriginMode);
typedef void (*PFNNVNDEVICESETDEPTHMODEPROC)(NVNdevice*, NVNdepthMode);
typedef NVNboolean (*PFNNVNDEVICEREGISTERFASTCLEARCOLORPROC)(NVNdevice*, const float*, NVNformat);
typedef NVNboolean (*PFNNVNDEVICEREGISTERFASTCLEARCOLORIPROC)(NVNdevice*, const int*, NVNformat);
typedef NVNboolean (*PFNNVNDEVICEREGISTERFASTCLEARCOLORUIPROC)(NVNdevice*, const uint32_t*,
                                                               NVNformat);
typedef NVNboolean (*PFNNVNDEVICEREGISTERFASTCLEARDEPTHPROC)(NVNdevice*, float);
typedef NVNwindowOriginMode (*PFNNVNDEVICEGETWINDOWORIGINMODEPROC)(const NVNdevice*);
typedef NVNdepthMode (*PFNNVNDEVICEGETDEPTHMODEPROC)(const NVNdevice*);
typedef uint64_t (*PFNNVNDEVICEGETTIMESTAMPINNANOSECONDSPROC)(const NVNdevice*,
                                                              const NVNcounterData*);
typedef void (*PFNNVNDEVICEAPPLYDEFERREDFINALIZESPROC)(NVNdevice*, int);
typedef void (*PFNNVNDEVICEFINALIZECOMMANDHANDLEPROC)(NVNdevice*, NVNcommandHandle);
typedef void (*PFNNVNDEVICEWALKDEBUGDATABASEPROC)(const NVNdevice*, NVNdebugObjectType,
                                                  PFNNVNWALKDEBUGDATABASECALLBACKPROC, void*);
typedef NVNseparateTextureHandle (*PFNNVNDEVICEGETSEPARATETEXTUREHANDLEPROC)(const NVNdevice*, int);
typedef NVNseparateSamplerHandle (*PFNNVNDEVICEGETSEPARATESAMPLERHANDLEPROC)(const NVNdevice*, int);
typedef NVNboolean (*PFNNVNDEVICEISEXTERNALDEBUGGERATTACHEDPROC)(const NVNdevice*);
typedef NVNqueueGetErrorResult (*PFNNVNQUEUEGETERRORPROC)(NVNqueue*, NVNqueueErrorInfo*);
typedef size_t (*PFNNVNQUEUEGETTOTALCOMMANDMEMORYUSEDPROC)(NVNqueue*);
typedef size_t (*PFNNVNQUEUEGETTOTALCONTROLMEMORYUSEDPROC)(NVNqueue*);
typedef size_t (*PFNNVNQUEUEGETTOTALCOMPUTEMEMORYUSEDPROC)(NVNqueue*);
typedef void (*PFNNVNQUEUERESETMEMORYUSAGECOUNTSPROC)(NVNqueue*);
typedef void (*PFNNVNQUEUEBUILDERSETDEVICEPROC)(NVNqueueBuilder*, NVNdevice*);
typedef void (*PFNNVNQUEUEBUILDERSETDEFAULTSPROC)(NVNqueueBuilder*);
typedef void (*PFNNVNQUEUEBUILDERSETFLAGSPROC)(NVNqueueBuilder*, int);
typedef void (*PFNNVNQUEUEBUILDERSETCOMMANDMEMORYSIZEPROC)(NVNqueueBuilder*, size_t);
typedef void (*PFNNVNQUEUEBUILDERSETCOMPUTEMEMORYSIZEPROC)(NVNqueueBuilder*, size_t);
typedef void (*PFNNVNQUEUEBUILDERSETCONTROLMEMORYSIZEPROC)(NVNqueueBuilder*, size_t);
typedef size_t (*PFNNVNQUEUEBUILDERGETQUEUEMEMORYSIZEPROC)(const NVNqueueBuilder*);
typedef void (*PFNNVNQUEUEBUILDERSETQUEUEMEMORYPROC)(NVNqueueBuilder*, void*, size_t);
typedef void (*PFNNVNQUEUEBUILDERSETCOMMANDFLUSHTHRESHOLDPROC)(NVNqueueBuilder*, size_t);
typedef NVNboolean (*PFNNVNQUEUEINITIALIZEPROC)(NVNqueue*, const NVNqueueBuilder*);
typedef void (*PFNNVNQUEUEFINALIZEPROC)(NVNqueue*);
typedef void (*PFNNVNQUEUESETDEBUGLABELPROC)(NVNqueue*, const char*);
typedef void (*PFNNVNQUEUESUBMITCOMMANDSPROC)(NVNqueue*, int, const NVNcommandHandle*);
typedef void (*PFNNVNQUEUEFLUSHPROC)(NVNqueue*);
typedef void (*PFNNVNQUEUEFINISHPROC)(NVNqueue*);
typedef void (*PFNNVNQUEUEPRESENTTEXTUREPROC)(NVNqueue*, NVNwindow*, int);
typedef NVNqueueAcquireTextureResult (*PFNNVNQUEUEACQUIRETEXTUREPROC)(NVNqueue*, NVNwindow*, int*);
typedef void (*PFNNVNWINDOWBUILDERSETDEVICEPROC)(NVNwindowBuilder*, NVNdevice*);
typedef void (*PFNNVNWINDOWBUILDERSETDEFAULTSPROC)(NVNwindowBuilder*);
typedef void (*PFNNVNWINDOWBUILDERSETNATIVEWINDOWPROC)(NVNwindowBuilder*, NVNnativeWindow);
typedef void (*PFNNVNWINDOWBUILDERSETTEXTURESPROC)(NVNwindowBuilder*, int, NVNtexture* const*);
typedef void (*PFNNVNWINDOWBUILDERSETPRESENTINTERVALPROC)(NVNwindowBuilder*, int);
typedef NVNnativeWindow (*PFNNVNWINDOWBUILDERGETNATIVEWINDOWPROC)(const NVNwindowBuilder*);
typedef int (*PFNNVNWINDOWBUILDERGETPRESENTINTERVALPROC)(const NVNwindowBuilder*);
typedef NVNboolean (*PFNNVNWINDOWINITIALIZEPROC)(NVNwindow*, const NVNwindowBuilder*);
typedef void (*PFNNVNWINDOWFINALIZEPROC)(NVNwindow*);
typedef void (*PFNNVNWINDOWSETDEBUGLABELPROC)(NVNwindow*, const char*);
typedef NVNwindowAcquireTextureResult (*PFNNVNWINDOWACQUIRETEXTUREPROC)(NVNwindow*, NVNsync*, int*);
typedef NVNnativeWindow (*PFNNVNWINDOWGETNATIVEWINDOWPROC)(const NVNwindow*);
typedef int (*PFNNVNWINDOWGETPRESENTINTERVALPROC)(const NVNwindow*);
typedef void (*PFNNVNWINDOWSETPRESENTINTERVALPROC)(NVNwindow*, int);
typedef void (*PFNNVNWINDOWSETCROPPROC)(NVNwindow*, int, int, int, int);
typedef void (*PFNNVNWINDOWGETCROPPROC)(const NVNwindow*, NVNrectangle*);
typedef NVNboolean (*PFNNVNPROGRAMINITIALIZEPROC)(NVNprogram*, NVNdevice*);
typedef void (*PFNNVNPROGRAMFINALIZEPROC)(NVNprogram*);
typedef void (*PFNNVNPROGRAMSETDEBUGLABELPROC)(NVNprogram*, const char*);
typedef NVNboolean (*PFNNVNPROGRAMSETSHADERSPROC)(NVNprogram*, int, const NVNshaderData*);
typedef void (*PFNNVNMEMORYPOOLBUILDERSETDEVICEPROC)(NVNmemoryPoolBuilder*, NVNdevice*);
typedef void (*PFNNVNMEMORYPOOLBUILDERSETDEFAULTSPROC)(NVNmemoryPoolBuilder*);
typedef void (*PFNNVNMEMORYPOOLBUILDERSETSTORAGEPROC)(NVNmemoryPoolBuilder*, void*, size_t);
typedef void (*PFNNVNMEMORYPOOLBUILDERSETFLAGSPROC)(NVNmemoryPoolBuilder*, int);
typedef void (*PFNNVNMEMORYPOOLBUILDERGETMEMORYPROC)(const NVNmemoryPoolBuilder*);
typedef size_t (*PFNNVNMEMORYPOOLBUILDERGETSIZEPROC)(const NVNmemoryPoolBuilder*);
typedef NVNmemoryPoolFlags (*PFNNVNMEMORYPOOLBUILDERGETFLAGSPROC)(const NVNmemoryPoolBuilder*);
typedef NVNboolean (*PFNNVNMEMORYPOOLINITIALIZEPROC)(NVNmemoryPool*, const NVNmemoryPoolBuilder*);
typedef void (*PFNNVNMEMORYPOOLSETDEBUGLABELPROC)(NVNmemoryPool*, const char*);
typedef void (*PFNNVNMEMORYPOOLFINALIZEPROC)(NVNmemoryPool*);
typedef void* (*PFNNVNMEMORYPOOLMAPPROC)(const NVNmemoryPool*);
typedef void (*PFNNVNMEMORYPOOLFLUSHMAPPEDRANGEPROC)(const NVNmemoryPool*, ptrdiff_t, size_t);
typedef void (*PFNNVNMEMORYPOOLINVALIDATEMAPPEDRANGEPROC)(const NVNmemoryPool*, ptrdiff_t, size_t);
typedef NVNbufferAddress (*PFNNVNMEMORYPOOLGETBUFFERADDRESSPROC)(const NVNmemoryPool*);
typedef NVNboolean (*PFNNVNMEMORYPOOLMAPVIRTUALPROC)(NVNmemoryPool*, int, const NVNmappingRequest*);
typedef size_t (*PFNNVNMEMORYPOOLGETSIZEPROC)(const NVNmemoryPool*);
typedef NVNmemoryPoolFlags (*PFNNVNMEMORYPOOLGETFLAGSPROC)(const NVNmemoryPool*);
typedef NVNboolean (*PFNNVNTEXTUREPOOLINITIALIZEPROC)(NVNtexturePool*, const NVNmemoryPool*,
                                                      ptrdiff_t, int);
typedef void (*PFNNVNTEXTUREPOOLSETDEBUGLABELPROC)(NVNtexturePool*, const char*);
typedef void (*PFNNVNTEXTUREPOOLFINALIZEPROC)(NVNtexturePool*);
typedef void (*PFNNVNTEXTUREPOOLREGISTERTEXTUREPROC)(const NVNtexturePool*, int, const NVNtexture*,
                                                     const NVNtextureView*);
typedef void (*PFNNVNTEXTUREPOOLREGISTERIMAGEPROC)(const NVNtexturePool*, int, const NVNtexture*,
                                                   const NVNtextureView*);
typedef const NVNmemoryPool* (*PFNNVNTEXTUREPOOLGETMEMORYPOOLPROC)(const NVNtexturePool*);
typedef ptrdiff_t (*PFNNVNTEXTUREPOOLGETMEMORYOFFSETPROC)(const NVNtexturePool*);
typedef int (*PFNNVNTEXTUREPOOLGETSIZEPROC)(const NVNtexturePool*);
typedef NVNboolean (*PFNNVNSAMPLERPOOLINITIALIZEPROC)(NVNsamplerPool*, const NVNmemoryPool*,
                                                      ptrdiff_t, int);
typedef void (*PFNNVNSAMPLERPOOLSETDEBUGLABELPROC)(NVNsamplerPool*, const char*);
typedef void (*PFNNVNSAMPLERPOOLFINALIZEPROC)(NVNsamplerPool*);
typedef void (*PFNNVNSAMPLERPOOLREGISTERSAMPLERPROC)(const NVNsamplerPool*, int, const NVNsampler*);
typedef void (*PFNNVNSAMPLERPOOLREGISTERSAMPLERBUILDERPROC)(const NVNsamplerPool*, int,
                                                            const NVNsamplerBuilder*);
typedef const NVNmemoryPool* (*PFNNVNSAMPLERPOOLGETMEMORYPOOLPROC)(const NVNsamplerPool*);
typedef ptrdiff_t (*PFNNVNSAMPLERPOOLGETMEMORYOFFSETPROC)(const NVNsamplerPool*);
typedef int (*PFNNVNSAMPLERPOOLGETSIZEPROC)(const NVNsamplerPool*);
typedef void (*PFNNVNBUFFERBUILDERSETDEVICEPROC)(NVNbufferBuilder*, NVNdevice*);
typedef void (*PFNNVNBUFFERBUILDERSETDEFAULTSPROC)(NVNbufferBuilder*);
typedef void (*PFNNVNBUFFERBUILDERSETSTORAGEPROC)(NVNbufferBuilder*, NVNmemoryPool*, ptrdiff_t,
                                                  size_t);
typedef NVNmemoryPool (*PFNNVNBUFFERBUILDERGETMEMORYPOOLPROC)(const NVNbufferBuilder*);
typedef ptrdiff_t (*PFNNVNBUFFERBUILDERGETMEMORYOFFSETPROC)(const NVNbufferBuilder*);
typedef size_t (*PFNNVNBUFFERBUILDERGETSIZEPROC)(const NVNbufferBuilder*);
typedef NVNboolean (*PFNNVNBUFFERINITIALIZEPROC)(NVNbuffer*, const NVNbufferBuilder*);
typedef void (*PFNNVNBUFFERSETDEBUGLABELPROC)(NVNbuffer*, const char*);
typedef void (*PFNNVNBUFFERFINALIZEPROC)(NVNbuffer*);
typedef void* (*PFNNVNBUFFERMAPPROC)(const NVNbuffer*);
typedef NVNbufferAddress (*PFNNVNBUFFERGETADDRESSPROC)(const NVNbuffer*);
typedef void (*PFNNVNBUFFERFLUSHMAPPEDRANGEPROC)(const NVNbuffer*, ptrdiff_t, size_t);
typedef void (*PFNNVNBUFFERINVALIDATEMAPPEDRANGEPROC)(const NVNbuffer*, ptrdiff_t, size_t);
typedef NVNmemoryPool* (*PFNNVNBUFFERGETMEMORYPOOLPROC)(const NVNbuffer*);
typedef ptrdiff_t (*PFNNVNBUFFERGETMEMORYOFFSETPROC)(const NVNbuffer*);
typedef size_t (*PFNNVNBUFFERGETSIZEPROC)(const NVNbuffer*);
typedef uint64_t (*PFNNVNBUFFERGETDEBUGIDPROC)(const NVNbuffer*);
typedef void (*PFNNVNTEXTUREBUILDERSETDEVICEPROC)(NVNtextureBuilder*, NVNdevice*);
typedef void (*PFNNVNTEXTUREBUILDERSETDEFAULTSPROC)(NVNtextureBuilder*);
typedef void (*PFNNVNTEXTUREBUILDERSETFLAGSPROC)(NVNtextureBuilder*, int);
typedef void (*PFNNVNTEXTUREBUILDERSETTARGETPROC)(NVNtextureBuilder*, NVNtextureTarget);
typedef void (*PFNNVNTEXTUREBUILDERSETWIDTHPROC)(NVNtextureBuilder*, int);
typedef void (*PFNNVNTEXTUREBUILDERSETHEIGHTPROC)(NVNtextureBuilder*, int);
typedef void (*PFNNVNTEXTUREBUILDERSETDEPTHPROC)(NVNtextureBuilder*, int);
typedef void (*PFNNVNTEXTUREBUILDERSETSIZE1DPROC)(NVNtextureBuilder*, int);
typedef void (*PFNNVNTEXTUREBUILDERSETSIZE2DPROC)(NVNtextureBuilder*, int, int);
typedef void (*PFNNVNTEXTUREBUILDERSETSIZE3DPROC)(NVNtextureBuilder*, int, int, int);
typedef void (*PFNNVNTEXTUREBUILDERSETLEVELSPROC)(NVNtextureBuilder*, int);
typedef void (*PFNNVNTEXTUREBUILDERSETFORMATPROC)(NVNtextureBuilder*, NVNformat);
typedef void (*PFNNVNTEXTUREBUILDERSETSAMPLESPROC)(NVNtextureBuilder*, int);
typedef void (*PFNNVNTEXTUREBUILDERSETSWIZZLEPROC)(NVNtextureBuilder*, NVNtextureSwizzle,
                                                   NVNtextureSwizzle, NVNtextureSwizzle,
                                                   NVNtextureSwizzle);
typedef void (*PFNNVNTEXTUREBUILDERSETDEPTHSTENCILMODEPROC)(NVNtextureBuilder*,
                                                            NVNtextureDepthStencilMode);
typedef size_t (*PFNNVNTEXTUREBUILDERGETSTORAGESIZEPROC)(const NVNtextureBuilder*);
typedef size_t (*PFNNVNTEXTUREBUILDERGETSTORAGEALIGNMENTPROC)(const NVNtextureBuilder*);
typedef void (*PFNNVNTEXTUREBUILDERSETSTORAGEPROC)(NVNtextureBuilder*, NVNmemoryPool*, ptrdiff_t);
typedef void (*PFNNVNTEXTUREBUILDERSETPACKAGEDTEXTUREDATAPROC)(NVNtextureBuilder*, const void*);
typedef void (*PFNNVNTEXTUREBUILDERSETPACKAGEDTEXTURELAYOUTPROC)(NVNtextureBuilder*,
                                                                 const NVNpackagedTextureLayout*);
typedef void (*PFNNVNTEXTUREBUILDERSETSTRIDEPROC)(NVNtextureBuilder*, ptrdiff_t);
typedef void (*PFNNVNTEXTUREBUILDERSETGLTEXTURENAMEPROC)(NVNtextureBuilder*, uint32_t);
typedef NVNstorageClass (*PFNNVNTEXTUREBUILDERGETSTORAGECLASSPROC)(const NVNtextureBuilder*);
typedef NVNtextureFlags (*PFNNVNTEXTUREBUILDERGETFLAGSPROC)(const NVNtextureBuilder*);
typedef NVNtextureTarget (*PFNNVNTEXTUREBUILDERGETTARGETPROC)(const NVNtextureBuilder*);
typedef int (*PFNNVNTEXTUREBUILDERGETWIDTHPROC)(const NVNtextureBuilder*);
typedef int (*PFNNVNTEXTUREBUILDERGETHEIGHTPROC)(const NVNtextureBuilder*);
typedef int (*PFNNVNTEXTUREBUILDERGETDEPTHPROC)(const NVNtextureBuilder*);
typedef int (*PFNNVNTEXTUREBUILDERGETLEVELSPROC)(const NVNtextureBuilder*);
typedef NVNformat (*PFNNVNTEXTUREBUILDERGETFORMATPROC)(const NVNtextureBuilder*);
typedef int (*PFNNVNTEXTUREBUILDERGETSAMPLESPROC)(const NVNtextureBuilder*);
typedef void (*PFNNVNTEXTUREBUILDERGETSWIZZLEPROC)(const NVNtextureBuilder*, NVNtextureSwizzle*,
                                                   NVNtextureSwizzle*, NVNtextureSwizzle*,
                                                   NVNtextureSwizzle*);
typedef NVNtextureDepthStencilMode (*PFNNVNTEXTUREBUILDERGETDEPTHSTENCILMODEPROC)(
    const NVNtextureBuilder*);
typedef const void* (*PFNNVNTEXTUREBUILDERGETPACKAGEDTEXTUREDATAPROC)(const NVNtextureBuilder*);
typedef ptrdiff_t (*PFNNVNTEXTUREBUILDERGETSTRIDEPROC)(const NVNtextureBuilder*);
typedef void (*PFNNVNTEXTUREBUILDERGETSPARSETILELAYOUTPROC)(const NVNtextureBuilder*,
                                                            NVNtextureSparseTileLayout*);
typedef uint32_t (*PFNNVNTEXTUREBUILDERGETGLTEXTURENAMEPROC)(const NVNtextureBuilder*);
typedef size_t (*PFNNVNTEXTUREBUILDERGETZCULLSTORAGESIZEPROC)(const NVNtextureBuilder*);
typedef NVNmemoryPool (*PFNNVNTEXTUREBUILDERGETMEMORYPOOLPROC)(const NVNtextureBuilder*);
typedef ptrdiff_t (*PFNNVNTEXTUREBUILDERGETMEMORYOFFSETPROC)(const NVNtextureBuilder*);
typedef void (*PFNNVNTEXTUREVIEWSETDEFAULTSPROC)(NVNtextureView*);
typedef void (*PFNNVNTEXTUREVIEWSETLEVELSPROC)(NVNtextureView*, int, int);
typedef void (*PFNNVNTEXTUREVIEWSETLAYERSPROC)(NVNtextureView*, int, int);
typedef void (*PFNNVNTEXTUREVIEWSETFORMATPROC)(NVNtextureView*, NVNformat);
typedef void (*PFNNVNTEXTUREVIEWSETSWIZZLEPROC)(NVNtextureView*, NVNtextureSwizzle,
                                                NVNtextureSwizzle, NVNtextureSwizzle,
                                                NVNtextureSwizzle);
typedef void (*PFNNVNTEXTUREVIEWSETDEPTHSTENCILMODEPROC)(NVNtextureView*,
                                                         NVNtextureDepthStencilMode);
typedef void (*PFNNVNTEXTUREVIEWSETTARGETPROC)(NVNtextureView*, NVNtextureTarget);
typedef NVNboolean (*PFNNVNTEXTUREVIEWGETLEVELSPROC)(const NVNtextureView*, int*, int*);
typedef NVNboolean (*PFNNVNTEXTUREVIEWGETLAYERSPROC)(const NVNtextureView*, int*, int*);
typedef NVNboolean (*PFNNVNTEXTUREVIEWGETFORMATPROC)(const NVNtextureView*, NVNformat*);
typedef NVNboolean (*PFNNVNTEXTUREVIEWGETSWIZZLEPROC)(const NVNtextureView*, NVNtextureSwizzle*,
                                                      NVNtextureSwizzle*, NVNtextureSwizzle*,
                                                      NVNtextureSwizzle*);
typedef NVNboolean (*PFNNVNTEXTUREVIEWGETDEPTHSTENCILMODEPROC)(const NVNtextureView*,
                                                               NVNtextureDepthStencilMode*);
typedef NVNboolean (*PFNNVNTEXTUREVIEWGETTARGETPROC)(const NVNtextureView*, NVNtextureTarget*);
typedef NVNboolean (*PFNNVNTEXTUREVIEWCOMPAREPROC)(const NVNtextureView*, const NVNtextureView*);
typedef NVNboolean (*PFNNVNTEXTUREINITIALIZEPROC)(NVNtexture*, const NVNtextureBuilder*);
typedef size_t (*PFNNVNTEXTUREGETZCULLSTORAGESIZEPROC)(const NVNtexture*);
typedef void (*PFNNVNTEXTUREFINALIZEPROC)(NVNtexture*);
typedef void (*PFNNVNTEXTURESETDEBUGLABELPROC)(NVNtexture*, const char*);
typedef NVNstorageClass (*PFNNVNTEXTUREGETSTORAGECLASSPROC)(const NVNtexture*);
typedef ptrdiff_t (*PFNNVNTEXTUREGETVIEWOFFSETPROC)(const NVNtexture*, const NVNtextureView*);
typedef NVNtextureFlags (*PFNNVNTEXTUREGETFLAGSPROC)(const NVNtexture*);
typedef NVNtextureTarget (*PFNNVNTEXTUREGETTARGETPROC)(const NVNtexture*);
typedef int (*PFNNVNTEXTUREGETWIDTHPROC)(const NVNtexture*);
typedef int (*PFNNVNTEXTUREGETHEIGHTPROC)(const NVNtexture*);
typedef int (*PFNNVNTEXTUREGETDEPTHPROC)(const NVNtexture*);
typedef int (*PFNNVNTEXTUREGETLEVELSPROC)(const NVNtexture*);
typedef NVNformat (*PFNNVNTEXTUREGETFORMATPROC)(const NVNtexture*);
typedef int (*PFNNVNTEXTUREGETSAMPLESPROC)(const NVNtexture*);
typedef void (*PFNNVNTEXTUREGETSWIZZLEPROC)(const NVNtexture*, NVNtextureSwizzle*,
                                            NVNtextureSwizzle*, NVNtextureSwizzle*,
                                            NVNtextureSwizzle*);
typedef NVNtextureDepthStencilMode (*PFNNVNTEXTUREGETDEPTHSTENCILMODEPROC)(const NVNtexture*);
typedef ptrdiff_t (*PFNNVNTEXTUREGETSTRIDEPROC)(const NVNtexture*);
typedef NVNtextureAddress (*PFNNVNTEXTUREGETTEXTUREADDRESSPROC)(const NVNtexture*);
typedef void (*PFNNVNTEXTUREGETSPARSETILELAYOUTPROC)(const NVNtexture*,
                                                     NVNtextureSparseTileLayout*);
typedef void (*PFNNVNTEXTUREWRITETEXELSPROC)(const NVNtexture*, const NVNtextureView*,
                                             const NVNcopyRegion*, const void*);
typedef void (*PFNNVNTEXTUREWRITETEXELSSTRIDEDPROC)(const NVNtexture*, const NVNtextureView*,
                                                    const NVNcopyRegion*, const void*, ptrdiff_t,
                                                    ptrdiff_t);
typedef void (*PFNNVNTEXTUREREADTEXELSPROC)(const NVNtexture*, const NVNtextureView*,
                                            const NVNcopyRegion*, void*);
typedef void (*PFNNVNTEXTUREREADTEXELSSTRIDEDPROC)(const NVNtexture*, const NVNtextureView*,
                                                   const NVNcopyRegion*, void*, ptrdiff_t,
                                                   ptrdiff_t);
typedef void (*PFNNVNTEXTUREFLUSHTEXELSPROC)(const NVNtexture*, const NVNtextureView*,
                                             const NVNcopyRegion*);
typedef void (*PFNNVNTEXTUREINVALIDATETEXELSPROC)(const NVNtexture*, const NVNtextureView*,
                                                  const NVNcopyRegion*);
typedef NVNmemoryPool (*PFNNVNTEXTUREGETMEMORYPOOLPROC)(const NVNtexture*);
typedef ptrdiff_t (*PFNNVNTEXTUREGETMEMORYOFFSETPROC)(const NVNtexture*);
typedef int (*PFNNVNTEXTUREGETSTORAGESIZEPROC)(const NVNtexture*);
typedef NVNboolean (*PFNNVNTEXTURECOMPAREPROC)(const NVNtexture*, const NVNtexture*);
typedef uint64_t (*PFNNVNTEXTUREGETDEBUGIDPROC)(const NVNtexture*);
typedef void (*PFNNVNSAMPLERBUILDERSETDEVICEPROC)(NVNsamplerBuilder*, NVNdevice*);
typedef void (*PFNNVNSAMPLERBUILDERSETDEFAULTSPROC)(NVNsamplerBuilder*);
typedef void (*PFNNVNSAMPLERBUILDERSETMINMAGFILTERPROC)(NVNsamplerBuilder*, NVNminFilter,
                                                        NVNmagFilter);
typedef void (*PFNNVNSAMPLERBUILDERSETWRAPMODEPROC)(NVNsamplerBuilder*, NVNwrapMode, NVNwrapMode,
                                                    NVNwrapMode);
typedef void (*PFNNVNSAMPLERBUILDERSETLODCLAMPPROC)(NVNsamplerBuilder*, float, float);
typedef void (*PFNNVNSAMPLERBUILDERSETLODBIASPROC)(NVNsamplerBuilder*, float);
typedef void (*PFNNVNSAMPLERBUILDERSETCOMPAREPROC)(NVNsamplerBuilder*, NVNcompareMode,
                                                   NVNcompareFunc);
typedef void (*PFNNVNSAMPLERBUILDERSETBORDERCOLORPROC)(NVNsamplerBuilder*, const float*);
typedef void (*PFNNVNSAMPLERBUILDERSETBORDERCOLORIPROC)(NVNsamplerBuilder*, const int*);
typedef void (*PFNNVNSAMPLERBUILDERSETBORDERCOLORUIPROC)(NVNsamplerBuilder*, const uint32_t*);
typedef void (*PFNNVNSAMPLERBUILDERSETMAXANISOTROPYPROC)(NVNsamplerBuilder*, float);
typedef void (*PFNNVNSAMPLERBUILDERSETREDUCTIONFILTERPROC)(NVNsamplerBuilder*, NVNsamplerReduction);
typedef void (*PFNNVNSAMPLERBUILDERSETLODSNAPPROC)(NVNsamplerBuilder*, float);
typedef void (*PFNNVNSAMPLERBUILDERGETMINMAGFILTERPROC)(const NVNsamplerBuilder*, NVNminFilter*,
                                                        NVNmagFilter*);
typedef void (*PFNNVNSAMPLERBUILDERGETWRAPMODEPROC)(const NVNsamplerBuilder*, NVNwrapMode*,
                                                    NVNwrapMode*, NVNwrapMode*);
typedef void (*PFNNVNSAMPLERBUILDERGETLODCLAMPPROC)(const NVNsamplerBuilder*, float*, float*);
typedef float (*PFNNVNSAMPLERBUILDERGETLODBIASPROC)(const NVNsamplerBuilder*);
typedef void (*PFNNVNSAMPLERBUILDERGETCOMPAREPROC)(const NVNsamplerBuilder*, NVNcompareMode*,
                                                   NVNcompareFunc*);
typedef void (*PFNNVNSAMPLERBUILDERGETBORDERCOLORPROC)(const NVNsamplerBuilder*, float*);
typedef void (*PFNNVNSAMPLERBUILDERGETBORDERCOLORIPROC)(const NVNsamplerBuilder*, int*);
typedef void (*PFNNVNSAMPLERBUILDERGETBORDERCOLORUIPROC)(const NVNsamplerBuilder*, uint32_t*);
typedef float (*PFNNVNSAMPLERBUILDERGETMAXANISOTROPYPROC)(const NVNsamplerBuilder*);
typedef NVNsamplerReduction (*PFNNVNSAMPLERBUILDERGETREDUCTIONFILTERPROC)(const NVNsamplerBuilder*);
typedef float (*PFNNVNSAMPLERBUILDERGETLODSNAPPROC)(const NVNsamplerBuilder*);
typedef NVNboolean (*PFNNVNSAMPLERINITIALIZEPROC)(NVNsampler*, const NVNsamplerBuilder*);
typedef void (*PFNNVNSAMPLERFINALIZEPROC)(NVNsampler*);
typedef void (*PFNNVNSAMPLERSETDEBUGLABELPROC)(NVNsampler*, const char*);
typedef void (*PFNNVNSAMPLERGETMINMAGFILTERPROC)(const NVNsampler*, NVNminFilter*, NVNmagFilter*);
typedef void (*PFNNVNSAMPLERGETWRAPMODEPROC)(const NVNsampler*, NVNwrapMode*, NVNwrapMode*,
                                             NVNwrapMode*);
typedef void (*PFNNVNSAMPLERGETLODCLAMPPROC)(const NVNsampler*, float*, float*);
typedef float (*PFNNVNSAMPLERGETLODBIASPROC)(const NVNsampler*);
typedef void (*PFNNVNSAMPLERGETCOMPAREPROC)(const NVNsampler*, NVNcompareMode*, NVNcompareFunc*);
typedef void (*PFNNVNSAMPLERGETBORDERCOLORPROC)(const NVNsampler*, float*);
typedef void (*PFNNVNSAMPLERGETBORDERCOLORIPROC)(const NVNsampler*, int*);
typedef void (*PFNNVNSAMPLERGETBORDERCOLORUIPROC)(const NVNsampler*, uint32_t*);
typedef float (*PFNNVNSAMPLERGETMAXANISOTROPYPROC)(const NVNsampler*);
typedef NVNsamplerReduction (*PFNNVNSAMPLERGETREDUCTIONFILTERPROC)(const NVNsampler*);
typedef NVNboolean (*PFNNVNSAMPLERCOMPAREPROC)(const NVNsampler*, const NVNsampler*);
typedef uint64_t (*PFNNVNSAMPLERGETDEBUGIDPROC)(const NVNsampler*);
typedef void (*PFNNVNBLENDSTATESETDEFAULTSPROC)(NVNblendState*);
typedef void (*PFNNVNBLENDSTATESETBLENDTARGETPROC)(NVNblendState*, int);
typedef void (*PFNNVNBLENDSTATESETBLENDFUNCPROC)(NVNblendState*, NVNblendFunc, NVNblendFunc,
                                                 NVNblendFunc, NVNblendFunc);
typedef void (*PFNNVNBLENDSTATESETBLENDEQUATIONPROC)(NVNblendState*, NVNblendEquation,
                                                     NVNblendEquation);
typedef void (*PFNNVNBLENDSTATESETADVANCEDMODEPROC)(NVNblendState*, NVNblendAdvancedMode);
typedef void (*PFNNVNBLENDSTATESETADVANCEDOVERLAPPROC)(NVNblendState*, NVNblendAdvancedOverlap);
typedef void (*PFNNVNBLENDSTATESETADVANCEDPREMULTIPLIEDSRCPROC)(NVNblendState*, NVNboolean);
typedef void (*PFNNVNBLENDSTATESETADVANCEDNORMALIZEDDSTPROC)(NVNblendState*, NVNboolean);
typedef int (*PFNNVNBLENDSTATEGETBLENDTARGETPROC)(const NVNblendState*);
typedef void (*PFNNVNBLENDSTATEGETBLENDFUNCPROC)(const NVNblendState*, NVNblendFunc*, NVNblendFunc*,
                                                 NVNblendFunc*, NVNblendFunc*);
typedef void (*PFNNVNBLENDSTATEGETBLENDEQUATIONPROC)(const NVNblendState*, NVNblendEquation*,
                                                     NVNblendEquation*);
typedef NVNblendAdvancedMode (*PFNNVNBLENDSTATEGETADVANCEDMODEPROC)(const NVNblendState*);
typedef NVNblendAdvancedOverlap (*PFNNVNBLENDSTATEGETADVANCEDOVERLAPPROC)(const NVNblendState*);
typedef NVNboolean (*PFNNVNBLENDSTATEGETADVANCEDPREMULTIPLIEDSRCPROC)(const NVNblendState*);
typedef NVNboolean (*PFNNVNBLENDSTATEGETADVANCEDNORMALIZEDDSTPROC)(const NVNblendState*);
typedef void (*PFNNVNCOLORSTATESETDEFAULTSPROC)(NVNcolorState*);
typedef void (*PFNNVNCOLORSTATESETBLENDENABLEPROC)(NVNcolorState*, int, NVNboolean);
typedef void (*PFNNVNCOLORSTATESETLOGICOPPROC)(NVNcolorState*, NVNlogicOp);
typedef void (*PFNNVNCOLORSTATESETALPHATESTPROC)(NVNcolorState*, NVNalphaFunc);
typedef NVNboolean (*PFNNVNCOLORSTATEGETBLENDENABLEPROC)(const NVNcolorState*, int);
typedef NVNlogicOp (*PFNNVNCOLORSTATEGETLOGICOPPROC)(const NVNcolorState*);
typedef NVNalphaFunc (*PFNNVNCOLORSTATEGETALPHATESTPROC)(const NVNcolorState*);
typedef void (*PFNNVNCHANNELMASKSTATESETDEFAULTSPROC)(NVNchannelMaskState*);
typedef void (*PFNNVNCHANNELMASKSTATESETCHANNELMASKPROC)(NVNchannelMaskState*, int, NVNboolean,
                                                         NVNboolean, NVNboolean, NVNboolean);
typedef void (*PFNNVNCHANNELMASKSTATEGETCHANNELMASKPROC)(const NVNchannelMaskState*, int,
                                                         NVNboolean*, NVNboolean*, NVNboolean*,
                                                         NVNboolean*);
typedef void (*PFNNVNMULTISAMPLESTATESETDEFAULTSPROC)(NVNmultisampleState*);
typedef void (*PFNNVNMULTISAMPLESTATESETMULTISAMPLEENABLEPROC)(NVNmultisampleState*, NVNboolean);
typedef void (*PFNNVNMULTISAMPLESTATESETSAMPLESPROC)(NVNmultisampleState*, int);
typedef void (*PFNNVNMULTISAMPLESTATESETALPHATOCOVERAGEENABLEPROC)(NVNmultisampleState*,
                                                                   NVNboolean);
typedef void (*PFNNVNMULTISAMPLESTATESETALPHATOCOVERAGEDITHERPROC)(NVNmultisampleState*,
                                                                   NVNboolean);
typedef NVNboolean (*PFNNVNMULTISAMPLESTATEGETMULTISAMPLEENABLEPROC)(const NVNmultisampleState*);
typedef int (*PFNNVNMULTISAMPLESTATEGETSAMPLESPROC)(const NVNmultisampleState*);
typedef NVNboolean (*PFNNVNMULTISAMPLESTATEGETALPHATOCOVERAGEENABLEPROC)(
    const NVNmultisampleState*);
typedef NVNboolean (*PFNNVNMULTISAMPLESTATEGETALPHATOCOVERAGEDITHERPROC)(
    const NVNmultisampleState*);
typedef void (*PFNNVNMULTISAMPLESTATESETRASTERSAMPLESPROC)(NVNmultisampleState*, int);
typedef int (*PFNNVNMULTISAMPLESTATEGETRASTERSAMPLESPROC)(NVNmultisampleState*);
typedef void (*PFNNVNMULTISAMPLESTATESETCOVERAGEMODULATIONMODEPROC)(NVNmultisampleState*,
                                                                    NVNcoverageModulationMode);
typedef NVNcoverageModulationMode (*PFNNVNMULTISAMPLESTATEGETCOVERAGEMODULATIONMODEPROC)(
    const NVNmultisampleState*);
typedef void (*PFNNVNMULTISAMPLESTATESETCOVERAGETOCOLORENABLEPROC)(NVNmultisampleState*,
                                                                   NVNboolean);
typedef NVNboolean (*PFNNVNMULTISAMPLESTATEGETCOVERAGETOCOLORENABLEPROC)(
    const NVNmultisampleState*);
typedef void (*PFNNVNMULTISAMPLESTATESETCOVERAGETOCOLOROUTPUTPROC)(NVNmultisampleState*, int);
typedef int (*PFNNVNMULTISAMPLESTATEGETCOVERAGETOCOLOROUTPUTPROC)(const NVNmultisampleState*);
typedef void (*PFNNVNMULTISAMPLESTATESETSAMPLELOCATIONSENABLEPROC)(NVNmultisampleState*,
                                                                   NVNboolean);
typedef NVNboolean (*PFNNVNMULTISAMPLESTATEGETSAMPLELOCATIONSENABLEPROC)(
    const NVNmultisampleState*);
typedef void (*PFNNVNMULTISAMPLESTATEGETSAMPLELOCATIONSGRIDPROC)(NVNmultisampleState*, int*, int*);
typedef void (*PFNNVNMULTISAMPLESTATESETSAMPLELOCATIONSGRIDENABLEPROC)(NVNmultisampleState*,
                                                                       NVNboolean);
typedef NVNboolean (*PFNNVNMULTISAMPLESTATEGETSAMPLELOCATIONSGRIDENABLEPROC)(
    const NVNmultisampleState*);
typedef void (*PFNNVNMULTISAMPLESTATESETSAMPLELOCATIONSPROC)(NVNmultisampleState*, int, int,
                                                             const float*);
typedef void (*PFNNVNPOLYGONSTATESETDEFAULTSPROC)(NVNpolygonState*);
typedef void (*PFNNVNPOLYGONSTATESETCULLFACEPROC)(NVNpolygonState*, NVNface);
typedef void (*PFNNVNPOLYGONSTATESETFRONTFACEPROC)(NVNpolygonState*, NVNfrontFace);
typedef void (*PFNNVNPOLYGONSTATESETPOLYGONMODEPROC)(NVNpolygonState*, NVNpolygonMode);
typedef void (*PFNNVNPOLYGONSTATESETPOLYGONOFFSETENABLESPROC)(NVNpolygonState*, int);
typedef NVNface (*PFNNVNPOLYGONSTATEGETCULLFACEPROC)(const NVNpolygonState*);
typedef NVNfrontFace (*PFNNVNPOLYGONSTATEGETFRONTFACEPROC)(const NVNpolygonState*);
typedef NVNpolygonMode (*PFNNVNPOLYGONSTATEGETPOLYGONMODEPROC)(const NVNpolygonState*);
typedef NVNpolygonOffsetEnable (*PFNNVNPOLYGONSTATEGETPOLYGONOFFSETENABLESPROC)(
    const NVNpolygonState*);
typedef void (*PFNNVNDEPTHSTENCILSTATESETDEFAULTSPROC)(NVNdepthStencilState*);
typedef void (*PFNNVNDEPTHSTENCILSTATESETDEPTHTESTENABLEPROC)(NVNdepthStencilState*, NVNboolean);
typedef void (*PFNNVNDEPTHSTENCILSTATESETDEPTHWRITEENABLEPROC)(NVNdepthStencilState*, NVNboolean);
typedef void (*PFNNVNDEPTHSTENCILSTATESETDEPTHFUNCPROC)(NVNdepthStencilState*, NVNdepthFunc);
typedef void (*PFNNVNDEPTHSTENCILSTATESETSTENCILTESTENABLEPROC)(NVNdepthStencilState*, NVNboolean);
typedef void (*PFNNVNDEPTHSTENCILSTATESETSTENCILFUNCPROC)(NVNdepthStencilState*, NVNface,
                                                          NVNstencilFunc);
typedef void (*PFNNVNDEPTHSTENCILSTATESETSTENCILOPPROC)(NVNdepthStencilState*, NVNface,
                                                        NVNstencilOp, NVNstencilOp, NVNstencilOp);
typedef NVNboolean (*PFNNVNDEPTHSTENCILSTATEGETDEPTHTESTENABLEPROC)(const NVNdepthStencilState*);
typedef NVNboolean (*PFNNVNDEPTHSTENCILSTATEGETDEPTHWRITEENABLEPROC)(const NVNdepthStencilState*);
typedef NVNdepthFunc (*PFNNVNDEPTHSTENCILSTATEGETDEPTHFUNCPROC)(const NVNdepthStencilState*);
typedef NVNboolean (*PFNNVNDEPTHSTENCILSTATEGETSTENCILTESTENABLEPROC)(const NVNdepthStencilState*);
typedef NVNstencilFunc (*PFNNVNDEPTHSTENCILSTATEGETSTENCILFUNCPROC)(const NVNdepthStencilState*,
                                                                    NVNface);
typedef void (*PFNNVNDEPTHSTENCILSTATEGETSTENCILOPPROC)(const NVNdepthStencilState*, NVNface,
                                                        NVNstencilOp*, NVNstencilOp*,
                                                        NVNstencilOp*);
typedef void (*PFNNVNVERTEXATTRIBSTATESETDEFAULTSPROC)(NVNvertexAttribState*);
typedef void (*PFNNVNVERTEXATTRIBSTATESETFORMATPROC)(NVNvertexAttribState*, NVNformat, ptrdiff_t);
typedef void (*PFNNVNVERTEXATTRIBSTATESETSTREAMINDEXPROC)(NVNvertexAttribState*, int);
typedef void (*PFNNVNVERTEXATTRIBSTATEGETFORMATPROC)(const NVNvertexAttribState*, NVNformat*,
                                                     ptrdiff_t*);
typedef int (*PFNNVNVERTEXATTRIBSTATEGETSTREAMINDEXPROC)(const NVNvertexAttribState*);
typedef void (*PFNNVNVERTEXSTREAMSTATESETDEFAULTSPROC)(NVNvertexStreamState*);
typedef void (*PFNNVNVERTEXSTREAMSTATESETSTRIDEPROC)(NVNvertexStreamState*, ptrdiff_t);
typedef void (*PFNNVNVERTEXSTREAMSTATESETDIVISORPROC)(NVNvertexStreamState*, int);
typedef ptrdiff_t (*PFNNVNVERTEXSTREAMSTATEGETSTRIDEPROC)(const NVNvertexStreamState*);
typedef int (*PFNNVNVERTEXSTREAMSTATEGETDIVISORPROC)(const NVNvertexStreamState*);
typedef NVNboolean (*PFNNVNCOMMANDBUFFERINITIALIZEPROC)(NVNcommandBuffer*, NVNdevice*);
typedef void (*PFNNVNCOMMANDBUFFERFINALIZEPROC)(NVNcommandBuffer*);
typedef void (*PFNNVNCOMMANDBUFFERSETDEBUGLABELPROC)(NVNcommandBuffer*, const char*);
typedef void (*PFNNVNCOMMANDBUFFERSETMEMORYCALLBACKPROC)(NVNcommandBuffer*,
                                                         PFNNVNCOMMANDBUFFERMEMORYCALLBACKPROC);
typedef void (*PFNNVNCOMMANDBUFFERSETMEMORYCALLBACKDATAPROC)(NVNcommandBuffer*, void*);
typedef void (*PFNNVNCOMMANDBUFFERADDCOMMANDMEMORYPROC)(NVNcommandBuffer*, const NVNmemoryPool*,
                                                        ptrdiff_t, size_t);
typedef void (*PFNNVNCOMMANDBUFFERADDCONTROLMEMORYPROC)(NVNcommandBuffer*, void*, size_t);
typedef size_t (*PFNNVNCOMMANDBUFFERGETCOMMANDMEMORYSIZEPROC)(const NVNcommandBuffer*);
typedef size_t (*PFNNVNCOMMANDBUFFERGETCOMMANDMEMORYUSEDPROC)(const NVNcommandBuffer*);
typedef size_t (*PFNNVNCOMMANDBUFFERGETCOMMANDMEMORYFREEPROC)(const NVNcommandBuffer*);
typedef size_t (*PFNNVNCOMMANDBUFFERGETCONTROLMEMORYSIZEPROC)(const NVNcommandBuffer*);
typedef size_t (*PFNNVNCOMMANDBUFFERGETCONTROLMEMORYUSEDPROC)(const NVNcommandBuffer*);
typedef size_t (*PFNNVNCOMMANDBUFFERGETCONTROLMEMORYFREEPROC)(const NVNcommandBuffer*);
typedef void (*PFNNVNCOMMANDBUFFERBEGINRECORDINGPROC)(NVNcommandBuffer*);
typedef NVNcommandHandle (*PFNNVNCOMMANDBUFFERENDRECORDINGPROC)(NVNcommandBuffer*);
typedef void (*PFNNVNCOMMANDBUFFERCALLCOMMANDSPROC)(NVNcommandBuffer*, int,
                                                    const NVNcommandHandle*);
typedef void (*PFNNVNCOMMANDBUFFERCOPYCOMMANDSPROC)(NVNcommandBuffer*, int,
                                                    const NVNcommandHandle*);
typedef void (*PFNNVNCOMMANDBUFFERBINDBLENDSTATEPROC)(NVNcommandBuffer*, const NVNblendState*);
typedef void (*PFNNVNCOMMANDBUFFERBINDCHANNELMASKSTATEPROC)(NVNcommandBuffer*,
                                                            const NVNchannelMaskState*);
typedef void (*PFNNVNCOMMANDBUFFERBINDCOLORSTATEPROC)(NVNcommandBuffer*, const NVNcolorState*);
typedef void (*PFNNVNCOMMANDBUFFERBINDMULTISAMPLESTATEPROC)(NVNcommandBuffer*,
                                                            const NVNmultisampleState*);
typedef void (*PFNNVNCOMMANDBUFFERBINDPOLYGONSTATEPROC)(NVNcommandBuffer*, const NVNpolygonState*);
typedef void (*PFNNVNCOMMANDBUFFERBINDDEPTHSTENCILSTATEPROC)(NVNcommandBuffer*,
                                                             const NVNdepthStencilState*);
typedef void (*PFNNVNCOMMANDBUFFERBINDVERTEXATTRIBSTATEPROC)(NVNcommandBuffer*, int,
                                                             const NVNvertexAttribState*);
typedef void (*PFNNVNCOMMANDBUFFERBINDVERTEXSTREAMSTATEPROC)(NVNcommandBuffer*, int,
                                                             const NVNvertexStreamState*);
typedef void (*PFNNVNCOMMANDBUFFERBINDPROGRAMPROC)(NVNcommandBuffer*, const NVNprogram*, int);
typedef void (*PFNNVNCOMMANDBUFFERBINDVERTEXBUFFERPROC)(NVNcommandBuffer*, int, NVNbufferAddress,
                                                        size_t);
typedef void (*PFNNVNCOMMANDBUFFERBINDVERTEXBUFFERSPROC)(NVNcommandBuffer*, int, int,
                                                         const NVNbufferRange*);
typedef void (*PFNNVNCOMMANDBUFFERBINDUNIFORMBUFFERPROC)(NVNcommandBuffer*, NVNshaderStage, int,
                                                         NVNbufferAddress, size_t);
typedef void (*PFNNVNCOMMANDBUFFERBINDUNIFORMBUFFERSPROC)(NVNcommandBuffer*, NVNshaderStage, int,
                                                          int, const NVNbufferRange*);
typedef void (*PFNNVNCOMMANDBUFFERBINDTRANSFORMFEEDBACKBUFFERPROC)(NVNcommandBuffer*, int,
                                                                   NVNbufferAddress, size_t);
typedef void (*PFNNVNCOMMANDBUFFERBINDTRANSFORMFEEDBACKBUFFERSPROC)(NVNcommandBuffer*, int, int,
                                                                    const NVNbufferRange*);
typedef void (*PFNNVNCOMMANDBUFFERBINDSTORAGEBUFFERPROC)(NVNcommandBuffer*, NVNshaderStage, int,
                                                         NVNbufferAddress, size_t);
typedef void (*PFNNVNCOMMANDBUFFERBINDSTORAGEBUFFERSPROC)(NVNcommandBuffer*, NVNshaderStage, int,
                                                          int, const NVNbufferRange*);
typedef void (*PFNNVNCOMMANDBUFFERBINDTEXTUREPROC)(NVNcommandBuffer*, NVNshaderStage, int,
                                                   NVNtextureHandle);
typedef void (*PFNNVNCOMMANDBUFFERBINDTEXTURESPROC)(NVNcommandBuffer*, NVNshaderStage, int, int,
                                                    const NVNtextureHandle*);
typedef void (*PFNNVNCOMMANDBUFFERBINDIMAGEPROC)(NVNcommandBuffer*, NVNshaderStage, int,
                                                 NVNimageHandle);
typedef void (*PFNNVNCOMMANDBUFFERBINDIMAGESPROC)(NVNcommandBuffer*, NVNshaderStage, int, int,
                                                  const NVNimageHandle*);
typedef void (*PFNNVNCOMMANDBUFFERSETPATCHSIZEPROC)(NVNcommandBuffer*, int);
typedef void (*PFNNVNCOMMANDBUFFERSETINNERTESSELLATIONLEVELSPROC)(NVNcommandBuffer*, const float*);
typedef void (*PFNNVNCOMMANDBUFFERSETOUTERTESSELLATIONLEVELSPROC)(NVNcommandBuffer*, const float*);
typedef void (*PFNNVNCOMMANDBUFFERSETPRIMITIVERESTARTPROC)(NVNcommandBuffer*, NVNboolean, int);
typedef void (*PFNNVNCOMMANDBUFFERBEGINTRANSFORMFEEDBACKPROC)(NVNcommandBuffer*, NVNbufferAddress);
typedef void (*PFNNVNCOMMANDBUFFERENDTRANSFORMFEEDBACKPROC)(NVNcommandBuffer*, NVNbufferAddress);
typedef void (*PFNNVNCOMMANDBUFFERPAUSETRANSFORMFEEDBACKPROC)(NVNcommandBuffer*, NVNbufferAddress);
typedef void (*PFNNVNCOMMANDBUFFERRESUMETRANSFORMFEEDBACKPROC)(NVNcommandBuffer*, NVNbufferAddress);
typedef void (*PFNNVNCOMMANDBUFFERDRAWTRANSFORMFEEDBACKPROC)(NVNcommandBuffer*, NVNdrawPrimitive,
                                                             NVNbufferAddress);
typedef void (*PFNNVNCOMMANDBUFFERDRAWARRAYSPROC)(NVNcommandBuffer*, NVNdrawPrimitive, int, int);
typedef void (*PFNNVNCOMMANDBUFFERDRAWELEMENTSPROC)(NVNcommandBuffer*, NVNdrawPrimitive,
                                                    NVNindexType, int, NVNbufferAddress);
typedef void (*PFNNVNCOMMANDBUFFERDRAWELEMENTSBASEVERTEXPROC)(NVNcommandBuffer*, NVNdrawPrimitive,
                                                              NVNindexType, int, NVNbufferAddress,
                                                              int);
typedef void (*PFNNVNCOMMANDBUFFERDRAWARRAYSINSTANCEDPROC)(NVNcommandBuffer*, NVNdrawPrimitive, int,
                                                           int, int, int);
typedef void (*PFNNVNCOMMANDBUFFERDRAWELEMENTSINSTANCEDPROC)(NVNcommandBuffer*, NVNdrawPrimitive,
                                                             NVNindexType, int, NVNbufferAddress,
                                                             int, int, int);
typedef void (*PFNNVNCOMMANDBUFFERDRAWARRAYSINDIRECTPROC)(NVNcommandBuffer*, NVNdrawPrimitive,
                                                          NVNbufferAddress);
typedef void (*PFNNVNCOMMANDBUFFERDRAWELEMENTSINDIRECTPROC)(NVNcommandBuffer*, NVNdrawPrimitive,
                                                            NVNindexType, NVNbufferAddress,
                                                            NVNbufferAddress);
typedef void (*PFNNVNCOMMANDBUFFERMULTIDRAWARRAYSINDIRECTCOUNTPROC)(
    NVNcommandBuffer*, NVNdrawPrimitive, NVNbufferAddress, NVNbufferAddress, int, ptrdiff_t);
typedef void (*PFNNVNCOMMANDBUFFERMULTIDRAWELEMENTSINDIRECTCOUNTPROC)(
    NVNcommandBuffer*, NVNdrawPrimitive, NVNindexType, NVNbufferAddress, NVNbufferAddress,
    NVNbufferAddress, int, ptrdiff_t);
typedef void (*PFNNVNCOMMANDBUFFERCLEARCOLORPROC)(NVNcommandBuffer*, int, const float*, int);
typedef void (*PFNNVNCOMMANDBUFFERCLEARCOLORIPROC)(NVNcommandBuffer*, int, const int*, int);
typedef void (*PFNNVNCOMMANDBUFFERCLEARCOLORUIPROC)(NVNcommandBuffer*, int, const uint32_t*, int);
typedef void (*PFNNVNCOMMANDBUFFERCLEARDEPTHSTENCILPROC)(NVNcommandBuffer*, float, NVNboolean, int,
                                                         int);
typedef void (*PFNNVNCOMMANDBUFFERDISPATCHCOMPUTEPROC)(NVNcommandBuffer*, int, int, int);
typedef void (*PFNNVNCOMMANDBUFFERDISPATCHCOMPUTEINDIRECTPROC)(NVNcommandBuffer*, NVNbufferAddress);
typedef void (*PFNNVNCOMMANDBUFFERSETVIEWPORTPROC)(NVNcommandBuffer*, int, int, int, int);
typedef void (*PFNNVNCOMMANDBUFFERSETVIEWPORTSPROC)(NVNcommandBuffer*, int, int, const float*);
typedef void (*PFNNVNCOMMANDBUFFERSETVIEWPORTSWIZZLESPROC)(NVNcommandBuffer*, int, int,
                                                           const NVNviewportSwizzle*);
typedef void (*PFNNVNCOMMANDBUFFERSETSCISSORPROC)(NVNcommandBuffer*, int, int, int, int);
typedef void (*PFNNVNCOMMANDBUFFERSETSCISSORSPROC)(NVNcommandBuffer*, int, int, const int*);
typedef void (*PFNNVNCOMMANDBUFFERSETDEPTHRANGEPROC)(NVNcommandBuffer*, float, float);
typedef void (*PFNNVNCOMMANDBUFFERSETDEPTHBOUNDSPROC)(NVNcommandBuffer*, NVNboolean, float, float);
typedef void (*PFNNVNCOMMANDBUFFERSETDEPTHRANGESPROC)(NVNcommandBuffer*, int, int, const float*);
typedef void (*PFNNVNCOMMANDBUFFERSETTILEDCACHEACTIONPROC)(NVNcommandBuffer*, NVNtiledCacheAction);
typedef void (*PFNNVNCOMMANDBUFFERSETTILEDCACHETILESIZEPROC)(NVNcommandBuffer*, int, int);
typedef void (*PFNNVNCOMMANDBUFFERBINDSEPARATETEXTUREPROC)(NVNcommandBuffer*, NVNshaderStage, int,
                                                           NVNseparateTextureHandle);
typedef void (*PFNNVNCOMMANDBUFFERBINDSEPARATESAMPLERPROC)(NVNcommandBuffer*, NVNshaderStage, int,
                                                           NVNseparateSamplerHandle);
typedef void (*PFNNVNCOMMANDBUFFERBINDSEPARATETEXTURESPROC)(NVNcommandBuffer*, NVNshaderStage, int,
                                                            int, const NVNseparateTextureHandle*);
typedef void (*PFNNVNCOMMANDBUFFERBINDSEPARATESAMPLERSPROC)(NVNcommandBuffer*, NVNshaderStage, int,
                                                            int, const NVNseparateSamplerHandle*);
typedef void (*PFNNVNCOMMANDBUFFERSETSTENCILVALUEMASKPROC)(NVNcommandBuffer*, NVNface, int);
typedef void (*PFNNVNCOMMANDBUFFERSETSTENCILMASKPROC)(NVNcommandBuffer*, NVNface, int);
typedef void (*PFNNVNCOMMANDBUFFERSETSTENCILREFPROC)(NVNcommandBuffer*, NVNface, int);
typedef void (*PFNNVNCOMMANDBUFFERSETBLENDCOLORPROC)(NVNcommandBuffer*, const float*);
typedef void (*PFNNVNCOMMANDBUFFERSETPOINTSIZEPROC)(NVNcommandBuffer*, float);
typedef void (*PFNNVNCOMMANDBUFFERSETLINEWIDTHPROC)(NVNcommandBuffer*, float);
typedef void (*PFNNVNCOMMANDBUFFERSETPOLYGONOFFSETCLAMPPROC)(NVNcommandBuffer*, float, float,
                                                             float);
typedef void (*PFNNVNCOMMANDBUFFERSETALPHAREFPROC)(NVNcommandBuffer*, float);
typedef void (*PFNNVNCOMMANDBUFFERSETSAMPLEMASKPROC)(NVNcommandBuffer*, int);
typedef void (*PFNNVNCOMMANDBUFFERSETRASTERIZERDISCARDPROC)(NVNcommandBuffer*, NVNboolean);
typedef void (*PFNNVNCOMMANDBUFFERSETDEPTHCLAMPPROC)(NVNcommandBuffer*, NVNboolean);
typedef void (*PFNNVNCOMMANDBUFFERSETCONSERVATIVERASTERENABLEPROC)(NVNcommandBuffer*, NVNboolean);
typedef void (*PFNNVNCOMMANDBUFFERSETCONSERVATIVERASTERDILATEPROC)(NVNcommandBuffer*, float);
typedef void (*PFNNVNCOMMANDBUFFERSETSUBPIXELPRECISIONBIASPROC)(NVNcommandBuffer*, int, int);
typedef void (*PFNNVNCOMMANDBUFFERCOPYBUFFERTOTEXTUREPROC)(NVNcommandBuffer*, NVNbufferAddress,
                                                           const NVNtexture*, const NVNtextureView*,
                                                           const NVNcopyRegion*, int);
typedef void (*PFNNVNCOMMANDBUFFERCOPYTEXTURETOBUFFERPROC)(NVNcommandBuffer*, const NVNtexture*,
                                                           const NVNtextureView*,
                                                           const NVNcopyRegion*, NVNbufferAddress,
                                                           int);
typedef void (*PFNNVNCOMMANDBUFFERCOPYTEXTURETOTEXTUREPROC)(NVNcommandBuffer*, const NVNtexture*,
                                                            const NVNtextureView*,
                                                            const NVNcopyRegion*, const NVNtexture*,
                                                            const NVNtextureView*,
                                                            const NVNcopyRegion*, int);
typedef void (*PFNNVNCOMMANDBUFFERCOPYBUFFERTOBUFFERPROC)(NVNcommandBuffer*, NVNbufferAddress,
                                                          NVNbufferAddress, size_t, int);
typedef void (*PFNNVNCOMMANDBUFFERCLEARBUFFERPROC)(NVNcommandBuffer*, NVNbufferAddress, size_t,
                                                   uint32_t);
typedef void (*PFNNVNCOMMANDBUFFERCLEARTEXTUREPROC)(NVNcommandBuffer*, const NVNtexture*,
                                                    const NVNtextureView*, const NVNcopyRegion*,
                                                    const float*, int);
typedef void (*PFNNVNCOMMANDBUFFERCLEARTEXTUREIPROC)(NVNcommandBuffer*, const NVNtexture*,
                                                     const NVNtextureView*, const NVNcopyRegion*,
                                                     const int*, int);
typedef void (*PFNNVNCOMMANDBUFFERCLEARTEXTUREUIPROC)(NVNcommandBuffer*, const NVNtexture*,
                                                      const NVNtextureView*, const NVNcopyRegion*,
                                                      const uint32_t*, int);
typedef void (*PFNNVNCOMMANDBUFFERUPDATEUNIFORMBUFFERPROC)(NVNcommandBuffer*, NVNbufferAddress,
                                                           size_t, ptrdiff_t, size_t, const void*);
typedef void (*PFNNVNCOMMANDBUFFERREPORTCOUNTERPROC)(NVNcommandBuffer*, NVNcounterType,
                                                     NVNbufferAddress);
typedef void (*PFNNVNCOMMANDBUFFERRESETCOUNTERPROC)(NVNcommandBuffer*, NVNcounterType);
typedef void (*PFNNVNCOMMANDBUFFERREPORTVALUEPROC)(NVNcommandBuffer*, uint32_t, NVNbufferAddress);
typedef void (*PFNNVNCOMMANDBUFFERSETRENDERENABLEPROC)(NVNcommandBuffer*, NVNboolean);
typedef void (*PFNNVNCOMMANDBUFFERSETRENDERENABLECONDITIONALPROC)(NVNcommandBuffer*,
                                                                  NVNconditionalRenderMode,
                                                                  NVNbufferAddress);
typedef void (*PFNNVNCOMMANDBUFFERSETRENDERTARGETSPROC)(NVNcommandBuffer*, int,
                                                        const NVNtexture* const*,
                                                        const NVNtextureView* const*,
                                                        const NVNtexture*, const NVNtextureView*);
typedef void (*PFNNVNCOMMANDBUFFERDISCARDCOLORPROC)(NVNcommandBuffer*, int);
typedef void (*PFNNVNCOMMANDBUFFERDISCARDDEPTHSTENCILPROC)(NVNcommandBuffer*);
typedef void (*PFNNVNCOMMANDBUFFERDOWNSAMPLEPROC)(NVNcommandBuffer*, const NVNtexture*,
                                                  const NVNtexture*);
typedef void (*PFNNVNCOMMANDBUFFERTILEDDOWNSAMPLEPROC)(NVNcommandBuffer*, const NVNtexture*,
                                                       const NVNtexture*);
typedef void (*PFNNVNCOMMANDBUFFERDOWNSAMPLETEXTUREVIEWPROC)(NVNcommandBuffer*, const NVNtexture*,
                                                             const NVNtextureView*,
                                                             const NVNtexture*,
                                                             const NVNtextureView*);
typedef void (*PFNNVNCOMMANDBUFFERTILEDDOWNSAMPLETEXTUREVIEWPROC)(NVNcommandBuffer*,
                                                                  const NVNtexture*,
                                                                  const NVNtextureView*,
                                                                  const NVNtexture*,
                                                                  const NVNtextureView*);
typedef void (*PFNNVNCOMMANDBUFFERBARRIERPROC)(NVNcommandBuffer*, int);
typedef void (*PFNNVNCOMMANDBUFFERWAITSYNCPROC)(NVNcommandBuffer*, const NVNsync*);
typedef void (*PFNNVNCOMMANDBUFFERFENCESYNCPROC)(NVNcommandBuffer*, NVNsync*, NVNsyncCondition,
                                                 int);
typedef void (*PFNNVNCOMMANDBUFFERSETTEXTUREPOOLPROC)(NVNcommandBuffer*, const NVNtexturePool*);
typedef void (*PFNNVNCOMMANDBUFFERSETSAMPLERPOOLPROC)(NVNcommandBuffer*, const NVNsamplerPool*);
typedef void (*PFNNVNCOMMANDBUFFERSETSHADERSCRATCHMEMORYPROC)(NVNcommandBuffer*,
                                                              const NVNmemoryPool*, ptrdiff_t,
                                                              size_t);
typedef void (*PFNNVNCOMMANDBUFFERSAVEZCULLDATAPROC)(NVNcommandBuffer*, NVNbufferAddress, size_t);
typedef void (*PFNNVNCOMMANDBUFFERRESTOREZCULLDATAPROC)(NVNcommandBuffer*, NVNbufferAddress,
                                                        size_t);
typedef void (*PFNNVNCOMMANDBUFFERSETCOPYROWSTRIDEPROC)(NVNcommandBuffer*, ptrdiff_t);
typedef void (*PFNNVNCOMMANDBUFFERSETCOPYIMAGESTRIDEPROC)(NVNcommandBuffer*, ptrdiff_t);
typedef ptrdiff_t (*PFNNVNCOMMANDBUFFERGETCOPYROWSTRIDEPROC)(const NVNcommandBuffer*);
typedef ptrdiff_t (*PFNNVNCOMMANDBUFFERGETCOPYIMAGESTRIDEPROC)(const NVNcommandBuffer*);
typedef void (*PFNNVNCOMMANDBUFFERDRAWTEXTUREPROC)(NVNcommandBuffer*, NVNtextureHandle,
                                                   const NVNdrawTextureRegion*,
                                                   const NVNdrawTextureRegion*);
typedef NVNboolean (*PFNNVNPROGRAMSETSUBROUTINELINKAGEPROC)(NVNprogram*, int,
                                                            const NVNsubroutineLinkageMapPtr*);
typedef void (*PFNNVNCOMMANDBUFFERSETPROGRAMSUBROUTINESPROC)(NVNcommandBuffer*, NVNprogram*,
                                                             NVNshaderStage, const int, const int,
                                                             const int*);
typedef void (*PFNNVNCOMMANDBUFFERBINDCOVERAGEMODULATIONTABLEPROC)(NVNcommandBuffer*, const float*);
typedef void (*PFNNVNCOMMANDBUFFERRESOLVEDEPTHBUFFERPROC)(NVNcommandBuffer*);
typedef void (*PFNNVNCOMMANDBUFFERPUSHDEBUGGROUPSTATICPROC)(NVNcommandBuffer*, uint32_t,
                                                            const char*);
typedef void (*PFNNVNCOMMANDBUFFERPUSHDEBUGGROUPDYNAMICPROC)(NVNcommandBuffer*, uint32_t,
                                                             const char*);
typedef void (*PFNNVNCOMMANDBUFFERPUSHDEBUGGROUPPROC)(NVNcommandBuffer*, uint32_t, const char*);
typedef void (*PFNNVNCOMMANDBUFFERPOPDEBUGGROUPPROC)(NVNcommandBuffer*);
typedef void (*PFNNVNCOMMANDBUFFERPOPDEBUGGROUPIDPROC)(NVNcommandBuffer*, uint32_t);
typedef void (*PFNNVNCOMMANDBUFFERINSERTDEBUGMARKERSTATICPROC)(NVNcommandBuffer*, uint32_t,
                                                               const char*);
typedef void (*PFNNVNCOMMANDBUFFERINSERTDEBUGMARKERDYNAMICPROC)(NVNcommandBuffer*, uint32_t,
                                                                const char*);
typedef void (*PFNNVNCOMMANDBUFFERINSERTDEBUGMARKERPROC)(NVNcommandBuffer*, const char*);
typedef PFNNVNCOMMANDBUFFERMEMORYCALLBACKPROC (*PFNNVNCOMMANDBUFFERGETMEMORYCALLBACKPROC)(
    const NVNcommandBuffer*);
typedef void (*PFNNVNCOMMANDBUFFERGETMEMORYCALLBACKDATAPROC)(const NVNcommandBuffer*);
typedef NVNboolean (*PFNNVNCOMMANDBUFFERISRECORDINGPROC)(const NVNcommandBuffer*);
typedef NVNboolean (*PFNNVNSYNCINITIALIZEPROC)(NVNsync*, NVNdevice*);
typedef void (*PFNNVNSYNCFINALIZEPROC)(NVNsync*);
typedef void (*PFNNVNSYNCSETDEBUGLABELPROC)(NVNsync*, const char*);
typedef void (*PFNNVNQUEUEFENCESYNCPROC)(NVNqueue*, NVNsync*, NVNsyncCondition, int);
typedef NVNsyncWaitResult (*PFNNVNSYNCWAITPROC)(const NVNsync*, uint64_t);
typedef NVNboolean (*PFNNVNQUEUEWAITSYNCPROC)(NVNqueue*, const NVNsync*);
typedef void (*PFNNVNEVENTBUILDERSETDEFAULTSPROC)(NVNeventBuilder*);
typedef void (*PFNNVNEVENTBUILDERSETSTORAGEPROC)(NVNeventBuilder*, const NVNmemoryPool*, int64_t);
typedef NVNboolean (*PFNNVNEVENTINITIALIZEPROC)(NVNevent*, const NVNeventBuilder*);
typedef void (*PFNNVNEVENTFINALIZEPROC)(NVNevent*);
typedef uint32_t (*PFNNVNEVENTGETVALUEPROC)(const NVNevent*);
typedef void (*PFNNVNEVENTSIGNALPROC)(NVNevent*, NVNeventSignalMode, uint32_t);
typedef void (*PFNNVNCOMMANDBUFFERWAITEVENTPROC)(NVNcommandBuffer*, const NVNevent*,
                                                 NVNeventWaitMode, uint32_t);
typedef void (*PFNNVNCOMMANDBUFFERSIGNALEVENTPROC)(NVNcommandBuffer*, const NVNevent*,
                                                   NVNeventSignalMode, NVNeventSignalLocation, int,
                                                   uint32_t);