/*
 * Copyright (c) Atmosphère-NX
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include "nn/nn_common.hpp"

#include "os_internal_critical_section.hpp"

/* Assuming HOS. */
#include "os_internal_condition_variable_impl.os.horizon.hpp"

namespace nn::os::detail {

    class InternalConditionVariable {
      private:
        InternalConditionVariableImplByHorizon m_impl;

      public:
        constexpr InternalConditionVariable() : m_impl() { /* ... */
        }

        constexpr void Initialize() { m_impl.Initialize(); }

        void Signal() { m_impl.Signal(); }

        void Broadcast() { m_impl.Broadcast(); }

        void Wait(InternalCriticalSection* cs) { m_impl.Wait(cs); }

        ConditionVariableStatus TimedWait(InternalCriticalSection* cs, const TimeoutHelper& timeout_helper) {
            return m_impl.TimedWait(cs, timeout_helper);
        }
    };

    /* TODO: storage. */
    using InternalConditionVariableStorage = InternalConditionVariable;

} // namespace nn::os::detail